local addon, shared = ...

local RELEASE = 99
local WDOGYIELD = 15
local INFORMATION = 5

---------------------
-- Variables
---------------------

_TeleporterV2 = {}
local TP = _TeleporterV2

local UIFrames = { abilities = {}, POPUPANCHOR = "CENTER" }
TP.UI = UIFrames

local UINeeded = true
local SVLoaded = false
local coroDead = false

local playerFound = true
local tpmenuVis = false
local itemidcnt = 0

local tprebuild = false

local TPMODE_POPUP = 1
local TPMODE_CLICK = 2
local TeleporterV2_Settings

local TPMODE_IMG = {
	"textures/TPMODE_POPUP.png",
	"textures/TPMODE_CLICK.png",
}

local tpabilities = {
	["A3C5AEC64D3793518"] = { p = 1, txt = "Soul Recall", type = "spell", able = false, use = nil, icon = nil },
	["A5A5C6D30430A9E3E"] = {
		p = 2,
		txt = "Gloamwood",
		type = "spell",
		able = false,
		use = nil,
		icon = nil,
		zoneid = "z0000001B2BB9E10E",
	},
	["A677B0D96691D0433"] = {
		p = 3,
		txt = "Stonefield",
		type = "spell",
		able = false,
		use = nil,
		icon = nil,
		zoneid = "z585230E5F68EA919",
	},
	["A768D08F826CDC3DB"] = {
		p = 4,
		txt = "Scarwood Reach",
		type = "spell",
		able = false,
		use = nil,
		icon = nil,
		zoneid = "z000000142C649218",
	},
	["A6B16924B96299E96"] = {
		p = 5,
		txt = "Droughlands",
		type = "spell",
		able = false,
		use = nil,
		icon = nil,
		zoneid = "z1416248E485F6684",
	},
	["A313102E6A9A460E8"] = {
		p = 6,
		txt = "Moonshade Highlands",
		type = "spell",
		able = false,
		use = nil,
		icon = nil,
		zoneid = "z0000001804F56C61",
	},
	["A657AA5389319EF0F"] = {
		p = 7,
		txt = "Ember Isle",
		type = "spell",
		able = false,
		use = nil,
		icon = nil,
		zoneid = "z76C88A5A51A38D90",
	},
	["TP_CHANCELOFLABORS"] = {
		p = 8,
		txt = "Iron Pine Peak",
		type = "item",
		able = false,
		use = nil,
		icon = "Data/\\UI\\item_icons\\totem_air_mundane_a.dds",
		item = "I731C1B4F46334030,293CCC1E8957C704,,,,,,",
		zoneid = "z00000016EB9ECBA5",
		id = 0,
	},
	["TP_WYRMBANESPIRE"] = {
		p = 9,
		txt = "Shimmersand",
		type = "item",
		able = false,
		use = nil,
		icon = "Data/\\UI\\item_icons\\totem_air_mundane_a.dds",
		item = "I139E7010C5722EA5,DF73A68C936CC83F,,,,,,",
		zoneid = "z000000069C1F0227",
		id = 0,
	},
	["TP_ZAREPHSRETURN"] = {
		p = 10,
		txt = "Stillmoor",
		type = "item",
		able = false,
		use = nil,
		icon = "Data/\\UI\\item_icons\\totem_air_mundane_a.dds",
		item = "I1C6AA9C8821E8F6D,22FC684EB50BD66F,,,,,,",
		zoneid = "z0000001A4AF8CD7A",
		id = 0,
	},
	["TP_HQUNSEEN"] = {
		p = 11,
		txt = "Meridian",
		type = "item",
		able = false,
		use = nil,
		icon = "Data/\\UI\\item_icons\\totem6.dds",
		item = "I2E86B87446CF32BF,4A4CA14475FECC39,,,,,,",
		id = 0,
	},
	["TP_TEMPEST_BAY"] = {
		p = 12,
		txt = "Tempest Bay",
		type = "item",
		able = false,
		use = nil,
		icon = "Data/\\UI\\item_icons\\totem_air_mundane.dds",
		zoneid = "z11173F9D259DAADE",
		item = "I4D97EE3EB79275CD,7EB547DFB8F5C0A7,,,,,,",
		id = 0,
	},
	["TP_BREVANIC_PORTAL"] = {
		p = 13,
		txt = "Brevanic Portal Generator",
		type = "item",
		able = false,
		use = nil,
		icon = "Data/\\UI\\item_icons\\fatestone_05_neutral_a.dds",
		item = "IFAFB17B78F862295,2372E487E1EDD0FA,,,,,,",
		id = 0,
	},
	["A5FAA42C94B361BD6"] = { p = 14, txt = "Summon Group: Earth", type = "spell", able = false, use = nil, icon = nil },
	["A6FA8AEF1A6A24562"] = { p = 15, txt = "Summon Group: Air", type = "spell", able = false, use = nil, icon = nil },
	["A598E67739FF9FE12"] = { p = 16, txt = "Summon Group: Fire", type = "spell", able = false, use = nil, icon = nil },
	["A6005565590545A0D"] = { p = 17, txt = "Summon Group: Water", type = "spell", able = false, use = nil, icon = nil },
	["A7ADD26548CAD37A8"] = { p = 18, txt = "Summon Group: Life", type = "spell", able = false, use = nil, icon = nil },
	["A5DF0C9E7AA17967F"] = { p = 19, txt = "Summon Group: Death", type = "spell", able = false, use = nil, icon = nil },
	["A5F77DAA65FAED9E3"] = { p = 20, txt = "Guild Rally Banner", type = "spell", able = false, use = nil, icon = nil },
	["TP_RALLYBANNER"] = {
		p = 21,
		txt = "Rally Banner",
		type = "item",
		able = false,
		use = nil,
		icon = "Data/\\UI\\item_icons\\scroll7.dds",
		item = "I1F832DB376787EBF,D912113BAA7304B3,,,,,,",
		id = 0,
	},
	["SH_SUMMON"] = {
		p = 22,
		txt = "Stronghold Summoner",
		type = "item",
		able = false,
		use = nil,
		icon = "Data/\\UI\\ability_icons\\tactician_barrier_augument_c.dds",
		item = "I3A3F06534DCB2F92,E118539693B1460D,,,,,,",
		id = 0,
	},
	["BP_BATTERY"] = {
		p = 23,
		txt = "Brevanic Portal Battery",
		type = "item",
		able = false,
		use = nil,
		icon = "Data/\\UI\\item_icons\\fatestone_05_frag_1_blue.dds",
		item = "I731242DB41B55C62,650D41367F7F0747,,,,,,",
		id = 0,
	},
	["A665FDAC7EDD37636"] = {
		p = 24,
		txt = "Patron's Fast Pass",
		type = "spell",
		able = false,
		use = nil,
		icon = "Data/\\UI\\item_icons\\fatestone_05_neutral_a.dds",
	},
	["A473DB77B2A283628"] = {
		p = 25,
		txt = "Planewalker's Call",
		type = "spell",
		able = false,
		use = nil,
		icon = "Data/\\UI\\item_icons\\heal1a.dds",
	},
	["TP_OPIEWHISTLE"] = {
		p = 26,
		txt = "Opie's Practice Course",
		type = "item",
		able = false,
		use = nil,
		icon = "Data/\\UI\\item_icons\\horn_09.dds",
		zoneid = "z1E81B494CFA05AD0",
		item = "I2D6C96D5456765D3,37B53DEF5DAB0FC2,,,,,,",
		id = 0,
	},
	["TP_TOK"] = {
		p = 27,
		txt = "Tok's Proving Grounds",
		type = "item",
		able = false,
		use = nil,
		icon = "Data/\\UI\\item_icons\\20_sided_puzzle_box.dds",
		zoneid = "z26C912A40A8B2EF4",
		item = "I5EBB080CA4E68A67,0E6E71C3E59D75B9,,,,,,",
		id = 0,
	}, --
	["TP_CALLWEDDI"] = {
		p = 28,
		txt = "Callweddi",
		type = "item",
		able = false,
		use = nil,
		icon = "Data/\\UI\\item_icons\\druid-summon_faerie.dds",
		zoneid = "z0000001CE3FE8B2C",
		item = "I6E79C8D66F02E9FB,F64BFFE8C65733AB,,,,,,",
		id = 0,
	},
}

local _tpitems = {
	["I731C1B4F46334030,293CCC1E8957C704,,,,,,"] = "TP_CHANCELOFLABORS",
	["I139E7010C5722EA5,DF73A68C936CC83F,,,,,,"] = "TP_WYRMBANESPIRE",
	["I1C6AA9C8821E8F6D,22FC684EB50BD66F,,,,,,"] = "TP_ZAREPHSRETURN",
	["I2E86B87446CF32BF,4A4CA14475FECC39,,,,,,"] = "TP_HQUNSEEN",
	["IFAFB17B78F862295,2372E487E1EDD0FA,,,,,,"] = "TP_BREVANIC_PORTAL",
	["I4D97EE3EB79275CD,7EB547DFB8F5C0A7,,,,,,"] = "TP_TEMPEST_BAY",
	["I1F832DB376787EBF,D912113BAA7304B3,,,,,,"] = "TP_RALLYBANNER",
	["I3A3F06534DCB2F92,E118539693B1460D,,,,,,"] = "SH_SUMMON",
	["I731242DB41B55C62,650D41367F7F0747,,,,,,"] = "BP_BATTERY",
	["I2D6C96D5456765D3,37B53DEF5DAB0FC2,,,,,,"] = "TP_OPIEWHISTLE",
	["I5EBB080CA4E68A67,0E6E71C3E59D75B9,,,,,,"] = "TP_TOK",
	["I6E79C8D66F02E9FB,F64BFFE8C65733AB,,,,,,"] = "TP_CALLWEDDI",
}

local CDTIMES = {}
local tpframes = {}

for k, v in pairs(tpabilities) do
	tpframes[v.p] = k
end

local default_settings = {
	mmx = -1,
	mmy = -1,
	itemid = {},
	align = "C",
	mode = TPMODE_POPUP,
	locked = true,
	fs = 12,
	fade = 1,
}

---------------------
-- Functions
---------------------

local debuglevel = RELEASE

local function Debug(s, l)
	if (l or INFORMATION) >= debuglevel then
		print(s)
	end
end

-- local _watchdogyield = {}
local yieldcnt = 0
local function WATCHDOGWAIT(x)
	local rmx = Inspect.System.Watchdog()
	while rmx < 0.03 do
		yieldcnt = yieldcnt + 1
		Debug("#" .. yieldcnt .. ":rmx: " .. rmx .. " [" .. x .. "]", WDOGYIELD)
		-- _watchdogyield[yieldcnt] = { tx = os.date("%Y%m%d-%H:%M:%S"), m = x, tr = rmx }
		coroutine.yield()
		rmx = Inspect.System.Watchdog()
	end
end

local function MergeTable(o, n)
	for k, v in pairs(n) do
		if type(v) == "table" then
			if o[k] == nil then
				o[k] = {}
			end
			if type(o[k]) == "table" then
				MergeTable(o[k], n[k])
			end
		else
			if o[k] == nil then
				o[k] = v
			end
		end
	end
end

function TP.ShowPopup()
	if (Inspect.System.Secure() == true) or (TeleporterV2_Settings.locked == false) then
		return
	end

	if MINIMAPDOCKER then
		MINIMAPDOCKER.AUTOHIDE_DOCKED = false
	end
	tpmenuVis = true
	UIFrames.frame:SetVisible(true)
end

function TP.AttachPopup()
	local h_loc
	local v_loc
	local anchor

	if UIFrames.mm_button:GetLeft() >= (UIParent:GetWidth() / 2) then
		h_loc = "RIGHT"
	else
		h_loc = "LEFT"
	end

	if UIFrames.mm_button:GetTop() >= (UIParent:GetHeight() / 2) then
		v_loc = "BOTTOM"
	else
		v_loc = "TOP"
	end

	anchor = string.format("%s%s", v_loc, h_loc)

	if anchor ~= UIFrames.POPUPANCHOR then
		UIFrames.frame:ClearPoint(UIFrames.POPUPANCHOR)
		UIFrames.POPUPANCHOR = anchor
		UIFrames.frame:SetPoint(anchor, UIFrames.mm_button, "CENTER", 0, 0)
	end
end

function TP.ScaleFrames()
	local frw = 0
	local srw = 0
	local frh = 0
	local frx = {}
	UIFrames.HIDDEN:SetFontSize(TeleporterV2_Settings.fs)
	for k, v in pairs(UIFrames.abilities) do
		v.frame:SetHeight(TeleporterV2_Settings.fs * 2)
		v.icon:SetHeight(TeleporterV2_Settings.fs * 2)
		v.icon:SetWidth(TeleporterV2_Settings.fs * 2)
		v.text:SetFontSize(TeleporterV2_Settings.fs)
		v.cdt:SetFontSize(TeleporterV2_Settings.fs)
		local kx = tpframes[k]
		if tpabilities[kx].able then
			UIFrames.HIDDEN:SetText(tpabilities[kx].txt)
			frw = math.max(frw, UIFrames.HIDDEN:GetWidth())
			table.insert(frx, v.frame)
			if tpabilities[kx].p == 1 then
				srw = UIFrames.HIDDEN:GetWidth() * 2
				frw = math.max(frw, srw)
			end
		end
	end

	for k, v in pairs(frx) do
		v:SetWidth(frw + (TeleporterV2_Settings.fs * 2))
	end
	UIFrames.frame:SetWidth(frw + (TeleporterV2_Settings.fs * 2))
	UIFrames.header:SetWidth(frw + (TeleporterV2_Settings.fs * 2))
	UIFrames.frame:SetHeight(16 + (#frx * (TeleporterV2_Settings.fs * 2)))

	TP.AlignText(p)
end

function TP.CreateTPEntry(t, u, i)
	WATCHDOGWAIT("CreateTPEntry:1")
	local f = {}
	f.cd = false
	f.frame = UI.CreateFrame("Frame", "f.frame", UIFrames.frame)
	f.frame:SetSecureMode("restricted")
	f.frame:SetVisible(false)
	f.frame:SetHeight(32)
	f.frame:SetLayer(1)
	f.frame:SetBackgroundColor(0, 0, 0, 0.5)
	f.frame:EventAttach(Event.UI.Input.Mouse.Cursor.In, function(self, h)
		f.frame:SetBackgroundColor(0, 0.45, 0, 0.5)
	end, "Event.UI.Input.Mouse.Cursor.In")
	f.frame:EventAttach(Event.UI.Input.Mouse.Cursor.Out, function(self, h)
		if f.cd then
			f.frame:SetBackgroundColor(0.45, 0, 0, 0.5)
		else
			f.frame:SetBackgroundColor(0, 0, 0, 0.5)
		end
	end, "Event.UI.Input.Mouse.Cursor.Out")
	f.icon = UI.CreateFrame("Texture", "f.icon", f.frame)
	f.icon:SetHeight(32)
	f.icon:SetWidth(32)
	if i == nil then
		i = "Unknown"
	end
	f.icon:SetTexture("Rift", i)
	f.icon:SetPoint("TOPLEFT", f.frame, "TOPLEFT", 0, 0)
	f.icon:SetLayer(2)
	f.text = UI.CreateFrame("Text", "f.text", f.frame)
	f.text:SetFontSize(16)
	f.text:SetText(t)
	f.text:SetLayer(3)
	f.cdt = UI.CreateFrame("Text", "f.cd", f.frame)
	f.cdt:SetPoint("TOPRIGHT", f.icon, "TOPLEFT", 0, 0)
	f.cdt:SetFontSize(16)
	f.cdt:SetLayer(4)
	f.cdt:SetText("")
	f.cdt:SetFontColor(1, 1, 1)
	f.cdt:SetEffectGlow({ strength = 5, blurX = 2, blurY = 2 })
	return f
end

function TP.closePopup()
	if tpmenuVis then
		tpmenuVis = false
		UIFrames.frame:SetVisible(false)
	end
end

function TP.CreateUI()
	TP.context = UI.CreateContext(addon.identifier)
	TP.context:SetSecureMode("restricted")

	UIFrames.HIDDEN = UI.CreateFrame("Text", "UIFrames.HIDDEN", UI.CreateContext(addon.identifier .. ":2"))
	UIFrames.HIDDEN:SetVisible(false)

	UIFrames.mm_button = UI.CreateFrame("Texture", "UIFrames.mm_button", TP.context)
	UIFrames.mm_button:SetVisible(false)
	UIFrames.mm_button:SetHeight(36)
	UIFrames.mm_button:SetWidth(36)
	UIFrames.mm_button:SetLayer(2)

	if MINIMAPDOCKER then
		--MINIMAPDOCKER.Register(addon.identifier, UIFrames.mm_button, TP.closePopup)
		MINIMAPDOCKER.Register(addon.identifier, UIFrames.mm_button)
	else
		UIFrames.mm_button:EventAttach(Event.UI.Input.Mouse.Left.Down, function(self, h)
			if TeleporterV2_Settings.locked == false then
				local mouseData = Inspect.Mouse()
				self.sx = mouseData.x - UIFrames.mm_button:GetLeft()
				self.sy = mouseData.y - UIFrames.mm_button:GetTop()
				self.MouseDown = true
			end
		end, "Event.UI.Input.Mouse.Left.Down")

		UIFrames.mm_button:EventAttach(Event.UI.Input.Mouse.Cursor.Move, function(self, h)
			if self.MouseDown and (TeleporterV2_Settings.locked == false) then
				local nx, ny
				local mouseData = Inspect.Mouse()
				nx = mouseData.x - self.sx
				ny = mouseData.y - self.sy
				UIFrames.mm_button:SetPoint("TOPLEFT", UIParent, "TOPLEFT", nx, ny)
				TP.AttachPopup()
			end
		end, "Event.UI.Input.Mouse.Cursor.Move")

		UIFrames.mm_button:EventAttach(Event.UI.Input.Mouse.Left.Up, function(self, h)
			self.MouseDown = false
			TeleporterV2_Settings.mmx = UIFrames.mm_button:GetLeft()
			TeleporterV2_Settings.mmy = UIFrames.mm_button:GetTop()
		end, "Event.UI.Input.Mouse.Left.Up")

		UIFrames.mm_button:EventAttach(Event.UI.Input.Mouse.Right.Click, function(self, h)
			if Inspect.System.Secure() == false then
				TeleporterV2_Settings.locked = not TeleporterV2_Settings.locked
				if TeleporterV2_Settings.locked then
					UIFrames.mm_button:SetTexture(addon.identifier, "textures/mm_button.png")
				else
					UIFrames.mm_button:SetTexture(addon.identifier, "textures/mm_button_bw.png")
					UIFrames.frame:SetVisible(false)
					tpmenuVis = false
					popupFade = false
				end
			else
				print("System in secure state. Too dangerous to unlock right now. Try again later.")
			end
		end, "Event.UI.Input.Mouse.Right.Click")
	end

	UIFrames.mm_button:EventAttach(Event.UI.Input.Mouse.Left.Click, function(self, h)
		if (TeleporterV2_Settings.locked or MINIMAPDOCKER) and TeleporterV2_Settings.mode == TPMODE_CLICK then
			TP.ShowPopup()
		end
	end, "Event.UI.Input.Mouse.Left.Click")

	UIFrames.mm_button:EventAttach(Event.UI.Input.Mouse.Cursor.In, function(self, h)
		if (TeleporterV2_Settings.locked or MINIMAPDOCKER) and TeleporterV2_Settings.mode == TPMODE_POPUP then
			TP.ShowPopup()
		end
	end, "Event.UI.Input.Mouse.Cursor.In")

	UIFrames.mm_button:EventAttach(Event.UI.Input.Mouse.Wheel.Forward, function(self, h)
		if TeleporterV2_Settings.locked or MINIMAPDOCKER then
			if TeleporterV2_Settings.fs < 24 then
				TeleporterV2_Settings.fs = TeleporterV2_Settings.fs + 1
				TP.ScaleFrames()
			end
		end
	end, "Event.UI.Input.Mouse.Wheel.Forward")

	UIFrames.mm_button:EventAttach(Event.UI.Input.Mouse.Wheel.Back, function(self, h)
		if TeleporterV2_Settings.locked or MINIMAPDOCKER then
			if TeleporterV2_Settings.fs > 8 then
				TeleporterV2_Settings.fs = TeleporterV2_Settings.fs - 1
				TP.ScaleFrames()
			end
		end
	end, "Event.UI.Input.Mouse.Wheel.Back")

	WATCHDOGWAIT("CreateUI:1")

	UIFrames.frame = UI.CreateFrame("Frame", "UIFrames.frame", TP.context)
	UIFrames.frame:SetSecureMode("restricted")
	UIFrames.frame:SetVisible(false)
	UIFrames.header = UI.CreateFrame("Text", "UIFrames.header", UIFrames.frame)
	UIFrames.header:SetFontSize(16)
	UIFrames.header:SetText(shared.interface["TP_TITLE"])
	UIFrames.header:SetPoint("TOPLEFT", UIFrames.frame, "TOPLEFT", 16, 0)
	UIFrames.header:SetFontColor(1, 1, 1)
	UIFrames.header:SetBackgroundColor(0.45, 0, 0)

	UIFrames.header_icon = UI.CreateFrame("Texture", "UIFrames.header_icon", UIFrames.frame)
	UIFrames.header_icon:SetHeight(24)
	UIFrames.header_icon:SetPoint("TOPRIGHT", UIFrames.header, "TOPRIGHT")
	UIFrames.header_icon:SetLayer(UIFrames.header:GetLayer() + 10)

	UIFrames.header_icon:EventAttach(Event.UI.Input.Mouse.Left.Click, function(self, h)
		if Inspect.System.Secure() == false then
			if TeleporterV2_Settings.mode == TPMODE_POPUP then
				TeleporterV2_Settings.mode = TPMODE_CLICK
			else
				TeleporterV2_Settings.mode = TPMODE_POPUP
			end
			UIFrames.header_icon:SetTexture(addon.identifier, TPMODE_IMG[TeleporterV2_Settings.mode])
		end
	end, "Event.UI.Input.Mouse.Left.Click")

	for k, v in pairs(shared.lang) do
		tpabilities[k].txt = shared.lang[k]
	end

	for k, v in pairs(tpabilities) do
		if v.type == "spell" then
			if v.zoneid ~= nil then
				local d = Inspect.Zone.Detail(v.zoneid)
				tpabilities[k].txt = d.name
			else
				local d = Inspect.Ability.New.Detail(k)
				if d then
					tpabilities[k].txt = d.name
				end
			end
		end
		UIFrames.abilities[v.p] = TP.CreateTPEntry(tpabilities[k].txt, v.use, v.icon)
	end

	WATCHDOGWAIT("CreateUI:2")
end

function TP.setpopupOrder()
	if Inspect.System.Secure() == false and UINeeded == false then
		local _srt = {}

		for k, v in pairs(tpabilities) do
			if v.able == true then
				table.insert(_srt, v.p)
			else
				UIFrames.abilities[v.p].frame:SetVisible(false)
			end
		end

		table.sort(_srt)

		local prev = UIFrames.header

		for k, v in pairs(_srt) do
			UIFrames.abilities[v].frame:SetPoint("TOPLEFT", prev, "BOTTOMLEFT", 0, 0)
			UIFrames.abilities[v].frame:SetVisible(true)
			if UIFrames.abilities[v].MACRO == nil and tpabilities[tpframes[v]].use ~= nil then
				UIFrames.abilities[v].frame:EventMacroSet(Event.UI.Input.Mouse.Left.Click, tpabilities[tpframes[v]].use)
				UIFrames.abilities[v].icon:SetTexture("Rift", tpabilities[tpframes[v]].icon)
				UIFrames.abilities[v].MACRO = tpabilities[tpframes[v]].use
			end
			prev = UIFrames.abilities[v].frame
		end
		TP.ScaleFrames()
		tprebuild = false
	else
		tprebuild = true
	end
end

function TP.AlignText(p)
	for k, v in pairs(UIFrames.abilities) do
		v.text:ClearPoint("CENTERLEFT")
		v.text:ClearPoint("CENTER")
		v.text:ClearPoint("CENTERRIGHT")
		if p == "L" then
			v.text:SetPoint("CENTERLEFT", v.icon, "CENTERRIGHT", 0, 0)
		elseif p == "R" then
			v.text:SetPoint("CENTERRIGHT", v.frame, "CENTERRIGHT", 0, 0)
		else
			v.text:SetPoint("CENTER", v.frame, "CENTER", TeleporterV2_Settings.fs, 0)
		end
	end
end

function TP.SVLoaded()
	if TeleporterV2_Settings == nil then
		TeleporterV2_Settings = {}
	end
	if itemidcnt > 0 then
		TeleporterV2_Settings.itemid = nil
	end

	MergeTable(TeleporterV2_Settings, default_settings)
	if MINIMAPDOCKER then
		TeleporterV2_Settings.locked = true
	else
		if TeleporterV2_Settings.mmx == -1 then
			UIFrames.mm_button:SetPoint("TOPCENTER", UI.Native.MapMini, "BOTTOMCENTER", 0, 0)
			TeleporterV2_Settings.mmx = UIFrames.mm_button:GetLeft()
			TeleporterV2_Settings.mmy = UIFrames.mm_button:GetTop()
			UIFrames.mm_button:ClearPoint("TOPCENTER")
		end
		UIFrames.mm_button:SetPoint(
			"TOPLEFT",
			UIParent,
			"TOPLEFT",
			TeleporterV2_Settings.mmx,
			TeleporterV2_Settings.mmy
		)
	end

	if TeleporterV2_Settings.locked then
		UIFrames.mm_button:SetTexture(addon.identifier, "textures/mm_button.png")
	else
		UIFrames.mm_button:SetTexture(addon.identifier, "textures/mm_button_bw.png")
	end

	UIFrames.header_icon:SetTexture(addon.identifier, TPMODE_IMG[TeleporterV2_Settings.mode])

	TP.setpopupOrder()
	TP.AttachPopup()

	UIFrames.mm_button:SetVisible(true)

	LibVersionCheck.register(addon.toc.Identifier, addon.toc.Version)
end

local combatwarning = false
local popupFade = false

function TP.checkMouse()
	local md = Inspect.Mouse()
	local l = math.min(UIFrames.frame:GetLeft(), UIFrames.mm_button:GetLeft())
	local r = math.max(UIFrames.frame:GetRight(), UIFrames.mm_button:GetRight())
	local t = math.min(UIFrames.frame:GetTop(), UIFrames.mm_button:GetTop())
	local b = math.max(UIFrames.frame:GetBottom(), UIFrames.mm_button:GetBottom())

	if md.x < l or md.x > r or md.y < t or md.y > b then
		if popupFade == false then
			popupFade = Inspect.Time.Real()
		end
	else
		popupFade = false
		UIFrames.frame:SetAlpha(1)
	end
end

function TP.UpdateHandler()
	local frcnt = 0
	while true do
		if tpmenuVis == true then
			TP.checkMouse()
		end

		local tx = Inspect.Time.Real()
		local s = ""

		for k, v in pairs(CDTIMES) do
			local p = tpabilities[k].p
			if tx > v then
				UIFrames.abilities[p].frame:SetBackgroundColor(0, 0, 0, 0.5)
				UIFrames.abilities[p].cd = false
				CDTIMES[k] = nil
			else
				local dx = v - tx
				if dx > 300 then
					s = string.format("%dm", dx / 60)
				else
					local m = math.floor(dx / 60)
					local sc = dx - (m * 60)
					s = string.format("%d:%02d", m, sc)
				end
				UIFrames.abilities[p].cdt:SetText(s)
			end
			UIFrames.abilities[p].cdt:SetVisible(UIFrames.abilities[p].cd)
		end

		if UINeeded and playerFound then
			if Inspect.System.Secure() == false then
				if combatwarning then
					print("Out of combat, continuing with setup")
					combatwarning = false
				end
				TP.CreateUI()
				--TP.ScaleFrames()
				UINeeded = false
			else
				if combatwarning == false then
					print("Setup delayed due to being in combat!")
					combatwarning = true
				end
			end
		elseif SVLoaded and playerFound then
			TP.SVLoaded()
			SVLoaded = false
		elseif popupFade then
			local dx = Inspect.Time.Real() - popupFade
			local alpha = (TeleporterV2_Settings.fade - dx) / TeleporterV2_Settings.fade
			if Inspect.System.Secure() == false then
				UIFrames.frame:SetAlpha(alpha)
				if dx > TeleporterV2_Settings.fade then
					popupFade = false
					tpmenuVis = false
					UIFrames.frame:SetVisible(false)
					UIFrames.frame:SetAlpha(1)
				end
			end
		end
		coroutine.yield()
	end
end

TP.coUpdateHandler = coroutine.create(TP.UpdateHandler)

function TP.Event_System_Update_Begin(h)
	if coroDead then
		return
	end
	local ok, errormsg = coroutine.resume(TP.coUpdateHandler)
	if not ok then
		coroDead = true
		error("Error in coroutine: " .. errormsg)
	end
end

function TP.Event_System_Secure_Leave(h)
	if tprebuild then
		TP.setpopupOrder()
	end
end

function TP.Event_System_Secure_Enter(h)
	if tpmenuVis == true then
		UIFrames.frame:SetVisible(false)
		tpmenuVis = false
		popupFade = false
	end
end

--/script _TeleporterV2.cb_libinvCD({["I731C1B4F46334030,293CCC1E8957C704,,,,,,"] = {endtime=Inspect.Time.Real()+1234, slots={}}})

function TP.cb_libinvCD(t)
	local tx = Inspect.Time.Real()
	for k, v in pairs(t) do
		-- k = itemtype
		-- v.endtime = endtime
		if _tpitems[k] then
			local it = _tpitems[k]
			local p = tpabilities[it].p
			CDTIMES[it] = v.endtime
			UIFrames.abilities[p].frame:SetBackgroundColor(0.45, 0, 0, 0.5)
			UIFrames.abilities[p].cd = true
		end
	end
end

function TP.libinvUpdate(t)
	local refresh = false
	for k, v in pairs(t) do
		found = false
		if v["PLAYER"] then
			for slt, cnt in pairs(v["PLAYER"]) do
				if Library.LibInventory.REFSLOTS["inventory"][slt] then
					found = true
				end
			end
		end
		local ix = _tpitems[k]
		if found then
			if tpabilities[ix].able == false then
				tpabilities[ix].able = true
				refresh = true
				if tpabilities[ix].zoneid then
					local d = Inspect.Zone.Detail(tpabilities[ix].zoneid)
					tpabilities[ix].txt = d.name
				else
					local txname = Library.LibInventory.ITEMTYPE_NAME[k]
					tpabilities[ix].txt = txname
				end
				tpabilities[ix].use = "use " .. Library.LibInventory.ITEMTYPE_NAME[k]
				local tid = tpabilities[ix].p
				UIFrames.abilities[tid].text:SetText(tpabilities[ix].txt)
			end
		else
			if tpabilities[ix].able then
				tpabilities[ix].able = false
				refresh = true
			end
		end
	end
	if refresh then
		TP.setpopupOrder()
	end
end

function TP.Command_Slash_Register(h, args)
	local r = {}
	for token in string.gmatch(args, "[^%s]+") do
		table.insert(r, token)
	end
	if r[1] == "mode" then
		if Inspect.System.Secure() == false then
			if TeleporterV2_Settings.mode == TPMODE_POPUP then
				TeleporterV2_Settings.mode = TPMODE_CLICK
				print("Mode set to LEFT-CLICK")
			else
				TeleporterV2_Settings.mode = TPMODE_POPUP
				print("Mode set to POPUP")
			end
			UIFrames.header_icon:SetTexture(addon.identifier, TPMODE_IMG[TeleporterV2_Settings.mode])
		else
			print("Cant change settings whilst in combat. Try again later.")
		end
	elseif r[1] == "align" then
		if Inspect.System.Secure() == false then
			local p = TeleporterV2_Settings.align
			if p == "L" then
				p = "C"
			elseif p == "C" then
				p = "R"
			elseif p == "R" then
				p = "L"
			else
				p = "C"
			end
			TeleporterV2_Settings.align = p
			TP.AlignText(TeleporterV2_Settings.align)
		else
			print("Cant change settings whilst in combat. Try again later.")
		end
	elseif r[1] == "reset" then
		if MINIMAPDOCKER then
			print("Not resetting button position. Location manged by Docker.")
		else
			if Inspect.System.Secure() == false then
				TeleporterV2_Settings.mmx = UIParent:GetWidth() / 2
				TeleporterV2_Settings.mmy = UIParent:GetHeight() / 2
				UIFrames.mm_button:SetPoint(
					"TOPLEFT",
					UIParent,
					"TOPLEFT",
					TeleporterV2_Settings.mmx,
					TeleporterV2_Settings.mmy
				)
			else
				print("Unable to relocate button when in combat. Try again later.")
			end
		end
	elseif r[1] == "fade" then
		if tonumber(r[2]) == nil then
			if r[2] == nil then
				print("Fade time currently: " .. TeleporterV2_Settings.fade .. "s")
			else
				print(string.format("'%s' is not a valid number", r[2]))
			end
		else
			TeleporterV2_Settings.fade = tonumber(r[2])
			print("Setting fade time to: " .. TeleporterV2_Settings.fade .. "s")
		end
	else
		print("/teleporterv2 mode - Toggles between popup and right-click modes to display selection")
		print("/teleporterv2 align - Cycles between text alignment options C > R > L > C")
		print("/teleporterv2 fade N - Sets the fadeout time when you leave the popup menu")
		print("/teleporterv2 reset - Repositions button in center of screen")
	end
end

function TP.Event_Ability_New_Remove(h, t)
	for k, v in pairs(t) do
		if tpabilities[k] then
			for k, v in pairs(tpabilities) do
				if v.type == "spell" then
					tpabilities[k].able = false
				end
			end
			tprebuild = true
			break
		end
	end
	if tprebuild then
		TP.setpopupOrder()
	end
end

function TP.Event_Ability_New_Add(h, t)
	for k, v in pairs(t) do
		if tpabilities[k] then
			local d = Inspect.Ability.New.Detail(k)
			tpabilities[k].icon = d.icon
			tpabilities[k].able = true
			tpabilities[k].use = string.format("cast %s", d.name)

			if tpabilities[k].zoneid then
				local zd = Inspect.Zone.Detail(tpabilities[k].zoneid)
				tpabilities[k].txt = zd.name
			else
				tpabilities[k].txt = d.name
			end
			local tid = tpabilities[k].p
			UIFrames.abilities[tid].text:SetText(tpabilities[k].txt)
			tprebuild = true
		end
	end
	if tprebuild and UINeeded == false then
		TP.setpopupOrder()
	end
end

function TP.Event_Ability_New_Cooldown_Begin(h, t)
	for k, v in pairs(t) do
		if tpabilities[k] then
			local p = tpabilities[k].p
			CDTIMES[k] = Inspect.Time.Real() + v
			UIFrames.abilities[p].frame:SetBackgroundColor(0.45, 0, 0, 0.5)
			UIFrames.abilities[p].cd = true
		end
	end
end

function TP.Event_Ability_New_Cooldown_End(h, t)
	for k, v in pairs(t) do
		if tpabilities[k] then
			CDTIMES[k] = 0
		end
	end
end

function TP.Event_Unit_Availability_Full(h, t)
	for k, v in pairs(t) do
		if v == "player" then
			Command.Event.Detach(Event.Unit.Availability.Full, nil, nil, nil, addon.identifier)
			local d = Inspect.Ability.New.Detail(tpabilities)
			for ab, ad in pairs(d) do
				if ad.currentCooldownRemaining then
					CDTIMES[ab] = Inspect.Time.Real() + ad.currentCooldownRemaining
					local p = tpabilities[ab].p
					UIFrames.abilities[p].frame:SetBackgroundColor(0.45, 0, 0, 0.5)
					UIFrames.abilities[p].cd = true
				end
			end
			Command.Event.Attach(
				Event.Ability.New.Cooldown.Begin,
				TP.Event_Ability_New_Cooldown_Begin,
				"Event.Ability.New.Cooldown.Begin"
			)
			Command.Event.Attach(
				Event.Ability.New.Cooldown.End,
				TP.Event_Ability_New_Cooldown_End,
				"Event.Ability.New.Cooldown.End"
			)
		end
	end
end

---------------------
-- Register Events
---------------------

for k, v in pairs(_tpitems) do
	Library.LibInventory.RegisterItem(k, TP.libinvUpdate)
	Library.LibInventory.Cooldowns(TP.cb_libinvCD)
end

Command.Event.Attach(Event.System.Update.Begin, TP.Event_System_Update_Begin, "Event.System.Update.Begin")
Command.Event.Attach(Event.Addon.SavedVariables.Load.End, function(h, a)
	if a == addon.identifier then
		SVLoaded = true
	end
end, "Event.Addon.SavedVariables.Load.End")
Command.Event.Attach(Event.System.Secure.Enter, TP.Event_System_Secure_Enter, "Event.System.Secure.Enter")
Command.Event.Attach(Event.System.Secure.Leave, TP.Event_System_Secure_Leave, "Event.System.Secure.Leave")
Command.Event.Attach(Command.Slash.Register("teleporterv2"), TP.Command_Slash_Register, "Command.Slash.Register")
Command.Event.Attach(Event.Ability.New.Add, TP.Event_Ability_New_Add, "Event.Ability.New.Add")
Command.Event.Attach(Event.Ability.New.Remove, TP.Event_Ability_New_Remove, "Event.Ability.New.Remove")
Command.Event.Attach(Event.Unit.Availability.Full, TP.Event_Unit_Availability_Full, "Event.Unit.Availability.Full")

print(string.format("v%s loaded.", addon.toc.Version))
