local addon, data = ...

if not Library then Library = {} end
if not Library.LibInventory then Library.LibInventory = {} end

if not data._libInventory then data._libInventory = {} end
if not data._libInventoryAPI then data._libInventoryAPI = {} end

local LI = data._libInventory
local LA = data._libInventoryAPI

LA.CDCATEGORIES = {
	["consumable consumable"] = true,
	["consumable potion"] = true,
	["consumable enchantment"] = true,
	["misc"] = true,
	["misc other"] = true,
	["misc fishing"] = true,
}	

LA.items = {}
LA.slots = {}
LA.cooldowns = {}
LA.cditemtypes = {}
LA.activeCD = {}

LA.b_activeCD = false

local LIUPDATES = false
local LIUPDATE_DATA
local LIUPDATE_SLOTS
local SETUPDONE = false

function Library.LibInventory.Cooldowns(cb)
	assert(type(cb) == "function")
	LA.cooldowns[cb] = true
end

function Library.LibInventory.GetSlotContent(s)
	if LI.invslots_dtl[s] then
		return LI.invslots_dtl[s]
	else
		return nil
	end
end

function Library.LibInventory.GetItemCounts(it)
	local results = {}
	local pkey = nil
	for sn,_ in pairs(LIBINVENTORY_DATA) do
		for pn,_ in pairs(LIBINVENTORY_DATA[sn]) do
			if LIBINVENTORY_DATA[sn][pn][it] then
				if sn == data.sn and pn == data.pn then
					pkey = "PLAYER"
				else
					pkey = pn.."@"..sn
				end
				results[pkey] = { 
					counts={
						["bank"] = 0,
						["inventory"] = 0,
					},
					slots={}
				}
				for s,c in pairs(LIBINVENTORY_DATA[sn][pn][it]) do
					results[pkey].slots[s] = c
					if Library.LibInventory.REFSLOTS["bank"][s] then
						results[pkey].counts["bank"] = results[pkey].counts["bank"] +c
					elseif Library.LibInventory.REFSLOTS["inventory"][s] then
						results[pkey].counts["inventory"] = results[pkey].counts["inventory"] +c
					end
				end
			end
		end
	end
	if pkey then
		return results
	else
		return nil
	end	
end

function Library.LibInventory.GetItemInfo(it)
	local results = { ["PLAYER"] = {} }
	local pkey = nil
	for sn,_ in pairs(LIBINVENTORY_DATA) do
		for pn,_ in pairs(LIBINVENTORY_DATA[sn]) do
			if LIBINVENTORY_DATA[sn][pn][it] then
				if sn == data.sn and pn == data.pn then
					pkey = "PLAYER"
				else
					pkey = pn.."@"..sn
				end
				results[pkey] = {}
				for s,c in pairs(LIBINVENTORY_DATA[sn][pn][it]) do
					results[pkey][s] = c
				end
			end
		end
	end
	if pkey then
		return results
	else
		return nil
	end
end

function LA.QueueItemtypeUpdate(it)
	LIUPDATE_DATA[it] = true
	LIUPDATES = true
end

function LA.QueueSlotUpdate(s)
	LIUPDATE_SLOTS[s] = true
	LIUPDATES = true
end

function LA.SetupDone()
	LIUPDATE_DATA = {}
	LIUPDATE_SLOTS = {}
	for k,v in pairs(LA.items) do
		LA.QueueItemtypeUpdate(k)
	end
	for k,v in pairs(LA.slots) do
		LA.QueueSlotUpdate(k)
	end
	if SETUPDONE == false then
		Command.Event.Attach(Event.System.Update.Begin, LA.Event_System_Update_Begin, "Event.System.Update.Begin")
	end
	SETUPDONE = true
end

-- Takes an item type
function LA.handleItemRegister(it, cb)
	if LA.items[it] == nil then
		LA.items[it] = {}
	end
	LA.items[it][cb] = true
	if SETUPDONE then
		LA.QueueItemtypeUpdate(it)
	end
end

function Library.LibInventory.RegisterItem(it, cb)
	assert(type(cb) == "function")
	if type(it) == "string" then
		LA.handleItemRegister(it, cb)
	elseif type(it) == "table" then
		for s,_ in pairs(it) do
			LA.handleItemRegister(s, cb)
		end
	end
end

function LA.handleSlotRegister(sl, cb)
	if LA.slots[sl] == nil then
		LA.slots[sl] = {}
	end
	LA.slots[sl][cb] = true
	if SETUPDONE then
		LA.QueueSlotUpdate(sl)
	end
end

-- Takes either a slot name, or a table where the key is a slot identifier
function Library.LibInventory.RegisterSlot(sl, cb)
	assert(type(cb) == "function")
	if type(sl) == "string" then
		LA.handleSlotRegister(sl, cb)
	elseif type(sl) == "table" then
		for s,_ in pairs(sl) do
			LA.handleSlotRegister(s, cb)
		end
	end
end

local lastCDcheck = 0

function LA.Event_System_Update_Begin(h)
	local cbdata
	if LIUPDATES then
		cbdata = {}
		-- itemtype updates
		for it,_ in pairs(LIUPDATE_DATA) do
			local r = Library.LibInventory.GetItemInfo(it)
			if r then
				for fn,_ in pairs(LA.items[it]) do
					if cbdata[fn] == nil then
						cbdata[fn] = {}
					end
					cbdata[fn][it] = r
				end
			end
			LIUPDATE_DATA[it] = nil
		end
		for k,v in pairs(cbdata) do
			k(v)
		end
		
		-- slot updates
		cbdata = {}
		for sl,_ in pairs(LIUPDATE_SLOTS) do
			if LA.slots[sl] then
				for fn,_ in pairs(LA.slots[sl]) do
					if cbdata[fn] == nil then
						cbdata[fn] = {}
					end
					cbdata[fn][sl] = LI.invslots_dtl[sl] or "nil"
				end
			end
			LIUPDATE_SLOTS[sl] = nil
		end
		for k,v in pairs(cbdata) do
			k(v)
		end
		
		LIUPDATES = false
	end
	
	if LA.b_activeCD then
		local cddata = {}
		for k,v in pairs(LA.activeCD) do
			cddata[k] = { endtime = v, slots = Library.LibInventory.GetItemInfo(k)["PLAYER"] }
		end
		for k,v in pairs(LA.cooldowns) do
			k(cddata)
		end
		LA.b_activeCD = nil
	end
	
	local tx = Inspect.Time.Real()
	local cdChange = false
	
	if Inspect.System.Watchdog() > 0.05 and (tx-lastCDcheck > 0.2) then
		local d = Inspect.Item.Detail(LA.cditemtypes)
		for k,v in pairs(d) do
			if v.cooldownBegin and LA.activeCD[k] == nil then
				if v.cooldownRemaining >= 1.5 then
					LA.activeCD[k] = v.cooldownBegin + v.cooldownDuration
					LA.b_activeCD = true
				end
			elseif LA.activeCD[k] and v.cooldownBegin == nil then
				LA.activeCD[k] = nil
			end
		end
		for k,v in pairs(LA.activeCD) do
			if d[k] == nil then
				LA.activeCD[k] = nil
			end
		end
		lastCDcheck = tx
	end
end
