﻿local addon, RT = ...
local string_format = string.format
local string_gmatch = string.gmatch
local string_find = string.find
local string_sub = string.sub
local string_len = string.len
local math_floor = math.floor
local math_max = math.max
local math_min = math.min
local math_sqrt = math.sqrt
local math_atan = math.atan2
local math_abs = math.abs
local math_pi = math.pi
local table_remove = table.remove
local table_insert = table.insert
local table_sort = table.sort

local IDX_WOOD = 1
local IDX_ORE = 2
local IDX_PLANTS = 3
local IDX_FISH = 4
local IDX_ARTI = "Artifacts"

local DISC_GATHER = 1
local DISC_TRACK = 2

-- /print Inspect.Map.Detail(Inspect.Map.List())

local ARTI_NAME_N = "Artifact"
local ARTI_NAME_S = "rtifact"
local ARTI_NAME_T = "Twisted Artifact"
local ARTI_NAME_U = "Unstable Artifact"

RT.ACTIVELNGFLD = 1

if RT.ARTIFACTS[RT.SYSLANG] then
	ARTI_NAME_N = RT.ARTIFACTS[RT.SYSLANG].N or ARTI_NAME_N
	ARTI_NAME_S = RT.ARTIFACTS[RT.SYSLANG].S or ARTI_NAME_S
	ARTI_NAME_T = RT.ARTIFACTS[RT.SYSLANG].T or ARTI_NAME_T
	ARTI_NAME_U = RT.ARTIFACTS[RT.SYSLANG].U or ARTI_NAME_U
end

local ARTIFACTS = {
	[ARTI_NAME_N] = "Artifact",
	[ARTI_NAME_S] = "Artifact",
	[ARTI_NAME_T] = "Twisted Artifact",
	[ARTI_NAME_U] = "Unstable Artifact"
}

RT.ICONS = {
	["Artifact"] = "enchanting_material_14.dds",
	["Twisted Artifact"] = "enchanting_material_14c.dds",
	["Unstable Artifact"] = "enchanting_material_11a.dds",
	["UNK_ARTI_TYPE"] = "enchanting_material_17b.dds",
	["GHOST"] = "enchanting_material_26.dds"
}

local RT_INCLUDE = true
local RT_NONE = false
local RT_EXCLUDE = 2

RT.CHECKBOX = {
	[RT_INCLUDE] = "img/cb_tick.png",
	[RT_NONE] = "img/cb_none.png",
	[RT_EXCLUDE] = "img/cb_cross.png"
}

local DM_CLASSIC = 1
local DM_STACKED = 2

local default_settings = {
	mmx=200, mmy=200, locked = false, tracked = {}, fontsize = 36, num_nodes = 5, fade_time = 2,
	cfgx = 500, cfgy = 200, trx = -1, try = -1, showcombat = true, version=addon.toc.Version,
	relative = true, dispmode = DM_STACKED, artifact = true, use3Dmode = true, showelevation = true,
	txn = {}, articolor = true, num_gnodes=12, ghostmode = true, ghostinclude = {
		["UNK"] = {["def"] = true,},
		["NOR"] = {["co"] = true,	["un"] = true,	["ra"] = true,	["ep"] = true,	["re"] = true,	["def"] = true,},
		["TWI"] = {["co"] = true,	["un"] = true,	["ra"] = true,	["ep"] = true,	["re"] = true,	["def"] = true,},
		["UNS"] = {["co"] = true,	["un"] = true,	["ra"] = true,	["ep"] = true,	["re"] = true,	["def"] = true,}
		},
	hidecommon = false
}

local default_settings_node = {
	[IDX_WOOD] = {}, [IDX_ORE] = {}, [IDX_PLANTS] = {}, [IDX_FISH] = {},
	Artifacts = {}, Rarity = {},
	version=addon.toc.version
}

RT.MAX_TRACK=24
	
RT.TRACK_ABILITIES = {
	["A71B6D2C0C5577022"] = IDX_WOOD,
	["A4211DDD7A2E97B42"] = IDX_ORE,
	["A1452B14895FE7728"] = IDX_PLANTS,
	["A295EECA15ADDAE79"] = IDX_FISH
	}

RT.TRACK_ARTIFACTS = {
	["A0530A5F074940F78"] = true
}
RT.activeTrack = {active=false}
	
RT.ACTIVE_ABILITIES = {
	[IDX_WOOD] = {active=false, counttrack=0, buff=false, akey="WOOD", icon="Data/UI/item_icons/wood3.dds", lmni="img/node_wood.png"},
	[IDX_ORE] = {active=false, counttrack=0, buff=false, akey="MINING", icon="Data/UI/item_icons/pick4.dds", lmni="img/node_ore.png"},
	[IDX_PLANTS] = {active=false, counttrack=0, buff=false, akey="PLANTS", icon="Data/UI/item_icons/plant1.dds", lmni="img/node_plant.png"},
	[IDX_FISH] = {active=false, counttrack=0, buff=false, akey="FISH", icon="Data/UI/item_icons/fish_51.dds", lmni="img/node_fish.png"},
}

local TRKINDEX = {
	["MINING"] = IDX_ORE,
	["WOOD"] = IDX_WOOD,
	["PLANTS"] = IDX_PLANTS,
	["FISH"] = IDX_FISH,
	["Artifacts"] = IDX_ARTI
}

RT.ACTIVE_BUFFS = {}
RT.RESTYPE = {}
RT.MESSAGE_STACK = {}
RT.tNodes = {}
RT.tVisited = {}
RT.tNearby = {}

RT.TRACKLISTCHANGE = false
RT.SEND_MAPNOTE = false
RT.SVLOADED = false
RT.RT_ACTIVE = true
RT.prevIUD = false
RT.p_heading = 0
RT.v_heading = false
RT.COLLECTTIME = 0
RT.timenow = 0
RT.GHOSTFILTER = 0
RT.GHOSTEXCLUDE = 0
RT.SCANMAP = false

local last_update = 0
local last_shadow = { tx = 0, bx = "0.0.0" }
local last_history = 0

local coroDead = false
local playerID = Inspect.Unit.Lookup("player")

local function WATCHDOGWAIT(x)
	local rmx = Inspect.System.Watchdog()
	while rmx < 0.05 do
		coroutine.yield()
		rmx = Inspect.System.Watchdog()
	end
end

local function MergeTable(o,n)
	for k,v in pairs(n) do
		if type(v) == "table" then
			if o[k] == nil then
				o[k] = {}
			end
	 	 	if type(o[k]) == 'table' then
	 			MergeTable(o[k], n[k])
	 	 	end
		else
			if o[k] == nil then
				o[k] = v
			end
		end
	end
end

local function debug(m)
	if ResourceTracker_Settings.debug then
		print(m)
	end
end

function RT.AddNode()
end

function RT.FlagDetail(f)
	local b=0
	local s=nil
	for xk,xv in pairs(RT.FLAGDX) do
		if bit.band(xk, f) > 0 then
			b = b + xk
			if s == nil then
				s = xv
			else
				s = xv .. " | "..s
			end
		end
	end
	return tostring(s)
end

function RT.GetNearbyArtiNodes(px, py, pz)
	local ak, d
	RT.tNodes = {}
	RT.tNearby = {}
	for x=-19, 19 do
		for y=-19, 19 do
			for z=-19, 19 do
				ak = string_format("%d.%d.%d", px+(x*5), pz+(z*5), py+(y*5))
				if ResourceTracker_Nodes.Rarity[LIBZONECHANGE.currentZoneID][ak] then
					if ResourceTracker_Settings.use3Dmode then
						d = math_sqrt(((5*x)^2)+((5*y)^2)+((5*z)^2))
					else
						d = math_sqrt(((5*x)^2)+((5*z)^2))
					end
					if d<5 then
						RT.tVisited[ak] = RT.timenow
						RT.tNearby[ak] = true
					else
						if RT.tVisited[ak] == nil or (RT.tVisited[ak] and RT.timenow - RT.tVisited[ak] > 300) then
							table_insert(RT.tNodes, {i=ak, t=nil, x=px+(x*5), z=pz+(z*5), y=py+(y*5), n="GHOST", d=d, arti=true, ak=ak, ghost=true})
						end
					end
				end
			end
		end
	end
	table_sort(RT.tNodes, function(a,b) return a.d < b.d end)
end

function RT.ShowMessage(m)
	local tx = Inspect.Time.Real()
	local rq = true
	for k,v in pairs(RT.MESSAGE_STACK) do
		if v.i == m.id then
			RT.MESSAGE_STACK[k].t = nil
			rq = false
			break
		end
	end
	if rq then
		table_insert(RT.MESSAGE_STACK, 1, {i=m.id, t=nil, x=m.coordX, y=m.coordY, z=m.coordZ, n=m.description, d=1000, arti=m.arti, ak=m.ak, ghost=false})
	end
	if #RT.MESSAGE_STACK > 50 then
		table.remove(RT.MESSAGE_STACK, 51)
	end
end

function RT.Event_Map_Remove(h,e)
	for ed, ev in pairs(e) do
		for k,v in pairs(RT.MESSAGE_STACK) do
			if v.i == ed then
				if v.d <= 70 then
					RT.MESSAGE_STACK[k].t = Inspect.Time.Real()-100
				else
					RT.MESSAGE_STACK[k].t = Inspect.Time.Real()+ResourceTracker_Settings.fade_time
				end
				break
			end
		end
	end
end

local rtRep = {}

function RT.Event_Map_Add(h,e)
	for k,v in pairs(Inspect.Map.Detail(e)) do
		if v.description and (RT.LOCAL[v.description] or string_find(v.description, ResourceTracker_Settings.txn[RT.SYSLANG]["ARTIFACT_SEARCH_PATTERN"])) then
			local en = RT.LOCAL[v.description]
			local res = false
			if en then
				res	= RT.RESTYPE[en]
			elseif string_find(v.description, ResourceTracker_Settings.txn[RT.SYSLANG]["ARTIFACT_SEARCH_PATTERN"]) then
				res = "Artifacts"
			end
			
			if RT.RT_ACTIVE then
				if ResourceTracker_Settings.tracked[en] then
					local arti = nil
					local ak = string_format("%d.%d.%d", 5*math_floor(v.coordX/5), 5*math_floor(v.coordZ/5), 5*math_floor(v.coordY/5))
					--if ARTIFACTS[en] then
					if ARTIFACTS[v.description] then
						arti = true						
						if RT.FLAGS_N[en] then
							if RT.FLAGS_N[RT.FLAGS_N[en]] then
								if RT.FLAGS_R[RT.FLAGS_N[RT.FLAGS_N[en]]] then
									if RT.FLAGS_R[RT.FLAGS_N[RT.FLAGS_N[en]]].default then
										local flag = RT.FLAGS_R[RT.FLAGS_N[RT.FLAGS_N[en]]].default
										if ResourceTracker_Nodes.Rarity[LIBZONECHANGE.currentZoneID][ak] == nil then
											ResourceTracker_Nodes.Rarity[LIBZONECHANGE.currentZoneID][ak] = {t=DISC_TRACK, r=0, flags=0}
											debug("Adding new node. DISC_TRACK: "..ak)
											RT.CleanupNodes(v.coordX, v.coordY, v.coordZ)
										elseif ResourceTracker_Nodes.Rarity[LIBZONECHANGE.currentZoneID][ak].t == DISC_GATHER then
											ResourceTracker_Nodes.Rarity[LIBZONECHANGE.currentZoneID][ak].t = DISC_TRACK
											debug("Converting node: "..ak.." to DISC_TRACK")
											RT.CleanupNodes(v.coordX, v.coordY, v.coordZ)
										end
										local cFlag = ResourceTracker_Nodes.Rarity[LIBZONECHANGE.currentZoneID][ak].flags or 0
										debug("cFlag = "..cFlag..", flag="..tostring(flag)..", actual="..tostring(flag or RT.FLAGS_N["UNKNOWN"]))
										local nFlag = bit.bor(cFlag, flag or RT.FLAGS_N["UNKNOWN"])
										debug(string.format("[%s] : %s -> %s", ak, cFlag, nFlag))
										ResourceTracker_Nodes.Rarity[LIBZONECHANGE.currentZoneID][ak].flags = nFlag
									else
										debug("no entry for RT.FLAGS_R["..RT.FLAGS_N[RT.FLAGS_N[en]].."].default")
									end
								else
									debug("no entry for RT.FLAGS_R["..RT.FLAGS_N[RT.FLAGS_N[en]].."]")
								end
							else
								debug("no entry for RT.FLAGS["..RT.FLAGS_N[en].."]")
							end
						else
							debug("no entry for RT.FLAGS_N["..en.."]")
						end
					end
					
					local addNode = true
					
					if arti and ResourceTracker_Nodes.Rarity[LIBZONECHANGE.currentZoneID][ak] then
						local nFlags = ResourceTracker_Nodes.Rarity[LIBZONECHANGE.currentZoneID][ak].flags
						if ResourceTracker_Settings.hidecommon and bit.band(nFlags, RT.AGFLAGS.co) > 0 then
							addNode = false
						end
					end
					
					if addNode then
						RT.ShowMessage( {id=v.id, description=en, coordX=v.coordX, coordY=v.coordY, coordZ=v.coordZ, arti=arti, ak=ak} )
					end
				elseif ResourceTracker_Settings.tracked["UNK_ARTI_TYPE"] and string_find(v.description, ResourceTracker_Settings.txn[RT.SYSLANG]["ARTIFACT_SEARCH_PATTERN"]) and en == nil then
					local artype = false
					if ARTIFACTS[en] then
						res = "Artifacts"
						artype = en
					else
						if string_sub(v.id,1,9) == "l00000019" then
							res = "Artifacts"
							artype = "UNK_ARTI_TYPE"
						end
					end
					if artype then
						local ak = string_format("%d.%d.%d", 5*math_floor(v.coordX/5), 5*math_floor(v.coordZ/5), 5*math_floor(v.coordY/5))
						if ResourceTracker_Nodes.Rarity[LIBZONECHANGE.currentZoneID][ak] == nil then
							ResourceTracker_Nodes.Rarity[LIBZONECHANGE.currentZoneID][ak] = {t=DISC_TRACK, r=0, flags=0}
							debug("Adding new node. DISC_TRACK: "..ak)
							RT.CleanupNodes(v.coordX, v.coordY, v.coordZ)
						elseif ResourceTracker_Nodes.Rarity[LIBZONECHANGE.currentZoneID][ak].t == DISC_GATHER then
							ResourceTracker_Nodes.Rarity[LIBZONECHANGE.currentZoneID][ak].t = DISC_TRACK
							debug("Converting node: "..ak.." to DISC_TRACK")
							RT.CleanupNodes(v.coordX, v.coordY, v.coordZ)
						end
						local cFlag = ResourceTracker_Nodes.Rarity[LIBZONECHANGE.currentZoneID][ak].flags or 0
						local nFlag = bit.bor(cFlag, RT.FLAGS_N["UNKNOWN"])
						debug(string.format("[%s] : %s -> %s", ak, cFlag, nFlag))
						ResourceTracker_Nodes.Rarity[LIBZONECHANGE.currentZoneID][ak].flags = nFlag
						RT.ShowMessage( {id=v.id, description=artype, coordX=v.coordX, coordY=v.coordY, coordZ=v.coordZ, arti=true, ak=ak } )
					end
				end
			end

			if res then
				local ix = string_format("%d.%d.%d", v.coordX, v.coordZ, v.coordY)
				if ResourceTracker_Nodes[res] == nil then
					ResourceTracker_Nodes[res] = {}
				end
				
				if ResourceTracker_Nodes[res][LIBZONECHANGE.currentZoneID] == nil then
					ResourceTracker_Nodes[res][LIBZONECHANGE.currentZoneID] = {}
				end
				if ResourceTracker_Nodes[res][LIBZONECHANGE.currentZoneID][ix] == nil then
					ResourceTracker_Nodes[res][LIBZONECHANGE.currentZoneID][ix] = {x=v.coordX, z=v.coordZ, y=v.coordY, nodes = {} }
				end
				local lud
				local ln
				if res == "Artifacts" then
					lud = RT.LOOKUP["Artifacts"]
					ln = "Artifacts"
				else
					lud = RT.LOOKUP[RT.LOCAL[v.description]]
					ln = v.description
					debug(string.format("ln:%s, lud:%s, res:%s, ix:%s, lud.k:%s", tostring(ln), tostring(lud), tostring(res), tostring(ix), tostring(lud.k)))
				end
				if ResourceTracker_Nodes[res][LIBZONECHANGE.currentZoneID][ix].nodes[lud.k] == nil then
					ResourceTracker_Nodes[res][LIBZONECHANGE.currentZoneID][ix].nodes[lud.k] = true
					if Library.LibMapNotes then
						Library.LibMapNotes.AddNodeToSet("RT: "..ln,{x=v.coordX, z=v.coordZ, itex=lud.icon, isrc="Rift", isiz=13})
					end
				end
			end
		end
	end
end

-- /print Inspect.Addon.Detail("ResourceTracker").data.LOOKUP.Thalasitader
-- /print ResourceTracker_Settings.txn.DE.Sarleaf

function RT.DumpCurrentMap()
	for k,v in pairs(Inspect.Map.Detail(Inspect.Map.List())) do
		print(string_format("%s %s,%s,%s", v.description, v.coordX, v.coordY, v.coordZ))
	end
end

function RT.direction(dt)
	if dt > 180 then dt = dt-360 end
	if dt < -180 then dt = dt+360 end

	if dt >= 169		then	d = "08"
	elseif dt >= 146	then	d = "09"
	elseif dt >= 124	then	d = "10"
	elseif dt >= 101	then	d = "11"
	elseif dt >= 79		then	d = "12"
	elseif dt >= 56		then	d = "13"
	elseif dt >= 34		then	d = "14"
	elseif dt >= 11		then	d = "15"
	elseif dt >= -11	then	d = "00"
	elseif dt >= -34	then	d = "01"
	elseif dt >= -56	then	d = "02"
	elseif dt >= -79	then	d = "03"
	elseif dt >= -101	then	d = "04"
	elseif dt >= -124	then	d = "05"
	elseif dt >= -146	then	d = "06"
	elseif dt >= -169	then	d = "07"
	else						d = "08"
	end

	return d
end

local resort_req = false

function RT.ScanCurrentMap()
	if RT.SCANMAP then
		for k,v in pairs(RT.MESSAGE_STACK) do
			RT.UI.trackers[k].f:SetVisible(false)
		end
		RT.MESSAGE_STACK = {}
		for k,v in pairs(Inspect.Map.Detail(Inspect.Map.List())) do
			RT.Event_Map_Add(0, v)
		end
	end
end

local alpha=0

local rpt = 0

function RT.CheckAbilities()
	for x=1,4 do
		if RT.ACTIVE_ABILITIES[x].counttrack > 0 and RT.ACTIVE_ABILITIES[x].active and RT.ACTIVE_ABILITIES[x].buff == false then
			RT.UI.alert[x].b:SetVisible(true)
		else
			RT.UI.alert[x].b:SetVisible(false)
		end
	end
end

function RT.UpdateHandler()
	while true do
		if RT.SEND_MAPNOTE then
			RT.SendDataLMN()
			RT.SEND_MAPNOTE = false
		end
		coroutine.yield()
	end
end

RT.coroUpdateHandler = coroutine.create(RT.UpdateHandler)

local cdmsg = ""

function RT.Event_System_Update_Begin(h)
	RT.timenow = Inspect.Time.Real()
	--[[
	if timenow - last_history > 2 then
		for k,v in pairs(ResourceTracker_Nodes.Artifacts[LIBZONECHANGE.currentZoneID]) do
		
		end
	end
	]]--
	--if #RT.MESSAGE_STACK > 0 then
		if RT.timenow - last_update > 0.1 then
			local pd = Inspect.Unit.Detail("player")
			
			if pd and pd.coordX and pd.coordY and pd.coordZ then
				last_update = RT.timenow
				if not RT.prevIUD then
					RT.prevIUD = pd
				end
				
				local p_dx = RT.prevIUD.coordX - pd.coordX
				local p_dy = RT.prevIUD.coordY - pd.coordY
				local p_dz = RT.prevIUD.coordZ - pd.coordZ
				
				if ResourceTracker_Settings.relative then
					if p_dx ~= 0 or p_dy ~= 0 or p_dz ~= 0 then
						RT.p_heading = math_atan(p_dx,p_dz)*180/math_pi
						RT.v_heading = true
					end
				else
					RT.p_heading = 0
					RT.v_heading = true
				end

				local bGhost = false
				
				if ResourceTracker_Settings.ghostmode and RT.activeTrack.active == false and #RT.MESSAGE_STACK < ResourceTracker_Settings.num_nodes then
					if RT.timenow - last_shadow.tx > 1 then						
						last_shadow.tx = RT.timenow
						local px = 5*math_floor(pd.coordX/5)
						local py = 5*math_floor(pd.coordY/5)
						local pz = 5*math_floor(pd.coordZ/5)
						local bx = string_format("%d.%d.%d", px, pz, py)
						if bx ~= last_shadow.bx then							
							last_shadow.bx = bx
							RT.GetNearbyArtiNodes(px, py, pz)
						end
					end
					local nReq = math.min(ResourceTracker_Settings.num_gnodes, ResourceTracker_Settings.num_nodes-#RT.MESSAGE_STACK)
					for k,v in ipairs(RT.tNodes) do
--debug(string.format("%d :: %s : GF=%d, flags=%d, band=%d", k,v.ak,RT.GHOSTFILTER, ResourceTracker_Nodes.Rarity[LIBZONECHANGE.currentZoneID][v.ak].flags, bit.band(RT.GHOSTFILTER, ResourceTracker_Nodes.Rarity[LIBZONECHANGE.currentZoneID][v.ak].flags) ))
						if RT.tNearby[v.ak] == nil and
						bit.band(RT.GHOSTFILTER, ResourceTracker_Nodes.Rarity[LIBZONECHANGE.currentZoneID][v.ak].flags) > 0 and
						bit.band(RT.GHOSTEXCLUDE, ResourceTracker_Nodes.Rarity[LIBZONECHANGE.currentZoneID][v.ak].flags) == 0 then
							table_insert(RT.MESSAGE_STACK, 1, v)
							nReq = nReq - 1
						end
						if nReq == 0 then
							break
						end
					end
				end

				--RT.MESSAGE_STACK = RT.GetNearbyArtiNodes(5*math_floor(pd.coordX/5), 5*math_floor(pd.coordY/5), 5*math_floor(pd.coordZ/5))
				for x,v in pairs(RT.MESSAGE_STACK) do
					local dx = pd.coordX - RT.MESSAGE_STACK[x].x
					local dy = pd.coordY - RT.MESSAGE_STACK[x].y
					local dz = pd.coordZ - RT.MESSAGE_STACK[x].z
					local d = 0
					if v.ghost == false then
						if ResourceTracker_Settings.use3Dmode then
							d = math_sqrt((dx^2)+(dy^2)+(dz^2))
						else
							d = math_sqrt((dx^2)+(dz^2))
						end
					else
						d = v.d
					end
					
					if d<5 and v.ghost then
						RT.tVisited[v.ak] = RT.timenow
						RT.tNearby[v.ak] = true						
					end
					local dr = math_atan(dx,dz)*180/math_pi
					local c = "99"
					local r_heading = dr-RT.p_heading
					if r_heading < -180 then r_heading=r_heading+360
					elseif r_heading > 360 then r_heading=r_heading-360
					end
					if RT.v_heading then
						c = RT.direction(r_heading)
					end
					local imgtype = "L"
					if dy > 3 then
						imgtype = "B"
					elseif dy < -3 then
						imgtype = "A"
					end
					RT.MESSAGE_STACK[x].ixn = "img/"..imgtype..c..".png"
					RT.MESSAGE_STACK[x].d=d
					RT.MESSAGE_STACK[x].dy=dy
				end
				if p_dx ~= 0 or p_dy ~= 0 or p_dz ~= 0 then
					RT.prevIUD = pd
				end				
			end
			table_sort(RT.MESSAGE_STACK, function(a,b) return a.d < b.d end)
			local t = Inspect.Time.Real()
			local alpha
			local tf			
			for x=ResourceTracker_Settings.num_nodes, 1, -1 do
				if RT.MESSAGE_STACK[x] then
					if RT.MESSAGE_STACK[x].t ~= nil then
						tf = t-RT.MESSAGE_STACK[x].t
					else
						tf = 0
					end
					if tf > 2 then
						table.remove(RT.MESSAGE_STACK, x)
						RT.UI.trackers[x].f:SetVisible(false)
						resort_req = true
					else
						if tf > 0 then
							alpha = (2-tf)/2
						else
							alpha = 1
						end
						if RT.MESSAGE_STACK[x].ghost then
							alpha = alpha *0.75
						end
						RT.UI.trackers[x].f:SetAlpha(alpha)
						if RT.UI.trackers[x].i.ci ~= RT.MESSAGE_STACK[x].n then
							RT.UI.trackers[x].i:SetTexture("Rift", RT.ICONS[RT.MESSAGE_STACK[x].n])
							RT.UI.trackers[x].i.ci = RT.MESSAGE_STACK[x].n
						end

						if RT.MESSAGE_STACK[x].ixn then
							if RT.UI.trackers[x].dx.ci ~= RT.MESSAGE_STACK[x].ixn then
								RT.UI.trackers[x].dx:SetTexture(addon.identifier, RT.MESSAGE_STACK[x].ixn)
								RT.UI.trackers[x].dx.ci = RT.MESSAGE_STACK[x].ixn
							end
						else
							RT.MESSAGE_STACK[x].ixn = "img/L00.png"
							RT.UI.trackers[x].dx:SetTexture(addon.identifier, RT.MESSAGE_STACK[x].ixn)
							RT.UI.trackers[x].dx.ci = RT.MESSAGE_STACK[x].ixn
						end

						if RT.MESSAGE_STACK[x].d < 1000 then
							if ResourceTracker_Settings.dispmode == DM_CLASSIC then
								RT.UI.trackers[x].d:SetText(string_format("%s [%dm]", RT.MESSAGE_STACK[x].n, RT.MESSAGE_STACK[x].d))
							else
								local d = math_floor(0-RT.MESSAGE_STACK[x].dy)
								RT.UI.trackers[x].d:SetText(string_format("%d", RT.MESSAGE_STACK[x].d))
								RT.UI.trackers[x].e:SetText(string_format("%d", d))
							end
						else
							if ResourceTracker_Settings.dispmode == DM_CLASSIC then
								RT.UI.trackers[x].d:SetText(string_format("%s", RT.MESSAGE_STACK[x].n))
							else
								RT.UI.trackers[x].d:SetText("??")
								RT.UI.trackers[x].e:SetText("??")
							end
						end
						local col = {0,0,0,0.1}
						RT.UI.trackers[x].f:SetBackgroundColor(1,0,0,1)
						if RT.MESSAGE_STACK[x].arti and ResourceTracker_Settings.articolor then
							local rar = ResourceTracker_Nodes.Rarity[LIBZONECHANGE.currentZoneID][RT.MESSAGE_STACK[x].ak].r or 0
							local ax = 5*math_floor(RT.MESSAGE_STACK[x].x/5)
							local ay = 5*math_floor(RT.MESSAGE_STACK[x].y/5)
							local az = 5*math_floor(RT.MESSAGE_STACK[x].z/5)
							
							local flg = 0

							for cx=-1, 1 do
								for cy=-1, 1 do
									for cz=-1, 1 do
										local ak = string_format("%d.%d.%d", ax+(cx*5), az+(cz*5), ay+(cy*5))
										if ResourceTracker_Nodes.Rarity[LIBZONECHANGE.currentZoneID][ak] then
											flg = bit.bor(flg, ResourceTracker_Nodes.Rarity[LIBZONECHANGE.currentZoneID][ak].flags or 0)
										end
									end
								end
							end
							
							if bit.band(flg, RT.AGFLAGS.re) > 0 then		col = RT.rarity.relic.c
							elseif bit.band(flg, RT.AGFLAGS.ep) > 0 then	col = RT.rarity.epic.c
							elseif bit.band(flg, RT.AGFLAGS.ra) > 0 then	col = RT.rarity.rare.c
							elseif bit.band(flg, RT.AGFLAGS.un) > 0 then	col = RT.rarity.uncommon.c
							elseif bit.band(flg, RT.AGFLAGS.co) > 0 then	col = RT.rarity.common.c
							end
							
						end
						RT.UI.trackers[x].f:SetBackgroundColor(unpack(col))
						RT.UI.trackers[x].f:SetVisible(true)
					end
				else
					RT.UI.trackers[x].f:SetVisible(false)
				end				
			end
			if resort_req == true then
				if #RT.MESSAGE_STACK > 0 then
					local newdtls = {}
					local updt = false
					for x=1, ResourceTracker_Settings.num_nodes do
						if RT.MESSAGE_STACK[x] then
							table_insert(newdtls, RT.MESSAGE_STACK[x])
							updt = true
						end
					end
					if updt then
						RT.MESSAGE_STACK = newdtls
					end
				end
				resort_req = false
			end
				-- Remove Ghost nodes
			for x=#RT.MESSAGE_STACK, 1, -1 do
				if RT.MESSAGE_STACK[x].ghost then
					table_remove(RT.MESSAGE_STACK, x)
				end
			end				
			
		end
	--end
	if RT.TRACKLISTCHANGE then
		RT.CheckAbilities()
		RT.TRACKLISTCHANGE = false
	end
	-- coro
	if coroDead then return end
	local ok, errormsg = coroutine.resume(RT.coroUpdateHandler)
	if not ok then
		coroDead = true
		error("Error in coroutine: "..errormsg)
	end
end

function RT.CreateConfig(k,v, c)
	local e = UI.CreateFrame("Texture", "ed"..k, c)
	e:SetWidth(24)
	e:SetHeight(24)
	e:SetLayer(15)
	e:SetTexture(addon.identifier, "img/editbutton.png")
	e.editmode = false	
	local c = UI.CreateFrame("RiftCheckbox", "cb"..k, c)
	c:SetWidth(24)
	c:SetHeight(24)
	c:SetChecked(false)
	c:SetLayer(15)
	c:EventAttach(Event.UI.Checkbox.Change, function(self, h)
		local en = v.name.EN
		if c:GetChecked() then
			ResourceTracker_Settings.tracked[en] = true
			if RT.ACTIVE_ABILITIES[RT.RESTYPE[en]] then
				RT.ACTIVE_ABILITIES[RT.RESTYPE[en]].counttrack = RT.ACTIVE_ABILITIES[RT.RESTYPE[en]].counttrack+1
			end
			RT.SEND_MAPNOTE = true
		else
			ResourceTracker_Settings.tracked[en] = nil
			if RT.ACTIVE_ABILITIES[RT.RESTYPE[en]] then
				RT.ACTIVE_ABILITIES[RT.RESTYPE[en]].counttrack = RT.ACTIVE_ABILITIES[RT.RESTYPE[en]].counttrack-1
			end
		end
		if RT.SVLOADED then
			RT.ScanCurrentMap()
		end
	end, "Event.UI.Checkbox.Change")
	c:SetPoint("TOPLEFT", e, "TOPRIGHT", 2,0)
	local i = UI.CreateFrame("Texture", "i"..k, c)
	i:SetWidth(24)
	i:SetHeight(24)
	i:SetTexture("Rift", v.icon)
	i:SetPoint("TOPLEFT", c, "TOPRIGHT", 2,0)
	i:SetLayer(15)
	local t = UI.CreateFrame("Text", "t"..k, c)
	t:SetFontSize(12)
	t:SetText(v.name[RT.SYSLANG])
	t:SetPoint("CENTERLEFT", i, "CENTERRIGHT", 2,0)
	t:SetLayer(15)
	local u = UI.CreateFrame("RiftTextfield", "u"..k, c)
	u:SetWidth(160)
	u:SetBackgroundColor(0.5, 0, 0.5)
	u:SetPoint("CENTERLEFT", i, "CENTERRIGHT", 2,0)
	u:SetVisible(false)
	u:SetLayer(15)
	u:SetText(v.name[RT.SYSLANG])
	e:EventAttach(Event.UI.Input.Mouse.Left.Click, function(self, h)
		e.editmode = not e.editmode
		if e.editmode then
			if v.name.EN == "UNK_ARTI_TYPE" then
				t:SetText("Unknown: *"..ResourceTracker_Settings.txn[RT.SYSLANG]["ARTIFACT_SEARCH_PATTERN"].."*")
				u:SetText(ResourceTracker_Settings.txn[RT.SYSLANG]["ARTIFACT_SEARCH_PATTERN"])
			else
				t:SetText(v.name[RT.SYSLANG])
				u:SetText(v.name[RT.SYSLANG])
			end
			u:SetVisible(true)
			t:SetVisible(false)
		else
			u:SetVisible(false)
			t:SetVisible(true)
		end
		u:SetKeyFocus(false)
		debug(string_format("LCLK:: t: %s, u: %s, em: %s", t:GetText(), u:GetText(), tostring(e.editmode)))
	end, "Event.UI.Input.Mouse.Left.Click")
	e:EventAttach(Event.UI.Input.Mouse.Right.Click, function(self, h)
		if e.editmode then
			e.editmode = not e.editmode
			u:SetKeyFocus(false)
			t:SetVisible(true)
			u:SetVisible(false)
			local lText = u:GetText()
			local eText = v.name.EN
			debug(string.format("Update: %s :: %s > %s", eText, ResourceTracker_Settings.txn[RT.SYSLANG][v.name.EN], lText))
			RT.LOCAL[lText] = eText
			RT.LOOKUP[lText] = RT.LOOKUP[eText]
			if eText == "UNK_ARTI_TYPE" then
				ResourceTracker_Settings.txn[RT.SYSLANG]["ARTIFACT_SEARCH_PATTERN"] = lText
				t:SetText(string_format("Unknown: *%s*", ResourceTracker_Settings.txn[RT.SYSLANG]["ARTIFACT_SEARCH_PATTERN"]))
			else
				ResourceTracker_Settings.txn[RT.SYSLANG][v.name.EN] = u:GetText()
				t:SetText(ResourceTracker_Settings.txn[RT.SYSLANG][v.name.EN])
			end
			debug(string_format("RCLK:: t: %s, u: %s, em: %s", t:GetText(), u:GetText(), tostring(e.editmode)))
			RT.ScanCurrentMap()
		end
	end, "Event.UI.Input.Mouse.Right.Click")
	
	return {c=c,i=i,t=t,e=e,u=u}
end

function RT.BuildMinimapButtons()
	RT.UI.mm = UI.CreateFrame("Texture", "RT.UI.mm", RT.UI.contextMM)
	RT.UI.mm:SetHeight(36)
	RT.UI.mm:SetWidth(36)

	RT.UI.mm:EventAttach(Event.UI.Input.Mouse.Left.Click, function(self, h)
		if ResourceTracker_Settings.locked or MINIMAPDOCKER ~= nil then
			RT.UI.cfgwindow.config:SetVisible(not RT.UI.cfgwindow.config:GetVisible())
			RT.UI.anchor:SetVisible(RT.UI.cfgwindow.config:GetVisible())
		end
	end, "Event.UI.Input.Mouse.Left.Click")

	RT.UI.mm:EventAttach(Event.UI.Input.Mouse.Left.Down, function(self, h)
		if MINIMAPDOCKER == nil and ResourceTracker_Settings.locked == false then
			self.MouseDown = true
			local mouseData = Inspect.Mouse()
			self.sx = mouseData.x - RT.UI.mm:GetLeft()
			self.sy = mouseData.y - RT.UI.mm:GetTop()
		end
	end, "Event.UI.Input.Mouse.Left.Down")

	if MINIMAPDOCKER == nil then
		RT.UI.mm:EventAttach(Event.UI.Input.Mouse.Left.Up, function(self, h)
			self.MouseDown = false
			if ResourceTracker_Settings.locked == false then
				ResourceTracker_Settings.mmx = RT.UI.mm:GetLeft()
				ResourceTracker_Settings.mmy = RT.UI.mm:GetTop()
			end
		end, "Event.UI.Input.Mouse.Left.Up")

		RT.UI.mm:EventAttach(Event.UI.Input.Mouse.Cursor.Move, function(self, h)
			if ResourceTracker_Settings.locked == false then
				if self.MouseDown then
					local nx, ny
					local mouseData = Inspect.Mouse()
					nx = mouseData.x - self.sx
					ny = mouseData.y - self.sy
					RT.UI.mm:SetPoint("TOPLEFT", UIParent, "TOPLEFT", nx,ny)
				end
			end
		end, "Event.UI.Input.Mouse.Cursor.Move")

		RT.UI.mm:EventAttach(Event.UI.Input.Mouse.Right.Click, function(self, h)
			self.MouseDown = false
			ResourceTracker_Settings.locked = not ResourceTracker_Settings.locked
			if ResourceTracker_Settings.locked == false then
				RT.UI.mm:SetTexture(addon.identifier, "img/mm_button_bw.png")
			else
				RT.UI.mm:SetTexture(addon.identifier, "img/mm_button.png")
			end
		end, "Event.UI.Input.Mouse.Right.Click")
	end

	RT.UI.mm:EventAttach(Event.UI.Input.Mouse.Wheel.Forward, function(self, h)
		RT.UI.context:SetVisible(not RT.UI.context:GetVisible())
	end, "Event.UI.Input.Mouse.Wheel.Forward")

	RT.UI.mm:EventAttach(Event.UI.Input.Mouse.Wheel.Back, function(self, h)
		RT.UI.context:SetVisible(not RT.UI.context:GetVisible())
	end, "Event.UI.Input.Mouse.Wheel.Back")
end

function RT.BuildAlertIcons()
	for x=1,4 do
		local b=UI.CreateFrame("Frame", "alertborder:"..x, RT.UI.context)
		--b:SetVisible(false)
		b:SetBackgroundColor(1,0,0)
		b:SetWidth(36)
		b:SetHeight(36)
		b:SetLayer(1)
		local i=UI.CreateFrame("Texture", "alerticon:"..x, b)
		i:SetWidth(32)
		i:SetHeight(32)
		i:SetPoint("TOPLEFT", b, "TOPLEFT", 2,2)
		i:SetLayer(10)
		i:SetTexture("Rift", RT.ACTIVE_ABILITIES[x].icon)
		RT.UI.alert[x] = {b=b, i=i}
	end
	
	RT.UI.alert[1].b:SetPoint("BOTTOMLEFT", RT.UI.anchor, "TOPLEFT", 0,-5)
	RT.UI.alert[2].b:SetPoint("TOPLEFT", RT.UI.alert[1].b, "TOPRIGHT", 5,0)
	RT.UI.alert[3].b:SetPoint("TOPLEFT", RT.UI.alert[2].b, "TOPRIGHT", 5,0)
	RT.UI.alert[4].b:SetPoint("TOPLEFT", RT.UI.alert[3].b, "TOPRIGHT", 5,0)
end

function RT.BuildConfig()
	RT.UI.cfgwindow.config = UI.CreateFrame("RiftWindow", "RT.UI.cfgwindow.config", RT.UI.context)
	RT.UI.cfgwindow.config:SetVisible(false)
	RT.UI.cfgwindow.config:SetLayer(1)
	RT.UI.cfgwindow.config:SetTitle("ResourceTracker Configuration")

	local trl, trr, trt, trb
	trl, trt, trr, trb = RT.UI.cfgwindow.config:GetTrimDimensions()

	RT.UI.cfgwindow.close = UI.CreateFrame("RiftButton", "RT.UI.cfgwindow.close", RT.UI.cfgwindow.config)
	RT.UI.cfgwindow.close:SetSkin("close")
	RT.UI.cfgwindow.close:SetPoint("TOPRIGHT", RT.UI.cfgwindow.config, "TOPRIGHT", -8, 16)
	RT.UI.cfgwindow.close:SetLayer(3)
	
	local cfgborder = RT.UI.cfgwindow.config:GetBorder()

	RT.UI.cfgwindow.close:EventAttach(Event.UI.Input.Mouse.Left.Click, function(self, h)
		RT.UI.cfgwindow.config:SetVisible(false)
		RT.UI.anchor:SetVisible(false)
		for k,v in pairs(RT.UI.configchk) do
			v.u:SetKeyFocus(false)
		end
	end, "Event.UI.Input.Mouse.Left.Click")

	cfgborder:EventAttach(Event.UI.Input.Mouse.Left.Down, function(self, h)
		local mouseData = Inspect.Mouse()
		self.sx = mouseData.x - RT.UI.cfgwindow.config:GetLeft()
		self.sy = mouseData.y - RT.UI.cfgwindow.config:GetTop()
		self.MouseDown = true
	end, "Event.UI.Input.Mouse.Left.Down")

	cfgborder:EventAttach(Event.UI.Input.Mouse.Left.Up, function(self, h)
		self.MouseDown = false
		ResourceTracker_Settings.cfgx = RT.UI.cfgwindow.config:GetLeft()
		ResourceTracker_Settings.cfgy = RT.UI.cfgwindow.config:GetTop()
	end, "Event.UI.Input.Mouse.Left.Up")

	cfgborder:EventAttach(Event.UI.Input.Mouse.Cursor.Move, function(self, h)
		if self.MouseDown then
			local nx, ny
			local mouseData = Inspect.Mouse()
			nx = mouseData.x - self.sx
			ny = mouseData.y - self.sy
			RT.UI.cfgwindow.config:SetPoint("TOPLEFT", UIParent, "TOPLEFT", nx,ny)
		end
	end, "Event.UI.Input.Mouse.Cursor.Move")
	
	RT.UI.cfgwindow.hdr = {}
	
	local hdbg = {
		[true] =	{0,0,0.8},
		[false] =	{0,0,0}
	}
	local hdtx = {
		"Options", "Ore", "Wood", "Plants", "Fish", "Artifacts"
	}
	
	for x=1, 6 do
		local f = UI.CreateFrame("Text", "RT.UI.cfgwindow.hdr.f:"..x, RT.UI.cfgwindow.config)
		f:SetHeight(24)
		f:SetLayer(4)
		f:SetFontSize(16)
		f:SetText(hdtx[x])
		f:SetFont(addon.identifier, "font/Cocogoose_trial.otf")
		
		f:EventAttach(Event.UI.Input.Mouse.Left.Click, function(self, h)
			 for l=1, 6 do
				RT.UI.cfgwindow.hdr[l].b:SetVisible(l==x)
				RT.UI.cfgwindow.hdr[l].f:SetBackgroundColor(unpack(hdbg[l==x]))
			 end
		end, "Event.UI.Input.Mouse.Left.Click")
		
		local b = UI.CreateFrame("Frame", "RT.UI.cfgwindow.hdr.b:"..x, RT.UI.cfgwindow.config)
		b:SetHeight(384)
		b:SetLayer(4)
		
		if x==1 then
			f:SetPoint("TOPLEFT", RT.UI.cfgwindow.config, "TOPLEFT", trl, trt)
			b:SetVisible(true)
			f:SetBackgroundColor(0,0,0.8)
		else
			f:SetPoint("TOPLEFT", RT.UI.cfgwindow.hdr[x-1].f, "TOPRIGHT", 2, 0)
			b:SetVisible(false)
			f:SetBackgroundColor(0,0,0)
		end
		
 		RT.UI.cfgwindow.hdr[x] = { f=f, b=b }		
		RT.UI.cfgwindow.hdr[x].b:SetPoint("TOPLEFT", RT.UI.cfgwindow.hdr[1].f, "BOTTOMLEFT", 0,2)
	end
end

function RT.BuildUI()
	RT.UI = {
		trackers = {},
		configchk = {},
		alert = {},
		vals = {},
		lang_hdrs = {},
		cfgwindow = {}
	}

	RT.UI.context = UI.CreateContext(addon.identifier)
	RT.UI.contextMM = UI.CreateContext(addon.identifier)

	RT.BuildMinimapButtons()
	RT.BuildConfig()

	local frm_metal = nil
	local frm_wood = nil
	local frm_plants = nil
	local frm_fish = nil

	local frm_p = nil

	RT.UI.vals.txt_w = 0

	for k,v in pairs(RT.ITEMS["MINING"]) do
		RT.UI.configchk[v.name.EN] = RT.CreateConfig(k,v, RT.UI.cfgwindow.hdr[2].b)
		RT.UI.vals.txt_w = math_max(RT.UI.vals.txt_w, RT.UI.configchk[v.name.EN].t:GetWidth())

		if frm_p == nil then
			frm_metal = RT.UI.configchk[v.name.EN].e
		else
			RT.UI.configchk[v.name.EN].e:SetPoint("TOPLEFT", frm_p, "BOTTOMLEFT", 0,0)
		end

		frm_p = RT.UI.configchk[v.name.EN].e
		RT.ICONS[v.name.EN] = v.icon
		RT.RESTYPE[v.name.EN] = IDX_ORE
	end

	frm_p = nil
	for k,v in pairs(RT.ITEMS["WOOD"]) do
		RT.UI.configchk[v.name.EN] = RT.CreateConfig(k,v, RT.UI.cfgwindow.hdr[3].b)
		RT.UI.vals.txt_w = math_max(RT.UI.vals.txt_w, RT.UI.configchk[v.name.EN].t:GetWidth())

		if frm_p == nil then
			frm_wood = RT.UI.configchk[v.name.EN].e
		else
			RT.UI.configchk[v.name.EN].e:SetPoint("TOPLEFT", frm_p, "BOTTOMLEFT", 0,0)
		end

		frm_p = RT.UI.configchk[v.name.EN].e
		RT.ICONS[v.name.EN] = v.icon
		RT.RESTYPE[v.name.EN] = IDX_WOOD
	end

	frm_p = nil
	for k,v in pairs(RT.ITEMS["PLANTS"]) do
		RT.UI.configchk[v.name.EN] = RT.CreateConfig(k,v, RT.UI.cfgwindow.hdr[4].b)
		RT.UI.vals.txt_w = math_max(RT.UI.vals.txt_w, RT.UI.configchk[v.name.EN].t:GetWidth())

		if frm_p == nil then
			frm_plants = RT.UI.configchk[v.name.EN].e
		else
			if k==17 then
				RT.UI.configchk[v.name.EN].e:SetPoint("TOPLEFT", RT.UI.cfgwindow.hdr[4].b, "TOPCENTER", 0,0)
			else
				RT.UI.configchk[v.name.EN].e:SetPoint("TOPLEFT", frm_p, "BOTTOMLEFT", 0,0)
			end
		end

		frm_p = RT.UI.configchk[v.name.EN].e
		RT.ICONS[v.name.EN] = v.icon
		RT.RESTYPE[v.name.EN] = IDX_PLANTS
	end

	frm_p = nil
	for k,v in pairs(RT.ITEMS["FISH"]) do
		RT.UI.configchk[v.name.EN] = RT.CreateConfig(k,v, RT.UI.cfgwindow.hdr[5].b)
		RT.UI.vals.txt_w = math_max(RT.UI.vals.txt_w, RT.UI.configchk[v.name.EN].t:GetWidth())

		if frm_p == nil then
			frm_fish = RT.UI.configchk[v.name.EN].e
		else
			RT.UI.configchk[v.name.EN].e:SetPoint("TOPLEFT", frm_p, "BOTTOMLEFT", 0,0)
		end

		frm_p = RT.UI.configchk[v.name.EN].e
		RT.ICONS[v.name.EN] = v.icon
		RT.RESTYPE[v.name.EN] = IDX_FISH
	end
	
	local k = #RT.ITEMS["FISH"]

	RT.UI.configchk[RT.ARTIFACTS.EN.N] = RT.CreateConfig(k+1,{name={EN=RT.ARTIFACTS.EN.N, [RT.SYSLANG]=RT.ARTIFACTS[RT.SYSLANG].N}, icon=RT.ICONS["Artifact"]}, RT.UI.cfgwindow.hdr[6].b)
	RT.UI.configchk[RT.ARTIFACTS.EN.N].e:SetPoint("TOPLEFT", RT.UI.cfgwindow.hdr[6].b, "TOPLEFT", 0,0)
	frm_p = RT.UI.configchk[RT.ARTIFACTS.EN.N].e
	
	RT.UI.configchk[RT.ARTIFACTS.EN.T] = RT.CreateConfig(k+2,{name={EN=RT.ARTIFACTS.EN.T, [RT.SYSLANG]=RT.ARTIFACTS[RT.SYSLANG].T}, icon=RT.ICONS["Twisted Artifact"]}, RT.UI.cfgwindow.hdr[6].b)
	RT.UI.configchk[RT.ARTIFACTS.EN.T].e:SetPoint("TOPLEFT", frm_p, "BOTTOMLEFT", 0,0)
	frm_p = RT.UI.configchk[RT.ARTIFACTS.EN.T].e

	RT.UI.configchk[RT.ARTIFACTS.EN.U] = RT.CreateConfig(k+3,{name={EN=RT.ARTIFACTS.EN.U, [RT.SYSLANG]=RT.ARTIFACTS[RT.SYSLANG].U}, icon=RT.ICONS["Unstable Artifact"]}, RT.UI.cfgwindow.hdr[6].b)
	RT.UI.configchk[RT.ARTIFACTS.EN.U].e:SetPoint("TOPLEFT", frm_p, "BOTTOMLEFT", 0,0)
	frm_p = RT.UI.configchk[RT.ARTIFACTS.EN.U].e

	RT.UI.configchk["UNK_ARTI_TYPE"] = RT.CreateConfig(k+4,{name={EN="UNK_ARTI_TYPE", [RT.SYSLANG]="UNK_ARTI_TYPE"}, icon=RT.ICONS["UNK_ARTI_TYPE"]}, RT.UI.cfgwindow.hdr[6].b)
	RT.UI.configchk["UNK_ARTI_TYPE"].e:SetPoint("TOPLEFT", frm_p, "BOTTOMLEFT", 0,0)
	frm_p = RT.UI.configchk["UNK_ARTI_TYPE"].e

	for k,v in pairs(RT.UI.configchk) do
		v.t:SetWidth(RT.UI.vals.txt_w)
		v.u:SetWidth(RT.UI.vals.txt_w)
	end

	local trl, trr, trt, trb
	trl, trt, trr, trb = RT.UI.cfgwindow.config:GetTrimDimensions()

	RT.UI.cfgwindow.config:SetWidth(trl+trr+((RT.UI.vals.txt_w+78)*2))
	local frmw = RT.UI.cfgwindow.config:GetWidth() - (trl + trr)
	local hdrw = math_floor((frmw-10)/6)
	for x=1, 6 do
		RT.UI.cfgwindow.hdr[x].f:SetWidth(hdrw)
		RT.UI.cfgwindow.hdr[x].b:SetWidth(frmw)
	end
	
	
	frm_metal:SetPoint("TOPLEFT", RT.UI.cfgwindow.hdr[2].b, "TOPLEFT", 0,0)

	frm_wood:SetPoint("TOPLEFT", RT.UI.cfgwindow.hdr[3].b, "TOPLEFT", 0, 0)
	frm_plants:SetPoint("TOPLEFT", RT.UI.cfgwindow.hdr[4].b, "TOPLEFT", 0, 0)
	frm_fish:SetPoint("TOPLEFT", RT.UI.cfgwindow.hdr[5].b, "TOPLEFT", 0, 0)

	RT.UI.cfgwindow.config:SetHeight(384 + 24 + trt + trb)

	local frmht = math_max(#RT.ITEMS["MINING"], #RT.ITEMS["WOOD"], #RT.ITEMS["PLANTS"], #RT.ITEMS["FISH"])

	RT.UI.l_nodes = UI.CreateFrame("Text", "RT.UI.l_nodes", RT.UI.cfgwindow.hdr[1].b)
	RT.UI.l_nodes:SetPoint("TOPLEFT", RT.UI.cfgwindow.hdr[1].b, "TOPLEFT", 2,2)
	RT.UI.l_nodes:SetFontSize(14)
	RT.UI.l_nodes:SetLayer(5)
	RT.UI.l_nodes:SetText("Number of nodes to display: ")

	RT.UI.s_nodes = UI.CreateFrame("RiftSlider", "RT.UI.s_nodes", RT.UI.cfgwindow.hdr[1].b)
	RT.UI.s_nodes:SetLayer(2)
	RT.UI.s_nodes:SetWidth(frmw-32)
	RT.UI.s_nodes:SetRange(1,RT.MAX_TRACK)
	RT.UI.s_nodes:SetPoint("TOPLEFT", RT.UI.l_nodes, "BOTTOMLEFT", 14,0)

	RT.UI.s_nodes:EventAttach(Event.UI.Slider.Change, function(self, h)
		ResourceTracker_Settings.num_nodes = RT.UI.s_nodes:GetPosition()
		RT.UI.l_nodes:SetText(string_format("Number of nodes to display: %d", ResourceTracker_Settings.num_nodes))
		if RT.SVLOADED then
			RT.ScanCurrentMap()
		end
	end, "Event.UI.Slider.Change")

	RT.UI.l_duration = UI.CreateFrame("Text", "RT.UI.l_duration", RT.UI.cfgwindow.hdr[1].b)
	RT.UI.l_duration:SetPoint("TOPLEFT", RT.UI.l_nodes, "BOTTOMLEFT", 0,14)
	RT.UI.l_duration:SetFontSize(14)
	RT.UI.l_duration:SetLayer(5)
	RT.UI.l_duration:SetText("Seconds to keep onscreen: ")

	RT.UI.s_duration = UI.CreateFrame("RiftSlider", "RT.UI.s_duration", RT.UI.cfgwindow.hdr[1].b)
	RT.UI.s_duration:SetLayer(2)
	RT.UI.s_duration:SetWidth(frmw-32)
	RT.UI.s_duration:SetRange(0,10)
	RT.UI.s_duration:SetPoint("TOPLEFT", RT.UI.l_duration, "BOTTOMLEFT", 14,0)
	RT.UI.s_duration:EventAttach(Event.UI.Slider.Change, function(self, h)
		ResourceTracker_Settings.fade_time = RT.UI.s_duration:GetPosition()
		RT.UI.l_duration:SetText(string_format("Seconds to keep onscreen: %d", ResourceTracker_Settings.fade_time))
	end, "Event.UI.Slider.Change")

	RT.UI.c_combat = UI.CreateFrame("RiftCheckbox", "RT.UI.c_combat", RT.UI.cfgwindow.hdr[1].b)
	RT.UI.c_combat:SetWidth(24)
	RT.UI.c_combat:SetHeight(24)
	RT.UI.c_combat:SetLayer(5)
	RT.UI.c_combat:SetPoint("TOPLEFT", RT.UI.l_duration, "BOTTOMLEFT", 0, 14)
	RT.UI.c_combat:EventAttach(Event.UI.Checkbox.Change, function(self, h)
		if RT.UI.c_combat:GetChecked() then
			ResourceTracker_Settings.showcombat = true
		else
			ResourceTracker_Settings.showcombat = false
		end
	end, "Event.UI.Checkbox.Change")

	RT.UI.l_combat = UI.CreateFrame("Text", "RT.UI.l_combat", RT.UI.cfgwindow.hdr[1].b)
	RT.UI.l_combat:SetFontSize(14)
	RT.UI.l_combat:SetLayer(15)
	RT.UI.l_combat:SetText("Show in combat")
	RT.UI.l_combat:SetPoint("CENTERLEFT", RT.UI.c_combat, "CENTERRIGHT", 2,0)

	RT.UI.c_dispmode = UI.CreateFrame("RiftCheckbox", "RT.UI.c_dispmode", RT.UI.cfgwindow.hdr[1].b)
	RT.UI.c_dispmode:SetWidth(24)
	RT.UI.c_dispmode:SetHeight(24)
	RT.UI.c_dispmode:SetLayer(5)
	RT.UI.c_dispmode:SetPoint("TOPLEFT", RT.UI.c_combat, "BOTTOMLEFT", 0,2)
	RT.UI.c_dispmode:EventAttach(Event.UI.Checkbox.Change, function(self, h)
		if RT.UI.c_dispmode:GetChecked() then
			ResourceTracker_Settings.dispmode = DM_STACKED
		else
			ResourceTracker_Settings.dispmode = DM_CLASSIC
		end
		RT.ResizeElements()
	end, "Event.UI.Checkbox.Change")

	RT.UI.l_dispmode = UI.CreateFrame("Text", "RT.UI.l_dispmode", RT.UI.cfgwindow.hdr[1].b)
	RT.UI.l_dispmode:SetFontSize(14)
	RT.UI.l_dispmode:SetLayer(15)
	RT.UI.l_dispmode:SetText("Use alternate displaymode")
	RT.UI.l_dispmode:SetPoint("CENTERLEFT", RT.UI.c_dispmode, "CENTERRIGHT", 2,0)

	RT.UI.c_relative = UI.CreateFrame("RiftCheckbox", "RT.UI.c_relative", RT.UI.cfgwindow.hdr[1].b)
	RT.UI.c_relative:SetWidth(24)
	RT.UI.c_relative:SetHeight(24)
	RT.UI.c_relative:SetLayer(5)
	RT.UI.c_relative:SetPoint("TOPLEFT", RT.UI.c_dispmode, "BOTTOMLEFT", 0,2)
	RT.UI.c_relative:EventAttach(Event.UI.Checkbox.Change, function(self, h)
		ResourceTracker_Settings.relative = RT.UI.c_relative:GetChecked()
	end, "Event.UI.Checkbox.Change")

	RT.UI.l_relative = UI.CreateFrame("Text", "RT.UI.l_relative", RT.UI.cfgwindow.hdr[1].b)
	RT.UI.l_relative:SetFontSize(14)
	RT.UI.l_relative:SetLayer(15)
	RT.UI.l_relative:SetText("Show relative direction arrows")
	RT.UI.l_relative:SetPoint("CENTERLEFT", RT.UI.c_relative, "CENTERRIGHT", 2,0)

	RT.UI.c_distmode = UI.CreateFrame("RiftCheckbox", "RT.UI.c_distmode", RT.UI.cfgwindow.hdr[1].b)
	RT.UI.c_distmode:SetWidth(24)
	RT.UI.c_distmode:SetHeight(24)
	RT.UI.c_distmode:SetLayer(5)
	RT.UI.c_distmode:SetPoint("TOPLEFT", RT.UI.c_relative, "BOTTOMLEFT", 0, 2)
	RT.UI.c_distmode:EventAttach(Event.UI.Checkbox.Change, function(self, h)
		ResourceTracker_Settings.use3Dmode = RT.UI.c_distmode:GetChecked()
	end, "Event.UI.Checkbox.Change")

	RT.UI.l_distmode = UI.CreateFrame("Text", "RT.UI.l_distmode", RT.UI.cfgwindow.hdr[1].b)
	RT.UI.l_distmode:SetFontSize(14)
	RT.UI.l_distmode:SetLayer(15)
	RT.UI.l_distmode:SetText("Use 3D distances")
	RT.UI.l_distmode:SetPoint("CENTERLEFT", RT.UI.c_distmode, "CENTERRIGHT", 2,0)

	RT.UI.c_elevmode = UI.CreateFrame("RiftCheckbox", "RT.UI.c_elevmode", RT.UI.cfgwindow.hdr[1].b)
	RT.UI.c_elevmode:SetWidth(24)
	RT.UI.c_elevmode:SetHeight(24)
	RT.UI.c_elevmode:SetLayer(5)
	RT.UI.c_elevmode:SetPoint("TOPLEFT", RT.UI.c_distmode, "BOTTOMLEFT", 0,2)
	RT.UI.c_elevmode:EventAttach(Event.UI.Checkbox.Change, function(self, h)
		ResourceTracker_Settings.showelevation = RT.UI.c_elevmode:GetChecked()
		for x=1, RT.MAX_TRACK do
			RT.UI.trackers[x].e:SetVisible(ResourceTracker_Settings.showelevation)
		end		
	end, "Event.UI.Checkbox.Change")

	RT.UI.l_elevmode = UI.CreateFrame("Text", "RT.UI.l_elevmode", RT.UI.cfgwindow.hdr[1].b)
	RT.UI.l_elevmode:SetFontSize(14)
	RT.UI.l_elevmode:SetLayer(15)
	RT.UI.l_elevmode:SetText("Show elevation difference")
	RT.UI.l_elevmode:SetPoint("CENTERLEFT", RT.UI.c_elevmode, "CENTERRIGHT", 2,0)

	RT.UI.c_articolor = UI.CreateFrame("RiftCheckbox", "RT.UI.c_articolor", RT.UI.cfgwindow.hdr[6].b)
	RT.UI.c_articolor:SetWidth(24)
	RT.UI.c_articolor:SetHeight(24)
	RT.UI.c_articolor:SetLayer(5)
	RT.UI.c_articolor:SetPoint("TOPLEFT", RT.UI.cfgwindow.hdr[6].b, "TOPCENTER", 0,0)
	RT.UI.c_articolor:EventAttach(Event.UI.Checkbox.Change, function(self, h)
		ResourceTracker_Settings.articolor = RT.UI.c_articolor:GetChecked()
	end, "Event.UI.Checkbox.Change")

	RT.UI.l_articolor = UI.CreateFrame("Text", "RT.UI.l_articolor", RT.UI.cfgwindow.hdr[6].b)
	RT.UI.l_articolor:SetFontSize(14)
	RT.UI.l_articolor:SetLayer(15)
	RT.UI.l_articolor:SetText("Show best artifact rarity")
	RT.UI.l_articolor:SetPoint("CENTERLEFT", RT.UI.c_articolor, "CENTERRIGHT", 2,0)

	RT.UI.c_ghostmode = UI.CreateFrame("RiftCheckbox", "RT.UI.c_ghostmode", RT.UI.cfgwindow.hdr[6].b)
	RT.UI.c_ghostmode:SetWidth(24)
	RT.UI.c_ghostmode:SetHeight(24)
	RT.UI.c_ghostmode:SetLayer(5)
	RT.UI.c_ghostmode:SetPoint("TOPLEFT", RT.UI.c_articolor, "BOTTOMLEFT", 0,2)
	RT.UI.c_ghostmode:EventAttach(Event.UI.Checkbox.Change, function(self, h)
		ResourceTracker_Settings.ghostmode = RT.UI.c_ghostmode:GetChecked()
	end, "Event.UI.Checkbox.Change")

	RT.UI.l_ghostmode = UI.CreateFrame("Text", "RT.UI.l_ghostmode", RT.UI.cfgwindow.hdr[6].b)
	RT.UI.l_ghostmode:SetFontSize(14)
	RT.UI.l_ghostmode:SetLayer(15)
	RT.UI.l_ghostmode:SetText("Use artifact ghostmode")
	RT.UI.l_ghostmode:SetPoint("CENTERLEFT", RT.UI.c_ghostmode, "CENTERRIGHT", 2,0)

	RT.UI.l_arti = {}
	
	RT.UI.l_arti.NOR = UI.CreateFrame("Text", "RT.UI.l_artiNOR", RT.UI.cfgwindow.hdr[6].b)
	RT.UI.l_arti.NOR:SetFontSize(14)
	RT.UI.l_arti.NOR:SetLayer(15)
	RT.UI.l_arti.NOR:SetText("Normal:")
	RT.UI.l_arti.NOR:SetPoint("TOPLEFT", RT.UI.c_ghostmode, "BOTTOMLEFT", 0,2)

	RT.UI.l_arti.TWI = UI.CreateFrame("Text", "RT.UI.l_artiTWI", RT.UI.cfgwindow.hdr[6].b)
	RT.UI.l_arti.TWI:SetFontSize(14)
	RT.UI.l_arti.TWI:SetLayer(15)
	RT.UI.l_arti.TWI:SetText("Twisted:")
	RT.UI.l_arti.TWI:SetPoint("TOPLEFT", RT.UI.l_arti.NOR, "BOTTOMLEFT", 0,2)

	RT.UI.l_arti.UNS = UI.CreateFrame("Text", "RT.UI.l_artiUNS", RT.UI.cfgwindow.hdr[6].b)
	RT.UI.l_arti.UNS:SetFontSize(14)
	RT.UI.l_arti.UNS:SetLayer(15)
	RT.UI.l_arti.UNS:SetText("Unstable:")
	RT.UI.l_arti.UNS:SetPoint("TOPLEFT", RT.UI.l_arti.TWI, "BOTTOMLEFT", 0,2)

	RT.UI.l_arti.UNK = UI.CreateFrame("Text", "RT.UI.l_artiUNS", RT.UI.cfgwindow.hdr[6].b)
	RT.UI.l_arti.UNK:SetFontSize(14)
	RT.UI.l_arti.UNK:SetLayer(15)
	RT.UI.l_arti.UNK:SetText("Unknown:")
	RT.UI.l_arti.UNK:SetPoint("TOPLEFT", RT.UI.l_arti.UNS, "BOTTOMLEFT", 0,2)
	
	RT.UI.cbRarityLevels = {}
	
	for kt, vt in ipairs(RT.tRarityLevels[1]) do
		RT.UI.cbRarityLevels[vt] = {}
		local c = UI.CreateFrame("Texture", "RT.UI.cb:"..vt, RT.UI.cfgwindow.hdr[6].b)
		c:SetWidth(24)
		c:SetHeight(24)
		c:SetLayer(5)
		local btMask = RT.FLAGS_R[RT.FLAGS_N[vt]].default
		
		c:EventAttach(Event.UI.Input.Mouse.Left.Click, function(self, h)
			local csel = ResourceTracker_Settings.ghostinclude[vt].def
			local fMask = RT.GHOSTFILTER
			local xMask = RT.GHOSTEXCLUDE
			
			if csel == RT_NONE then
				csel = RT_INCLUDE
				RT.GHOSTFILTER = bit.bor(RT.GHOSTFILTER, btMask)
				RT.GHOSTEXCLUDE = bit.band(RT.GHOSTEXCLUDE, bit.bnot(btMask))
			else
				csel = RT_NONE
				RT.GHOSTEXCLUDE = bit.band(RT.GHOSTEXCLUDE, bit.bnot(btMask))
				RT.GHOSTFILTER = bit.band(RT.GHOSTFILTER, bit.bnot(btMask))
			end
			ResourceTracker_Settings.ghostinclude[vt].def = csel
			c:SetTexture(addon.identifier, RT.CHECKBOX[csel])
			last_shadow.tx = 0
			last_update = 0
			debug(string.format("%s.%s [%d] f:%d -> %d x:%d -> %d", vt, v, btMask, fMask, RT.GHOSTFILTER, xMask, RT.GHOSTEXCLUDE))
		end, "Event.UI.Input.Mouse.Left.Click")
		
		RT.UI.cbRarityLevels[vt].def = {cb = c, bit = btMask}
		
		for k,v in ipairs(RT.tRarityLevels[2]) do
			local c = UI.CreateFrame("Texture", "RT.UI.cb:"..vt..":"..v, RT.UI.cfgwindow.hdr[6].b)
			c:SetWidth(24)
			c:SetHeight(24)
			c:SetLayer(5)
			c:SetBackgroundColor(unpack(RT.tRarityCols[v]))
			
			local btMask = RT.FLAGS_R[RT.FLAGS_N[vt]][RT.FLAGS_N[v]]
			
			c:EventAttach(Event.UI.Input.Mouse.Right.Click, function(self, h)
				local csel = ResourceTracker_Settings.ghostinclude[vt][v]
				local fMask = RT.GHOSTFILTER
				local xMask = RT.GHOSTEXCLUDE

				if csel == RT_NONE then
					csel = RT_EXCLUDE
					RT.GHOSTFILTER = bit.band(RT.GHOSTFILTER, bit.bnot(btMask))
					RT.GHOSTEXCLUDE = bit.bor(RT.GHOSTEXCLUDE, btMask)
				else
					csel = RT_NONE
					RT.GHOSTEXCLUDE = bit.band(RT.GHOSTEXCLUDE, bit.bnot(btMask))
					RT.GHOSTFILTER = bit.band(RT.GHOSTFILTER, bit.bnot(btMask))
				end

				ResourceTracker_Settings.ghostinclude[vt][v] = csel
				c:SetTexture(addon.identifier, RT.CHECKBOX[csel])
				last_shadow.tx = 0
				last_update = 0
				debug(string.format("%s.%s [%d] f:%d -> %d x:%d -> %d", vt, v, btMask, fMask, RT.GHOSTFILTER, xMask, RT.GHOSTEXCLUDE))
			end, "Event.UI.Input.Mouse.Right.Click")
			
			c:EventAttach(Event.UI.Input.Mouse.Left.Click, function(self, h)
				local csel = ResourceTracker_Settings.ghostinclude[vt][v]
				local fMask = RT.GHOSTFILTER
				local xMask = RT.GHOSTEXCLUDE

				if csel == RT_NONE then
					csel = RT_INCLUDE
					RT.GHOSTFILTER = bit.bor(RT.GHOSTFILTER, btMask)
					RT.GHOSTEXCLUDE = bit.band(RT.GHOSTEXCLUDE, bit.bnot(btMask))
				else
					csel = RT_NONE
					RT.GHOSTEXCLUDE = bit.band(RT.GHOSTEXCLUDE, bit.bnot(btMask))
					RT.GHOSTFILTER = bit.band(RT.GHOSTFILTER, bit.bnot(btMask))
				end

				ResourceTracker_Settings.ghostinclude[vt][v] = csel
				c:SetTexture(addon.identifier, RT.CHECKBOX[csel])
				last_shadow.tx = 0
				last_update = 0
				debug(string.format("%s.%s [%d] f:%d -> %d x:%d -> %d", vt, v, btMask, fMask, RT.GHOSTFILTER, xMask, RT.GHOSTEXCLUDE))
			end, "Event.UI.Input.Mouse.Left.Click")
			
			if k==1 then
				c:SetPoint("TOPLEFT", RT.UI.l_arti[vt], "TOPLEFT", frmw/4,0)
			else
				c:SetPoint("TOPLEFT", RT.UI.cbRarityLevels[vt][RT.tRarityLevels[2][k-1]].cb, "TOPRIGHT", 0,0)
			end
			RT.UI.cbRarityLevels[vt][v] = {cb = c, bit = btMask }
		end
	end

	local c = UI.CreateFrame("Texture", "RT.UI.cb:UNK", RT.UI.cfgwindow.hdr[6].b)
	c:SetWidth(24)
	c:SetHeight(24)
	c:SetLayer(5)
	c:EventAttach(Event.UI.Input.Mouse.Left.Click, function(self, h)
		local csel = ResourceTracker_Settings.ghostinclude.UNK.def
		if csel == RT_NONE then
			csel = RT_INCLUDE
		else
			csel = RT_NONE
		end
		ResourceTracker_Settings.ghostinclude.UNK.def = csel
		c:SetTexture(addon.identifier, RT.CHECKBOX[csel])
		local btMask = RT.FLAGS_N["UNKNOWN"]
		local cMask = RT.GHOSTFILTER
		RT.GHOSTFILTER = bit.bxor(RT.GHOSTFILTER, btMask)
		last_shadow.tx = 0
		last_update = 0
		debug(string.format("%s.%s [%d] %d -> %d", vt, v, btMask, cMask, RT.GHOSTFILTER))
	end, "Event.UI.Input.Mouse.Left.Click")
	
	RT.UI.cbRarityLevels.UNK = { def = { cb = c, bit=RT.FLAGS_N["UNKNOWN"] }}
	
	RT.UI.cbRarityLevels.NOR.def.cb:SetPoint("TOPRIGHT", RT.UI.cbRarityLevels.NOR.co.cb, "TOPLEFT", 0,0)
	RT.UI.cbRarityLevels.TWI.def.cb:SetPoint("TOPRIGHT", RT.UI.cbRarityLevels.TWI.co.cb, "TOPLEFT", 0,0)
	RT.UI.cbRarityLevels.UNS.def.cb:SetPoint("TOPRIGHT", RT.UI.cbRarityLevels.UNS.co.cb, "TOPLEFT", 0,0)
	RT.UI.cbRarityLevels.UNK.def.cb:SetPoint("TOPLEFT", RT.UI.cbRarityLevels.UNS.def.cb, "BOTTOMLEFT", 0,0)
	
	RT.UI.l_numghost = UI.CreateFrame("Text", "RT.UI.l_nodes", RT.UI.cfgwindow.hdr[6].b)
	RT.UI.l_numghost:SetPoint("TOPLEFT", RT.UI.l_arti.UNK, "BOTTOMLEFT", 0,2)
	RT.UI.l_numghost:SetFontSize(14)
	RT.UI.l_numghost:SetLayer(5)
	RT.UI.l_numghost:SetText("Number of ghost nodes to display: ")

	RT.UI.s_numghost = UI.CreateFrame("RiftSlider", "RT.UI.s_numghost", RT.UI.cfgwindow.hdr[6].b)
	RT.UI.s_numghost:SetLayer(2)
	RT.UI.s_numghost:SetWidth((frmw-32)/2)
	RT.UI.s_numghost:SetRange(1,RT.MAX_TRACK)
	RT.UI.s_numghost:SetPoint("TOPLEFT", RT.UI.l_numghost, "BOTTOMLEFT", 8,0)

	RT.UI.s_numghost:EventAttach(Event.UI.Slider.Change, function(self, h)
		ResourceTracker_Settings.num_gnodes = RT.UI.s_numghost:GetPosition()
		RT.UI.l_numghost:SetText(string_format("Number of ghost nodes to display: %d", ResourceTracker_Settings.num_gnodes))
		if RT.SVLOADED then
			RT.ScanCurrentMap()
		end
	end, "Event.UI.Slider.Change")	
	
	RT.UI.c_KCNor = UI.CreateFrame("RiftCheckbox", "RT.UI.c_KCNor", RT.UI.cfgwindow.hdr[6].b)
	RT.UI.c_KCNor:SetWidth(24)
	RT.UI.c_KCNor:SetHeight(24)
	RT.UI.c_KCNor:SetLayer(5)
	RT.UI.c_KCNor:SetPoint("TOPLEFT", RT.UI.l_numghost, "TOPLEFT", 0,30)
	RT.UI.c_KCNor:EventAttach(Event.UI.Checkbox.Change, function(self, h)
		ResourceTracker_Settings.hidecommon = RT.UI.c_KCNor:GetChecked()
		RT.ScanCurrentMap()
	end, "Event.UI.Checkbox.Change")

	RT.UI.l_KCNor = UI.CreateFrame("Text", "RT.UI.l_KCNor", RT.UI.cfgwindow.hdr[6].b)
	RT.UI.l_KCNor:SetFontSize(14)
	RT.UI.l_KCNor:SetLayer(15)
	RT.UI.l_KCNor:SetText("Hide known common locations")
	RT.UI.l_KCNor:SetPoint("CENTERLEFT", RT.UI.c_KCNor, "CENTERRIGHT", 2,0)
	
	RT.UI.cfgwindow.configscale = UI.CreateFrame("Frame", "RT.UI.cfgwindow.configscale", RT.UI.cfgwindow.hdr[1].b)
	RT.UI.cfgwindow.configscale:SetWidth(frmw)
	RT.UI.cfgwindow.configscale:SetHeight(48)
	RT.UI.cfgwindow.configscale:SetLayer(1)
	RT.UI.cfgwindow.configscale:SetBackgroundColor(0.25,0,0,0.5)
	RT.UI.cfgwindow.configscale:SetPoint("BOTTOMLEFT", RT.UI.cfgwindow.hdr[1].b, "BOTTOMLEFT", 0,0)

	RT.UI.cfgwindow.configscale_ctr = UI.CreateFrame("Frame", "RT.UI.cfgwindow.configscale_ctr", RT.UI.cfgwindow.configscale)
	RT.UI.cfgwindow.configscale_ctr:SetPoint("CENTER", RT.UI.cfgwindow.configscale, "CENTER", 0,0)
	RT.UI.cfgwindow.configscale_ctr:SetLayer(2)

	RT.UI.cfgwindow.configscale:EventAttach(Event.UI.Input.Mouse.Wheel.Forward, function(self, h)
		if ResourceTracker_Settings.fontsize <= 128 then
			ResourceTracker_Settings.fontsize = ResourceTracker_Settings.fontsize+1
			RT.ResizeElements()
		end
	end, "Event.UI.Input.Mouse.Wheel.Forward")

	RT.UI.cfgwindow.configscale:EventAttach(Event.UI.Input.Mouse.Wheel.Back, function(self, h)
		if ResourceTracker_Settings.fontsize >= 12 then
			ResourceTracker_Settings.fontsize = ResourceTracker_Settings.fontsize-1
			RT.ResizeElements()
		end
	end, "Event.UI.Input.Mouse.Wheel.Back")

	RT.UI.cs_d = UI.CreateFrame("Texture", "RT.UI.cs_d", RT.UI.cfgwindow.configscale)
	RT.UI.cs_d:SetPoint("TOPLEFT", RT.UI.cfgwindow.configscale_ctr, "TOPLEFT", 0,0)
	RT.UI.cs_d:SetTexture(addon.identifier, "img/L00.png")
	RT.UI.cs_d:SetLayer(5)

	RT.UI.cs_i = UI.CreateFrame("Texture", "RT.UI.cs_i", RT.UI.cfgwindow.configscale)
	RT.UI.cs_i:SetPoint("TOPLEFT", RT.UI.cs_d, "TOPRIGHT", 0,0)
	RT.UI.cs_i:SetTexture("Rift", "Data\\UI\\item_icons\\ore02.dds")
	RT.UI.cs_i:SetLayer(5)

	RT.UI.cs_t = UI.CreateFrame("Text", "RT.UI.cs_t", RT.UI.cfgwindow.configscale)
	RT.UI.cs_t:SetPoint("CENTERLEFT", RT.UI.cs_i, "CENTERRIGHT", 0,0)
	RT.UI.cs_t:SetText("Resource Node [123m]")
	RT.UI.cs_t:SetLayer(5)

	local fht = 0

	--local bgcols = { {0,0,0}, {0,0,1}, {0,1,0}, {0,1,1}, {1,0,0}, {1,0,1}, {0.8,0.8,0.8} }

	for x=1,RT.MAX_TRACK do
		local f = UI.CreateFrame("Frame", "tracker_f:"..x, RT.UI.context)
		f:SetLayer(100)
		local d = UI.CreateFrame("Text", "tracker_d:"..x, f)
		d:SetFontColor(1,1,1)
		d:SetLayer(120)
		d:SetEffectGlow({strength=5, blurX=2, blurY=2})
		local i = UI.CreateFrame("Texture", "tracker_i:"..x, f)
		i:SetLayer(110)
		i.ci = ""
		local dx= UI.CreateFrame("Texture", "tracker_dx:"..x, f)
		dx:SetLayer(110)
		dx.ci = ""
		local e = UI.CreateFrame("Text", "tracker_e:"..x, f)
		e:SetFontColor(1,1,1)
		e:SetAlpha(0.75)
		e:SetLayer(120)
		e:SetFont(addon.identifier, "font/Oregon LDO Black.ttf")
		e:SetEffectGlow({strength=5, blurX=2, blurY=2})
		dx:SetPoint("TOPLEFT", f, "TOPLEFT", 1,1)
		e:SetPoint("CENTER", dx, "CENTER", 0,0)
		table_insert(RT.UI.trackers, {f=f, d=d, i=i, dx=dx, e=e})
	end

	RT.UI.FRAMESIZE = UI.CreateFrame("Text", "RT.UI.FRAMESIZE", RT.UI.context)
	RT.UI.FRAMESIZE:SetVisible(false)
	RT.UI.FRAMESIZE:SetText("QQqq")
	RT.UI.FRAMESIZE:SetPoint("TOPLEFT", UIParent, "TOPLEFT", -256, -256)

	RT.UI.anchor = UI.CreateFrame("Text", "RT.UI.anchor", RT.UI.context)
	RT.UI.anchor:SetVisible(false)
	RT.UI.anchor:SetFontSize(14)
	RT.UI.anchor:SetText("Resource Tracker")
	RT.UI.anchor:SetBackgroundColor(0,0,1,1)
	RT.UI.anchor:SetFontColor(1,1,1,1)
	
	RT.UI.anchor:EventAttach(Event.UI.Input.Mouse.Left.Down, function(self, h)
		self.MouseDown = true
		local mouseData = Inspect.Mouse()
		self.sx = mouseData.x - RT.UI.trackers[1].f:GetLeft()
		self.sy = mouseData.y - RT.UI.trackers[1].f:GetTop()
	end, "Event.UI.Input.Mouse.Left.Down")

	RT.UI.anchor:EventAttach(Event.UI.Input.Mouse.Cursor.Move, function(self, h)
		if self.MouseDown then
			local nx, ny
			local mouseData = Inspect.Mouse()
			nx = mouseData.x - self.sx
			ny = mouseData.y - self.sy
			RT.UI.trackers[1].f:SetPoint("TOPLEFT", UIParent, "TOPLEFT", nx,ny)
		end
	end, "Event.UI.Input.Mouse.Cursor.Move")

	RT.UI.anchor:EventAttach(Event.UI.Input.Mouse.Left.Up, function(self, h)
		if self.MouseDown then
			self.MouseDown = false
		end
		ResourceTracker_Settings.trx = RT.UI.trackers[1].f:GetLeft()
		ResourceTracker_Settings.try = RT.UI.trackers[1].f:GetTop()
	end, "Event.UI.Input.Mouse.Left.Up")

	RT.BuildAlertIcons()
	--RT.BuildLangConfig()
	
end

function RT.Event_Addon_SavedVariables_Load_End(h,a)
	if a == addon.identifier then
		if ResourceTracker_Settings == nil then ResourceTracker_Settings = {} end
		if ResourceTracker_Nodes == nil then ResourceTracker_Nodes = {} end
		if ResourceTracker_Nodes.Rarity == nil then ResourceTracker_Nodes.Rarity = {} end

		if ResourceTracker_Nodes.version == nil or ResourceTracker_Nodes.version < default_settings.version then
			if ResourceTracker_Nodes.version == nil then
				local cx
				local cidx
				local newRTS = {}
				local lud
				local errors = {}
				for tk, tv in pairs(ResourceTracker_Nodes) do
					newRTS[tk] = {}
					for zk,zv in pairs(tv) do
						newRTS[tk][zk] = {}
						for ik,iv in pairs(zv) do
							cx = {0,0,0}
							cidx = 0
							for tkn in string_gmatch(ik, "[0-9]+") do cidx=cidx+1 cx[cidx]=tkn end
							newRTS[tk][zk][ik] = { x=cx[1], z=cx[2], y=cx[3], nodes = {} }
							for rk, rv in pairs(iv) do
								lud = RT.LOOKUP[rk]
								if lud then
									newRTS[tk][zk][ik].nodes[lud.k] = true
								else
									if errors[rk] == nil then
										errors[rk] = true
									end
								end
							end
						end
					end
				end

				ResourceTracker_Nodes = {}
				MergeTable(ResourceTracker_Nodes, newRTS)
			elseif ResourceTracker_Nodes.version < "2.03r3" then
				for rk=1, 4 do
					for zk, zv in pairs(ResourceTracker_Nodes[rk]) do
						for nk, nv in pairs(zv) do
							ResourceTracker_Nodes[rk][zk][nk].x = tonumber(nv.x)
							ResourceTracker_Nodes[rk][zk][nk].y = tonumber(nv.y)
							ResourceTracker_Nodes[rk][zk][nk].z = tonumber(nv.z)
						end
					end
				end
			end
		end

		MergeTable(ResourceTracker_Settings, default_settings)
		MergeTable(ResourceTracker_Nodes, default_settings_node)
		
		if ResourceTracker_Nodes and ResourceTracker_Nodes.version and ResourceTracker_Nodes.version < "2.08v11.R" then
		
			if ResourceTracker_Nodes.Rarity then
				for k,v in pairs(ResourceTracker_Nodes.Rarity) do
					local nt, nv = next(v)
					if nt and nv and type(nv) == "number" then
						local tConvert = {}
						for lk, lv in pairs(v) do
							tConvert[lk] = {t=DISC_GATHER, r=lv}
						end
						ResourceTracker_Nodes.Rarity[k] = tConvert
					end
				end
			end
		
			if ResourceTracker_Nodes.Artifacts then
				local ax, ay, az, ak
				
				for zk,zv in pairs(ResourceTracker_Nodes.Artifacts) do
					for lk, lv in pairs(zv) do
						ax = 5*math_floor(lv.x/5)
						ay = 5*math_floor(lv.y/5)
						az = 5*math_floor(lv.z/5)
						ak = string_format("%d.%d.%d", ax, az, ay)
						if ResourceTracker_Nodes.Rarity[zk] == nil then
							ResourceTracker_Nodes.Rarity[zk] = {}
						end
						if ResourceTracker_Nodes.Rarity[zk][ak] == nil then
							ResourceTracker_Nodes.Rarity[zk][ak] = {t=DISC_GATHER, r=0}
						end
					end
				end
			end

			local bNOR = bit.lshift(31, 8)
			local bTWI = bit.lshift(31, 16)
			local bUNS = bit.lshift(31, 24)
			
			for zk,zv in pairs(ResourceTracker_Nodes.Rarity) do
				for ak, av in pairs(zv) do
					if ResourceTracker_Nodes.Rarity[zk][ak].flags and ResourceTracker_Nodes.Rarity[zk][ak].flags > 0 then
						if bit.band(ResourceTracker_Nodes.Rarity[zk][ak].flags, bNOR) > 0 then
							ResourceTracker_Nodes.Rarity[zk][ak].flags = bit.bor(ResourceTracker_Nodes.Rarity[zk][ak].flags, RT.FLAGS_R["artifact normal"].default)
						end
						if bit.band(ResourceTracker_Nodes.Rarity[zk][ak].flags, bTWI) > 0 then
							ResourceTracker_Nodes.Rarity[zk][ak].flags = bit.bor(ResourceTracker_Nodes.Rarity[zk][ak].flags, RT.FLAGS_R["artifact twisted"].default)
						end
						if bit.band(ResourceTracker_Nodes.Rarity[zk][ak].flags, bUNS) > 0 then
							ResourceTracker_Nodes.Rarity[zk][ak].flags = bit.bor(ResourceTracker_Nodes.Rarity[zk][ak].flags, RT.FLAGS_R["artifact unstable"].default)
						end
					else
						ResourceTracker_Nodes.Rarity[zk][ak].flags = RT.FLAGS_N["UNKNOWN"]
					end
				end
			end
		end
		
		ResourceTracker_Nodes.version = addon.toc.Version

		if ResourceTracker_Settings.txn[RT.SYSLANG] == nil then
			ResourceTracker_Settings.txn[RT.SYSLANG] = {}
		end
		
		for rk, rv in pairs(RT.ITEMS) do
			for nk, nv in pairs(rv) do
				if ResourceTracker_Settings.txn[RT.SYSLANG][nv.name.EN] == nil then
					ResourceTracker_Settings.txn[RT.SYSLANG][nv.name.EN] = nv.name[RT.SYSLANG]
				end
				RT.ITEMS[rk][nk].name[RT.SYSLANG] = ResourceTracker_Settings.txn[RT.SYSLANG][nv.name.EN]
			end
		end
		
		if ResourceTracker_Settings.txn[RT.SYSLANG][RT.ARTIFACTS.EN.N] == nil then
			ResourceTracker_Settings.txn[RT.SYSLANG][RT.ARTIFACTS.EN.N] = RT.ARTIFACTS[RT.SYSLANG].N
			RT.RESTYPE[RT.ARTIFACTS.EN.N] = "Artifacts"
		end

		if ResourceTracker_Settings.txn[RT.SYSLANG][RT.ARTIFACTS.EN.T] == nil then
			ResourceTracker_Settings.txn[RT.SYSLANG][RT.ARTIFACTS.EN.T] = RT.ARTIFACTS[RT.SYSLANG].T
			RT.RESTYPE[RT.ARTIFACTS.EN.T] = "Artifacts"
		end

		if ResourceTracker_Settings.txn[RT.SYSLANG][RT.ARTIFACTS.EN.U] == nil then
			ResourceTracker_Settings.txn[RT.SYSLANG][RT.ARTIFACTS.EN.U] = RT.ARTIFACTS[RT.SYSLANG].U
			RT.RESTYPE[RT.ARTIFACTS.EN.U] = "Artifacts"
		end

		if ResourceTracker_Settings.txn[RT.SYSLANG]["ARTIFACT_SEARCH_PATTERN"] == nil then
			ResourceTracker_Settings.txn[RT.SYSLANG]["ARTIFACT_SEARCH_PATTERN"] = RT.ARTIFACTS[RT.SYSLANG].S
		end
		
		RT.UI.configchk["UNK_ARTI_TYPE"].t:SetText("Unknown: *"..ResourceTracker_Settings.txn[RT.SYSLANG]["ARTIFACT_SEARCH_PATTERN"].."*")
		RT.UI.configchk["UNK_ARTI_TYPE"].u:SetText(ResourceTracker_Settings.txn[RT.SYSLANG]["ARTIFACT_SEARCH_PATTERN"])
		
		RT.LOCAL = {}
		
		for k, v in pairs(ResourceTracker_Settings.txn[RT.SYSLANG]) do
			RT.LOCAL[v] = k
			RT.LOOKUP[v] = RT.LOOKUP[k]
			if RT.UI.configchk[k] then
				RT.UI.configchk[k].t:SetText(v)
				RT.UI.configchk[k].u:SetText(v)
			end
		end
		
		RT.LOCAL["UNK_ARTI_TYPE"] = "UNK_ARTI_TYPE"
		
		local nTracked = {}
		
		for k,v in pairs(ResourceTracker_Settings.tracked) do
			if ResourceTracker_Settings.txn[RT.SYSLANG][k] == nil then
				if RT.LOCAL[k] then
					nTracked[RT.LOCAL[k]] = true
				end
			else
				nTracked[k] = true
			end
		end
		
		ResourceTracker_Settings.tracked = nTracked
		
		if MINIMAPDOCKER then
			MINIMAPDOCKER.Register(addon.identifier, RT.UI.mm)
			RT.UI.mm:SetTexture(addon.identifier, "img/mm_button.png")
		else
			RT.UI.mm:SetPoint("TOPLEFT", UIParent, "TOPLEFT", ResourceTracker_Settings.mmx, ResourceTracker_Settings.mmy)
			if ResourceTracker_Settings.locked then
				RT.UI.mm:SetTexture(addon.identifier, "img/mm_button.png")
			else
				RT.UI.mm:SetTexture(addon.identifier, "img/mm_button_bw.png")
			end
		end

		RT.ResizeElements()

		if ResourceTracker_Settings.trx == -1 then
			RT.UI.trackers[1].f:SetPoint("TOPLEFT", UIParent, "CENTER", 0,-100)
			ResourceTracker_Settings.trx = RT.UI.trackers[1].f:GetLeft()
			ResourceTracker_Settings.try = RT.UI.trackers[1].f:GetTop()
		else
			RT.UI.trackers[1].f:SetPoint("TOPLEFT", UIParent, "TOPLEFT", ResourceTracker_Settings.trx, ResourceTracker_Settings.try)
		end

		for k,v in pairs(ResourceTracker_Settings.tracked) do
			if RT.UI.configchk[k] then
				RT.UI.configchk[k].c:SetChecked(true)
			end
		end
		RT.UI.cfgwindow.config:SetPoint("TOPLEFT", UIParent, "TOPLEFT", ResourceTracker_Settings.cfgx, ResourceTracker_Settings.cfgy)
		local nn = ResourceTracker_Settings.num_nodes
		RT.UI.s_nodes:SetPosition(2)
		RT.UI.s_nodes:SetPosition(nn)
		nn = ResourceTracker_Settings.num_gnodes
		RT.UI.s_numghost:SetPosition(2)
		RT.UI.s_numghost:SetPosition(nn)
		local ft = ResourceTracker_Settings.fade_time
		RT.UI.s_duration:SetPosition(2)
		RT.UI.s_duration:SetPosition(ft)
		RT.UI.c_combat:SetChecked(ResourceTracker_Settings.showcombat)
		RT.UI.c_dispmode:SetChecked(ResourceTracker_Settings.dispmode == DM_STACKED)
		RT.UI.c_relative:SetChecked(ResourceTracker_Settings.relative)
		RT.UI.c_distmode:SetChecked(ResourceTracker_Settings.use3Dmode)
		RT.UI.c_elevmode:SetChecked(ResourceTracker_Settings.showelevation)
		RT.UI.c_articolor:SetChecked(ResourceTracker_Settings.articolor)
		RT.UI.c_ghostmode:SetChecked(ResourceTracker_Settings.ghostmode)
		
		RT.UI.c_KCNor:SetChecked(ResourceTracker_Settings.hidecommon)
		RT.SCANMAP = true
		for k, v in pairs(ResourceTracker_Settings.ghostinclude) do
			for kd, vd in pairs(v) do
				RT.UI.cbRarityLevels[k][kd].cb:SetTexture(addon.identifier, RT.CHECKBOX[vd])
				if vd == RT_INCLUDE then
					local gf = RT.GHOSTFILTER
					RT.GHOSTFILTER = bit.bor(RT.GHOSTFILTER, RT.UI.cbRarityLevels[k][kd].bit)
				elseif vd == RT_EXCLUDE then
					local gf = RT.GHOSTEXCLUDE
					RT.GHOSTEXCLUDE = bit.bor(RT.GHOSTEXCLUDE, RT.UI.cbRarityLevels[k][kd].bit)
				end
			end
		end
		
		RT.SVLOADED = true
		Command.Event.Attach(Event.Map.Add, RT.Event_Map_Add, "Event.Map.Add")
		Command.Event.Attach(Event.Map.Remove, RT.Event_Map_Remove, "Event.Map.Remove")
		Command.Event.Attach(Event.System.Update.Begin, RT.Event_System_Update_Begin, "Event.System.Update.Begin")

		LibVersionCheck.register(addon.toc.Identifier, addon.toc.Version)
	end
end

function RT.ResizeElements()
	RT.UI.FRAMESIZE:SetFontSize(ResourceTracker_Settings.fontsize)
	RT.UI.fht = RT.UI.FRAMESIZE:GetHeight()

	for x=1, RT.MAX_TRACK do
		RT.UI.trackers[x].i:SetWidth(RT.UI.fht)
		RT.UI.trackers[x].i:SetHeight(RT.UI.fht)
		RT.UI.trackers[x].dx:SetWidth(RT.UI.fht)
		RT.UI.trackers[x].dx:SetHeight(RT.UI.fht)
		RT.UI.trackers[x].e:SetFontSize(math_floor(RT.UI.fht*0.4))
		
		if ResourceTracker_Settings.dispmode == DM_CLASSIC then
			RT.UI.trackers[x].f:SetWidth(RT.UI.fht * 16)
			RT.UI.trackers[x].f:SetHeight(RT.UI.fht)
			
			RT.UI.trackers[x].i:SetPoint("TOPLEFT", RT.UI.trackers[x].dx, "TOPRIGHT", 0,0)
			RT.UI.trackers[x].d:ClearPoint("TOPCENTER")
			RT.UI.trackers[x].d:SetPoint("TOPLEFT", RT.UI.trackers[x].i, "TOPRIGHT", 0,0)
		
			RT.UI.trackers[x].d:SetFontSize(ResourceTracker_Settings.fontsize)
			RT.UI.trackers[x].d:SetWidth(RT.UI.fht *14)

			if x > 1 then
				RT.UI.trackers[x].f:SetPoint("TOPLEFT", RT.UI.trackers[x-1].f, "BOTTOMLEFT", 0,0)
			else
				RT.UI.anchor:SetPoint("BOTTOMLEFT", RT.UI.trackers[1].f, "TOPLEFT", 0, 0)
				RT.UI.anchor:SetWidth(RT.UI.fht * 16)
			end
		else
			RT.UI.trackers[x].d:SetFontSize(math_floor(RT.UI.fht*0.5))
			RT.UI.trackers[x].d:ClearWidth()
			
			RT.UI.trackers[x].f:SetWidth(2+RT.UI.fht)
			RT.UI.trackers[x].f:SetHeight(2+(3*RT.UI.fht))
			
			RT.UI.trackers[x].d:ClearPoint("TOPLEFT")
			RT.UI.trackers[x].i:SetPoint("TOPLEFT", RT.UI.trackers[x].dx, "BOTTOMLEFT", 0,0)
			RT.UI.trackers[x].d:SetPoint("TOPCENTER", RT.UI.trackers[x].i, "BOTTOMCENTER", 0,0)
			if x > 1 then
				if x==9 then
					RT.UI.trackers[x].f:SetPoint("TOPLEFT", RT.UI.trackers[1].f, "BOTTOMLEFT", 0,2)
				elseif x==17 then
					RT.UI.trackers[x].f:SetPoint("TOPLEFT", RT.UI.trackers[9].f, "BOTTOMLEFT", 0,2)
				else
					RT.UI.trackers[x].f:SetPoint("TOPLEFT", RT.UI.trackers[x-1].f, "TOPRIGHT", 2,0)
				end
			else
				RT.UI.anchor:SetPoint("BOTTOMLEFT", RT.UI.trackers[1].f, "TOPLEFT", 0, 0)
				RT.UI.anchor:SetWidth(RT.UI.fht * 8)
			end
		end
	end

	RT.UI.cs_d:SetWidth(RT.UI.fht)
	RT.UI.cs_d:SetHeight(RT.UI.fht)
	RT.UI.cs_i:SetWidth(RT.UI.fht)
	RT.UI.cs_i:SetHeight(RT.UI.fht)
	RT.UI.cs_t:SetFontSize(ResourceTracker_Settings.fontsize)
	RT.UI.cfgwindow.configscale_ctr:SetHeight(RT.UI.fht)
	RT.UI.cfgwindow.configscale_ctr:SetWidth(RT.UI.fht*10)
end

function RT.Event_System_Secure_Enter(h)
	if ResourceTracker_Settings.showcombat == false then
		RT.RT_ACTIVE = false
		for k,v in pairs(RT.MESSAGE_STACK) do
			RT.MESSAGE_STACK[k].t = 0
		end
	end
end

function RT.Event_System_Secure_Leave(h)
	if ResourceTracker_Settings.showcombat == false then
		RT.RT_ACTIVE = true
		RT.ScanCurrentMap()
	end
end

function RT.Event_Buff_Add(h,u,t)
	if u == playerID then
		for k,v in pairs(Inspect.Buff.Detail(u,t)) do
			if RT.TRACK_ABILITIES[v.abilityNew] then
				RT.ACTIVE_ABILITIES[RT.TRACK_ABILITIES[v.abilityNew]].buff = true
				RT.ACTIVE_BUFFS[k] = RT.TRACK_ABILITIES[v.abilityNew]
				RT.TRACKLISTCHANGE = true
			end
			if RT.TRACK_ARTIFACTS[v.abilityNew] then
				debug("Gained Track Artifacts: "..v.abilityNew)
				RT.activeTrack.active = true
				RT.activeTrack[v.abilityNew] = "v.abilityNew"
				RT.activeTrack[k] = "k"
			end
		end
	end
end

function RT.Event_Buff_Remove(h,u,t)
	if u == playerID then
		for k,v in pairs(t) do
			if RT.ACTIVE_BUFFS[k] then
				RT.ACTIVE_ABILITIES[RT.ACTIVE_BUFFS[k]].buff = false
				RT.ACTIVE_BUFFS[k] = nil
				RT.TRACKLISTCHANGE = true
			end
			if RT.activeTrack[k] then
				debug("Lost buff: "..k.." ("..RT.activeTrack[k]..")")
				RT.activeTrack.active = false
			end
		end
	end
end

function RT.CleanupNodes(cx, cy, cz)
	local ax = 5*math_floor(cx/5)
	local ay = 5*math_floor(cy/5)
	local az = 5*math_floor(cz/5)
	local nRar = 0
	
	for x=-1, 1 do
		for y=-1, 1 do
			for z=-1, 1 do
				local ak = string_format("%d.%d.%d", ax+(x*5), az+(z*5), ay+(y*5))
				if ResourceTracker_Nodes.Rarity[LIBZONECHANGE.currentZoneID][ak] then
					if ResourceTracker_Nodes.Rarity[LIBZONECHANGE.currentZoneID][ak].t == DISC_GATHER then
						debug("Removing node: "..ak)
						nRar = math_max(nRar, ResourceTracker_Nodes.Rarity[LIBZONECHANGE.currentZoneID][ak].r)
						ResourceTracker_Nodes.Rarity[LIBZONECHANGE.currentZoneID][ak] = nil
					end
				end
			end
		end
	end

	if nRar > 0 then
		local ak = string_format("%d.%d.%d", ax, az, ay)
		debug("Setting node rarity: "..nRar)
		ResourceTracker_Nodes.Rarity[LIBZONECHANGE.currentZoneID][ak].r = nRar
	end
	
end

function RT.cb_libinvSlot(t)
	if Inspect.Time.Real() - RT.COLLECTTIME < 4 then
		for si, d in pairs(t) do
			if d and d ~= "nil" and d.category and RT.artifact_category[d.category] then
			debug("invchange arti: '"..d.name.."' : "..d.category)
				local pd = Inspect.Unit.Detail("player")
				local ax = 5*math_floor(pd.coordX/5)
				local ay = 5*math_floor(pd.coordY/5)
				local az = 5*math_floor(pd.coordZ/5)
				local ak = string_format("%d.%d.%d", ax, az, ay)
				if ResourceTracker_Nodes.Rarity[LIBZONECHANGE.currentZoneID][ak] == nil then
					local bFound = false
					for x=-1, 1 do
						for y=-1, 1 do
							for z=-1, 1 do
								local ak = string_format("%d.%d.%d", ax+(x*5), az+(z*5), ay+(y*5))
								if ResourceTracker_Nodes.Rarity[LIBZONECHANGE.currentZoneID][ak] then
									if ResourceTracker_Nodes.Rarity[LIBZONECHANGE.currentZoneID][ak].t == DISC_TRACK then
										bFound = true
									end
								end
							end
						end
					end
					if bFound == false then
						ResourceTracker_Nodes.Rarity[LIBZONECHANGE.currentZoneID][ak] = {t=DISC_GATHER, r=0, flags=0}
						debug("Adding new node. DISC_GATHER: "..ak)
						RT.tVisited[ak] = RT.timenow
					else
						debug("Not adding node, DISC_TRACK node found within 1")
					end
				end
				local rr = d.rarity or "common"
				local nrt = RT.rarity[rr].rk
				
				local flag = 0
				if RT.FLAGS_R[d.category] then
					flag = bit.bor(RT.FLAGS_R[d.category].default, RT.FLAGS_R[d.category][rr])
				else
					print("Unexpected artifact category from gathering: "..d.category..". Please report on rifui/curse page.")
				end
				
				for x=-1, 1 do
					for y=-1, 1 do
						for z=-1, 1 do
							local ak = string_format("%d.%d.%d", ax+(x*5), az+(z*5), ay+(y*5))
							if ResourceTracker_Nodes.Rarity[LIBZONECHANGE.currentZoneID][ak] then
								local cFlag = ResourceTracker_Nodes.Rarity[LIBZONECHANGE.currentZoneID][ak].flags
								local nFlag = bit.bor(cFlag, flag)
								debug(string.format("FLAGS: [%s] %s -> %s [%d]", ak, cFlag, nFlag, ResourceTracker_Nodes.Rarity[LIBZONECHANGE.currentZoneID][ak].t))
								ResourceTracker_Nodes.Rarity[LIBZONECHANGE.currentZoneID][ak].flags = nFlag
								if ResourceTracker_Nodes.Rarity[LIBZONECHANGE.currentZoneID][ak].r < nrt then
									ResourceTracker_Nodes.Rarity[LIBZONECHANGE.currentZoneID][ak].r = nrt
									if Library.LibMapNotes then
										Library.LibMapNotes.AddNodeToSet("RT: Rarity",{x=ax+(x*5), z=az+(z*5), itex="img/art"..nrt..".png", isrc=addon.identifier, isiz=13})
									end
								end
							end
						end
					end
				end
			end
		end
	end
end

function RT.Event_Unit_Availability_Full(h,t)
	for k,v in pairs(t) do
		if v == "player" then
			Command.Event.Detach(Event.Unit.Availability.Full, nil, nil, nil, addon.identifier)
			local adtl = Inspect.Ability.New.Detail(Inspect.Ability.New.List())
			for k,v in pairs(RT.TRACK_ABILITIES) do
				if adtl[k] then
					RT.ACTIVE_ABILITIES[v].active = true
				end
			end
			for k,v in pairs(Inspect.Buff.Detail("player", Inspect.Buff.List("player"))) do
				if RT.TRACK_ABILITIES[v.abilityNew] then
					RT.ACTIVE_ABILITIES[RT.TRACK_ABILITIES[v.abilityNew]].buff = true
				end
			end
			RT.CheckAbilities()
			Command.Event.Attach(Event.Buff.Add, RT.Event_Buff_Add, "Event.Buff.Add")
			Command.Event.Attach(Event.Buff.Remove, RT.Event_Buff_Remove, "Event.Buff.Remove")
			Library.LibInventory.RegisterSlot(Library.LibInventory.REFSLOTS["inventory"], RT.cb_libinvSlot)
		end
	end
end

function RT.Command_Slash_Register(h,args)
	local r = {}
	for token in string_gmatch(args, "[^%s]+") do
		table_insert(r, token)
	end
	if r[1] == "reset" then
		if MINIMAPDOCKER then
			print("Not resetting button position. Location managed by Docker.")
		else
			ResourceTracker_Settings.mmx = 100
			ResourceTracker_Settings.mmy = 100
			print("Resetting location of control button to 100,100")
			RT.UI.mm:SetPoint("TOPLEFT", UIParent, "TOPLEFT", ResourceTracker_Settings.mmx, ResourceTracker_Settings.mmy)
		end
		print("Resetting location of tracker listing to 200,100")
		ResourceTracker_Settings.trx = 200
		ResourceTracker_Settings.try = 100
		RT.UI.trackers[1].f:SetPoint("TOPLEFT", UIParent, "TOPLEFT", ResourceTracker_Settings.trx, ResourceTracker_Settings.try)
		print("Resetting location of config screen to 300,300")
		ResourceTracker_Settings.cfgx = 300
		ResourceTracker_Settings.cfgy = 300
		RT.UI.cfgwindow.config:SetPoint("TOPLEFT", UIParent, "TOPLEFT", ResourceTracker_Settings.cfgx, ResourceTracker_Settings.cfgy)
	elseif r[1] == "config" then
		ResourceTracker_Settings.locked = true
		RT.UI.cfgwindow.config:SetVisible(not RT.UI.cfgwindow.config:GetVisible())
		RT.UI.anchor:SetVisible(RT.UI.cfgwindow.config:GetVisible())
	elseif r[1] == "saved" then
		ResourceTracker_Settings = {}
		ResourceTracker_Nodes = {}
		MergeTable(ResourceTracker_Settings, default_settings)
		MergeTable(ResourceTracker_Nodes, default_settings_node)
		ResourceTracker_Nodes.Rarity[LIBZONECHANGE.currentZoneId] = {}
		print("Reset all saved values to defaults")
	elseif r[1] == "nearby" then
		for k,v in pairs(RT.tNodes) do
			local b = 0
			local s = nil
			local f = ResourceTracker_Nodes.Rarity[LIBZONECHANGE.currentZoneID][v.ak].flags
			print(string.format("[%s] : %10d (%s)", v.ak, f, RT.FlagDetail(f)))
		end
	end
end

function RT.Event_libZoneChange_Player(h, zn, zid)
	RT.SEND_MAPNOTE = true
	if ResourceTracker_Nodes.Rarity[zid] == nil then
		ResourceTracker_Nodes.Rarity[zid] = {}
	end
	RT.tVisited = {}
	RT.tNearby = {}
	RT.tNodes = {}
	
	if ResourceTracker_Nodes.Rarity[zid] then
		for k,v in pairs(ResourceTracker_Nodes.Rarity[zid]) do
			if v.flags == nil then
				v.flags = 0
			end
		end
	end
	
	RT.ScanCurrentMap()
end

function RT.SendDataLMN()

	if Library.LibMapNotes then

		LMNDATA = {
			[IDX_WOOD] = {},
			[IDX_ORE] = {},
			[IDX_PLANTS] = {},
			[IDX_FISH] = {},
			["Artifacts"] = {}
		}

		local math_floor = math_floor

		for rk, rt in pairs(LMNDATA) do
			WATCHDOGWAIT("SendDataLMN:1:"..rk)
			local checklist = {}
			
			if rk == "Artifacts" then
				checklist[1] = "Artifacts"
			else			
				for k,v in pairs(RT.ITEMS[RT.ACTIVE_ABILITIES[rk].akey]) do
					if ResourceTracker_Settings.tracked[v.name[RT.SYSLANG]] then
						checklist[v.k] = v.name[RT.SYSLANG]
					end
				end
			end
			
			if ResourceTracker_Nodes[rk][LIBZONECHANGE.currentZoneID] then
				WATCHDOGWAIT("SendDataLMN:2:"..rk)
				for k,v in pairs(ResourceTracker_Nodes[rk][LIBZONECHANGE.currentZoneID]) do
					for nk,nv in pairs(v.nodes) do
						if checklist[nk] then
							local nt = checklist[nk]
							if LMNDATA[rk][nt] == nil then
								LMNDATA[rk][nt] = {}
							end
							table_insert(LMNDATA[rk][nt], {x=math_floor(v.x), z=math_floor(v.z), isiz=13, isrc="Rift", itex=RT.LOOKUP[nt].icon})
						end
					end
				end
			end
		end

		for rk,rv in pairs(LMNDATA) do
			for nk, nv in pairs(rv) do
				if #nv > 0 then
					WATCHDOGWAIT("SendDataLMN:3")
					Library.LibMapNotes.AddNodes("RT: "..nk,LMNDATA[rk][nk])
				end
			end
		end
		
		if ResourceTracker_Nodes.Rarity[LIBZONECHANGE.currentZoneID] then
			local tRarity = {}
			
			for k,v in pairs(ResourceTracker_Nodes.Rarity[LIBZONECHANGE.currentZoneID]) do
				if v.r > 0 then
					local rx = {
						x=0,
						z=0,
						itex="img/art"..(v.r)..".png",
						isrc=addon.identifier,
						isiz=13
					}
					local cx = {}
					for tkn in string_gmatch(k, "[^.]+") do
						table_insert(cx, tkn)
					end
					rx.x = cx[1]
					rx.z = cx[2]
					table_insert(tRarity, rx)
				end
			end
			if #tRarity > 0 then
				Library.LibMapNotes.AddNodes("RT: Rarity", tRarity)
			end
		end
	end
end

function RT.Event_Unit_Castbar(h,t)
	if t[playerID] then
		local cb = Inspect.Unit.Castbar(playerID)
		--if cb and cb.abilityName == "Collecting" then
		if cb and cb.abilityNew == "A0000002B72E024A4" then
			RT.COLLECTTIME = Inspect.Time.Real()
		end
	end
end

RT.BuildUI()

Command.Event.Attach(Event.Addon.SavedVariables.Load.End, RT.Event_Addon_SavedVariables_Load_End, "Event.Addon.SavedVariables.Load.End")
Command.Event.Attach(Event.System.Secure.Leave, RT.Event_System_Secure_Leave, "Event.System.Secure.Leave")
Command.Event.Attach(Event.System.Secure.Enter, RT.Event_System_Secure_Enter, "Event.System.Secure.Enter")
Command.Event.Attach(Event.Unit.Availability.Full, RT.Event_Unit_Availability_Full, "Event.Unit.Availability.Full")
Command.Event.Attach(Command.Slash.Register("resourcetracker"), RT.Command_Slash_Register, "Command.Slash.Register")
Command.Event.Attach(Event.Unit.Castbar, RT.Event_Unit_Castbar, "Event.Unit.Castbar")
Command.Event.Attach(Library.libZoneChange.Player, RT.Event_libZoneChange_Player, "Library.LibZoneChange.Player")
print(string_format("v%s loaded.", addon.toc.Version))
print("Use '/resourcetracker saved' if you are having errors.")