local addon, RT = ...

local MOB_LANG_KEY

local syslang = string.upper(Inspect.System.Language())

if syslang == "FRENCH" then
	MOB_LANG_KEY = "FR"
elseif syslang == "GERMAN" then
	MOB_LANG_KEY = "DE"
elseif syslang == "RUSSIAN" then
	MOB_LANG_KEY = "RU"
else
	MOB_LANG_KEY = "EN"
end

local math_sqrt = math.sqrt
local math_atan = math.atan2
local math_pi = math.pi
local string_format = string.format
local math_max = math.max
local math_min = math.min

RT.UI = {}
RT.OFFSET = 0

local maxrare = 0
local longestname = ""
local h16 = 0
local h14 = 0
local curIconHt = 0
local numActive = 0
local lastupdate = 0
local GPSDATA = {}
local ACTIVEGPS = {}
local MACROUPDT = {r=false}
local GPSVISIBLE = true
local visited = {}
local HIDEALWAYS = false

local GPS_MODE_ALL = 1
local GPS_MODE_AVAIL=2

local AUTOHIDETIME = false

local default_settings = {
	fonts = { label = 16, dist = 12 }, gpsx = 600, gpsy = 200, mmx=700, mmy=200, dckx=500, dcky=500,
	gpsmode = GPS_MODE_ALL, hidden = {}, iconsz = 64, background=true, glow=false, usegps = true,
	mmlocked=true, mclocked=true, autohide = false, hidetime = 10
}

local function MergeTable(o,n)
	for k,v in pairs(n) do
		if type(v) == "table" then
			if o[k] == nil then
				o[k] = {}
			end
	 	 	if type(o[k]) == 'table' then
	 			MergeTable(o[k], n[k])
	 	 	end
		else
			if o[k] == nil then
				o[k] = v
			end
		end
	end
end

function RT.BuildUI()
	RT.context = UI.CreateContext(addon.identifier)
	RT.gpscontext = UI.CreateContext(addon.identifier)
	RT.seccontext = UI.CreateContext(addon.identifier.."SEC")
	RT.seccontext:SetSecureMode("restricted")

	RT.UI.mm_button = UI.CreateFrame("Texture", "RT.UI.mm_button", RT.context)
	RT.UI.mm_button:SetWidth(36)
	RT.UI.mm_button:SetHeight(36)
	RT.UI.mm_button:SetTexture(addon.identifier, "img/diamond-green-round.png")

	if MINIMAPDOCKER == nil then
	-- LEFT DOWN
	-- LEFT UP
	-- CURSOR MOVE == movement
	-- RIGHT CLICK = Lock
		RT.UI.mm_button:EventAttach(Event.UI.Input.Mouse.Left.Down, function(self, h)
			if RareTracker_Settings.mmlocked == false then
				local mouseData = Inspect.Mouse()
				self.sx = mouseData.x - RT.UI.mm_button:GetLeft()
				self.sy = mouseData.y - RT.UI.mm_button:GetTop()
				self.MouseDown = true
			end
		end, "Event.UI.Input.Mouse.Left.Down")

		RT.UI.mm_button:EventAttach(Event.UI.Input.Mouse.Left.Up, function(self, h)
			if RareTracker_Settings.mmlocked == false then
				local mouseData = Inspect.Mouse()
				RareTracker_Settings.dckx = RT.UI.mm_button:GetLeft()
				RareTracker_Settings.dcky = RT.UI.mm_button:GetTop()
			end
			self.MouseDown = false
		end, "Event.UI.Input.Mouse.Left.Up")

		RT.UI.mm_button:EventAttach(Event.UI.Input.Mouse.Cursor.Move, function(self, h)
			if RareTracker_Settings.mmlocked == false and self.MouseDown then
				local nx, ny
				local mouseData = Inspect.Mouse()
				nx = mouseData.x - self.sx
				ny = mouseData.y - self.sy
				RT.UI.mm_button:SetPoint("TOPLEFT", UIParent, "TOPLEFT", nx,ny)
			end
		end, "Event.UI.Input.Mouse.Cursor.Move")

		RT.UI.mm_button:EventAttach(Event.UI.Input.Mouse.Right.Click, function(self, h)
			self.MouseDown = false
			RareTracker_Settings.mmlocked = not RareTracker_Settings.mmlocked
			if RareTracker_Settings.mmlocked == false then
				RT.UI.mm_button:SetTexture(addon.identifier, "img/diamond-bw-round.png")
			else
				if RareTracker_Settings.usegps then
					RT.UI.mm_button:SetTexture(addon.identifier, "img/diamond-green-round.png")
				else
					RT.UI.mm_button:SetTexture(addon.identifier, "img/diamond-red-round.png")
				end
			end
		end, "Event.UI.Input.Mouse.Right.Click")
	end

	-- LEFT CLICK = Toggle GPS

	RT.UI.mm_button:EventAttach(Event.UI.Input.Mouse.Left.Click, function(self, h)
		if RareTracker_Settings.mmlocked or MINIMAPDOCKER then
			RareTracker_Settings.usegps = not RareTracker_Settings.usegps
			if RareTracker_Settings.usegps then
				RT.UI.mm_button:SetTexture(addon.identifier, "img/diamond-green-round.png")
			else
				RT.UI.mm_button:SetTexture(addon.identifier, "img/diamond-red-round.png")
			end
			RT.gpscontext:SetVisible(RareTracker_Settings.usegps)
		end
		--RT.Event_libZoneChange_Player(0, LIBZONECHANGE.currentZoneName, LIBZONECHANGE.currentZoneID)
	end, "Event.UI.Input.Mouse.Left.Click")

	RT.UI.button = UI.CreateFrame("Texture", "RT.UI.button", RT.seccontext)
	RT.UI.button:SetTexture(addon.identifier, "img/diamond-red.png")
	RT.UI.button:SetSecureMode("restricted")
	RT.UI.button:SetLayer(1)

	RT.UI.button:EventAttach(Event.UI.Input.Mouse.Right.Click, function(self, h)
		if Inspect.System.Secure() == false then
			RareTracker_Settings.mclocked = not RareTracker_Settings.mclocked
			RT.Event_libZoneChange_Player(0, LIBZONECHANGE.currentZoneName, LIBZONECHANGE.currentZoneID)
		else
			print("Cannot make button changes whilst in combat. Try again later.")
		end
	end, "Event.UI.Input.Mouse.Right.Click")

	RT.UI.button:EventAttach(Event.UI.Input.Mouse.Left.Click, function(self, h)
		if RareTracker_Settings.autohide then
			AUTOHIDETIME = Inspect.Time.Real() + RareTracker_Settings.hidetime
			GPSVISIBLE = true
			RT.UI.gps:SetVisible(GPSVISIBLE)
		end
	end, "Event.UI.Input.Mouse.Left.Click")
	
	RT.UI.button:EventAttach(Event.UI.Input.Mouse.Left.Down, function(self, h)
		if Inspect.System.Secure() == false and RareTracker_Settings.mclocked == false then
			local mouseData = Inspect.Mouse()
			self.sx = mouseData.x - RT.UI.button:GetLeft()
			self.sy = mouseData.y - RT.UI.button:GetTop()
			self.MouseDown = true
		end
	end, "Event.UI.Input.Mouse.Left.Down")

	RT.UI.button:EventAttach(Event.UI.Input.Mouse.Left.Up, function(self, h)
		if RareTracker_Settings.mclocked == false then
			RareTracker_Settings.mmx = RT.UI.button:GetLeft()
			RareTracker_Settings.mmy = RT.UI.button:GetTop()
			self.MouseDown = false
		end
	end, "Event.UI.Input.Mouse.Right.Up")

	RT.UI.button:EventAttach(Event.UI.Input.Mouse.Cursor.Move, function(self, h)
		if Inspect.System.Secure() == false then
			if self.MouseDown and RareTracker_Settings.mclocked == false then
				local nx, ny
				local mouseData = Inspect.Mouse()
				nx = mouseData.x - self.sx
				ny = mouseData.y - self.sy
				RT.UI.button:SetPoint("TOPLEFT", UIParent, "TOPLEFT", nx,ny)
			else
				self.MouseDown = false
			end
		end
	end, "Event.UI.Input.Mouse.Cursor.Move")

	RT.UI.button:EventAttach(Event.UI.Input.Mouse.Wheel.Forward, function(self, h)
		if Inspect.System.Secure() == false then
			if RareTracker_Settings.iconsz < 128 then
				RareTracker_Settings.iconsz = RareTracker_Settings.iconsz+1
				RT.UI.button:SetHeight(RareTracker_Settings.iconsz)
				RT.UI.button:SetWidth(RareTracker_Settings.iconsz)
			end
		end
	end, "Event.UI.Input.Mouse.Wheel.Forward")

	RT.UI.button:EventAttach(Event.UI.Input.Mouse.Wheel.Back, function(self, h)
		if Inspect.System.Secure() == false then
			if RareTracker_Settings.iconsz > 8 then
				RareTracker_Settings.iconsz = RareTracker_Settings.iconsz-1
				RT.UI.button:SetHeight(RareTracker_Settings.iconsz)
				RT.UI.button:SetWidth(RareTracker_Settings.iconsz)
			end
		end
	end, "Event.UI.Input.Mouse.Wheel.Back")

	RT.UI.btnlab = UI.CreateFrame("Text", "RT.UI.btnlab", RT.seccontext)
	RT.UI.btnlab:SetFontSize(12)
	RT.UI.btnlab:SetVisible(true)
	RT.UI.btnlab:SetFontColor(1,1,1)
	RT.UI.btnlab:SetLayer(10)
	RT.UI.btnlab:SetText("0")
	RT.UI.btnlab:SetEffectGlow({strength=10, blurX=3, blurY=3})
	RT.UI.btnlab:SetPoint("BOTTOMRIGHT", RT.UI.button, "BOTTOMRIGHT", -2,-2)

	RT.UI.lblsize = UI.CreateFrame("Text", "RT.UI.lblsize", RT.context)
	RT.UI.lblsize:SetVisible(false)

	RT.UI.gps = UI.CreateFrame("Frame", "RT.UI.gps", RT.gpscontext)
	RT.UI.gps:SetLayer(1)
	RT.UI.gps:SetBackgroundColor(0.25, 0.25, 0.25, 0.5)

	RT.UI.gps_header = UI.CreateFrame("Text", "RT.UI.gps_header", RT.UI.gps)
	RT.UI.gps_header:SetLayer(2)
	RT.UI.gps_header:SetFontSize(16)
	RT.UI.gps_header:SetBackgroundColor(0,0.6,0)
	RT.UI.gps_header:SetText("RareTracker")
	h16 = RT.UI.gps_header:GetHeight()
	RT.UI.gps_header:SetPoint("TOPLEFT", RT.UI.gps, "TOPLEFT", 2,2)

	RT.UI.gps_header:EventAttach(Event.UI.Input.Mouse.Left.Down, function(self, h)
		self.MouseDown = true
		local mouseData = Inspect.Mouse()
		self.sx = mouseData.x - RT.UI.gps:GetLeft()
		self.sy = mouseData.y - RT.UI.gps:GetTop()
	end, "Event.UI.Input.Mouse.Left.Down")

	RT.UI.gps_header:EventAttach(Event.UI.Input.Mouse.Left.Up, function(self, h)
		self.MouseDown = false
		RareTracker_Settings.gpsx = RT.UI.gps:GetLeft()
		RareTracker_Settings.gpsy = RT.UI.gps:GetTop()
	end, "Event.UI.Input.Mouse.Left.Up")

	RT.UI.gps_header:EventAttach(Event.UI.Input.Mouse.Cursor.Move, function(self, h)
		if self.MouseDown then
			local nx, ny
			local mouseData = Inspect.Mouse()
			nx = mouseData.x - self.sx
			ny = mouseData.y - self.sy
			RT.UI.gps:SetPoint("TOPLEFT", UIParent, "TOPLEFT", nx,ny)
		end
	end, "Event.UI.Input.Mouse.Cursor.Move")
	
	RT.UI.gps_bConfig = UI.CreateFrame("Texture", "RT.UI.gps_bConfig", RT.UI.gps)
	RT.UI.gps_bConfig:SetLayer(3)
	RT.UI.gps_bConfig:SetPoint("TOPRIGHT", RT.UI.gps_header, "TOPRIGHT")
	RT.UI.gps_bConfig:SetHeight(RT.UI.gps_header:GetHeight())
	RT.UI.gps_bConfig:SetWidth(RT.UI.gps_header:GetHeight())
	RT.UI.gps_bConfig:SetTexture(addon.identifier, "img/imgcog.png")
	RT.UI.gps_bConfig:EventAttach(Event.UI.Input.Mouse.Left.Click, function(self, h)
		UI.cfg.f.f:SetVisible(not UI.cfg.f.f:GetVisible())
		AUTOHIDETIME = false
		if UI.cfg.f.f:GetVisible() == false and RareTracker_Settings.autohide then
			AUTOHIDETIME = Inspect.Time.Real() + RareTracker_Settings.hidetime
		end
	end, "Event.UI.Input.Mouse.Left.Click")

	RT.UI.gps_mode = UI.CreateFrame("Text", "RT.UI.gps_mode", RT.UI.gps)
	RT.UI.gps_mode:SetLayer(3)
	RT.UI.gps_mode:SetFontSize(14)
	RT.UI.gps_mode:SetBackgroundColor(0,0.4,0)
	RT.UI.gps_mode:SetText("MODE: ")
	h14 = RT.UI.gps_mode:GetHeight()
	RT.UI.gps_mode:SetPoint("TOPLEFT", RT.UI.gps_header, "BOTTOMLEFT", 0,0)

	RT.UI.gps_mode:EventAttach(Event.UI.Input.Mouse.Left.Click, function(self, h)
		if RareTracker_Settings.gpsmode == GPS_MODE_AVAIL then
			RareTracker_Settings.gpsmode = GPS_MODE_ALL
			RT.UI.gps_mode:SetText("MODE: ALL")
		else
			RareTracker_Settings.gpsmode = GPS_MODE_AVAIL
			RT.UI.gps_mode:SetText("MODE: Available")
		end
		RT.Event_libZoneChange_Player(0, LIBZONECHANGE.currentZoneName, LIBZONECHANGE.currentZoneID)
	end, "Event.UI.Input.Mouse.Left.Click")

	RT.UI.gps_mode:EventAttach(Event.UI.Input.Mouse.Right.Click, function(self, h)
		RT.UI.gps_config:SetVisible(true)
		RT.UI.gps_config:SetLayer(50)
		RT.UI.gps_cfg_nam:SetLayer(55)
		RT.UI.gps_cfg_rng:SetLayer(55)
	end, "Event.UI.Input.Mouse.Right.Click")

	RT.UI.gps_config = UI.CreateFrame("Frame", "RT.UI.gps_config", RT.UI.gps)
	RT.UI.gps_config:SetVisible(false)
	RT.UI.gps_config:SetLayer(0)
	RT.UI.gps_config:SetBackgroundColor(0.6,0,0)
	RT.UI.gps_config:SetHeight(RT.UI.gps_mode:GetHeight())
	RT.UI.gps_config:SetPoint("TOPLEFT", RT.UI.gps_header, "BOTTOMLEFT", 0,0)

	RT.UI.gps_config:EventAttach(Event.UI.Input.Mouse.Right.Click, function(self, h)
		RT.UI.gps_config:SetVisible(false)
		RT.UI.gps_config:SetLayer(0)
		RT.UI.gps_cfg_nam:SetLayer(0)
		RT.UI.gps_cfg_rng:SetLayer(0)
	end, "Event.UI.Input.Mouse.Right.Click")

	RT.UI.gps_cfg_nam = UI.CreateFrame("Text", "RT.UI.gps_cfg_nam", RT.UI.gps_config)
	RT.UI.gps_cfg_nam:SetFontSize(14)
	RT.UI.gps_cfg_nam:SetPoint("TOPLEFT", RT.UI.gps_header, "BOTTOMLEFT", 0,0)
	RT.UI.gps_cfg_nam:SetText("NAME:")

	RT.UI.gps_cfg_nam:EventAttach(Event.UI.Input.Mouse.Wheel.Forward, function(self, h)
		if RareTracker_Settings.fonts.label < 24 then
			RareTracker_Settings.fonts.label = RareTracker_Settings.fonts.label+1
			RT.GPS_Scale()
		end
	end, "Event.UI.Input.Mouse.Wheel.Forward")

	RT.UI.gps_cfg_nam:EventAttach(Event.UI.Input.Mouse.Wheel.Back, function(self, h)
		if RareTracker_Settings.fonts.label > 12 then
			RareTracker_Settings.fonts.label = RareTracker_Settings.fonts.label-1
			RT.GPS_Scale()
		end
	end, "Event.UI.Input.Mouse.Wheel.Back")

	RT.UI.gps_cfg_nam:EventAttach(Event.UI.Input.Mouse.Right.Click, function(self, h)
		RT.UI.gps_config:SetVisible(false)
		RT.UI.gps_config:SetLayer(0)
		RT.UI.gps_cfg_nam:SetLayer(0)
		RT.UI.gps_cfg_rng:SetLayer(0)
	end, "Event.UI.Input.Mouse.Right.Click")

	RT.UI.gps_cfg_rng = UI.CreateFrame("Text", "RT.UI.gps_cfg_rng", RT.UI.gps_config)
	RT.UI.gps_cfg_rng:SetFontSize(14)
	RT.UI.gps_cfg_rng:SetPoint("TOPRIGHT", RT.UI.gps_header, "BOTTOMRIGHT", 0,0)
	RT.UI.gps_cfg_rng:SetText("RANGE:")

	RT.UI.gps_cfg_rng:EventAttach(Event.UI.Input.Mouse.Wheel.Forward, function(self, h)
		if RareTracker_Settings.fonts.dist < 24 then
			RareTracker_Settings.fonts.dist = RareTracker_Settings.fonts.dist+1
			RT.GPS_Scale()
		end
	end, "Event.UI.Input.Mouse.Wheel.Forward")

	RT.UI.gps_cfg_rng:EventAttach(Event.UI.Input.Mouse.Wheel.Back, function(self, h)
		if RareTracker_Settings.fonts.dist > 8 then
			RareTracker_Settings.fonts.dist = RareTracker_Settings.fonts.dist-1
			RT.GPS_Scale()
		end
	end, "Event.UI.Input.Mouse.Wheel.Back")

	RT.UI.gps_cfg_rng:EventAttach(Event.UI.Input.Mouse.Right.Click, function(self, h)
		RT.UI.gps_config:SetVisible(false)
		RT.UI.gps_config:SetLayer(0)
		RT.UI.gps_cfg_nam:SetLayer(0)
		RT.UI.gps_cfg_rng:SetLayer(0)
	end, "Event.UI.Input.Mouse.Right.Click")

	local maxw = 0

	for k,v in pairs(RT.moblocs) do
		local curmobs = 0
		for mi, mv in pairs(v.mobs) do
			curmobs = curmobs + #mv.loc
			RT.UI.lblsize:SetText(string_format("%s [#8]",mv.n[MOB_LANG_KEY]))
			local cw = RT.UI.lblsize:GetWidth()
			if cw > maxw then
				maxw = cw
				longestname = mv.n[MOB_LANG_KEY]
			end
		end
		maxrare = math_max(maxrare, curmobs)
	end
	RT.maxrare = maxrare
	UI.tracker = {}

	for x=1, maxrare do
		local c = UI.CreateFrame("Frame", "t.c", RT.UI.gps)
		c:SetLayer(4)
		local i = UI.CreateFrame("Texture", "t.i", c)
		i:SetLayer(5)
		i:SetPoint("TOPLEFT", c, "TOPLEFT", 0,0)
		i:SetTexture(addon.identifier, "img/compass-N.png")
		i:EventAttach(Event.UI.Input.Mouse.Left.Click, function(self, h)
			Command.Map.Waypoint.Set(GPSDATA[x].x, GPSDATA[x].z)
		end, "Event.UI.Input.Mouse.Left.Click")
		i:EventAttach(Event.UI.Input.Mouse.Right.Click, function(self, h)
			Command.Map.Waypoint.Clear()
		end, "Event.UI.Input.Mouse.Right.Click")
		c:EventAttach(Event.UI.Input.Mouse.Left.Click, function(self, h)
			if RareTracker_Settings.hidden[LIBZONECHANGE.currentZoneID] == nil then
				RareTracker_Settings.hidden[LIBZONECHANGE.currentZoneID] = {}
			end
			local n = GPSDATA[x].n
			if RareTracker_Settings.hidden[LIBZONECHANGE.currentZoneID][n] == nil then
				RareTracker_Settings.hidden[LIBZONECHANGE.currentZoneID][n] = true
			else
				RareTracker_Settings.hidden[LIBZONECHANGE.currentZoneID][n] = nil
			end
			RT.Event_libZoneChange_Player(0, LIBZONECHANGE.currentZoneName, LIBZONECHANGE.currentZoneID)
		end, "Event.UI.Input.Mouse.Left.Click")
		c:EventAttach(Event.UI.Input.Mouse.Right.Click, function(self, h)
			local n = GPSDATA[x].n..GPSDATA[x].t
			if visited[n] then
				visited[n] = nil
			else
				visited[n] = true
			end
			RT.Event_libZoneChange_Player(nil, LIBZONECHANGE.currentZoneName, LIBZONECHANGE.currentZoneID)
			lastupdate = 0
		end, "Event.UI.Input.Mouse.Right.Click")
		local n = UI.CreateFrame("Text", "t.n", c)
		n:SetLayer(3)
		n:SetPoint("TOPLEFT", i, "TOPRIGHT", 0,0)
		n:SetText("MONSTER NAME")
		local d = UI.CreateFrame("Text", "t.d", c)
		d:SetLayer(3)
		d:SetPoint("BOTTOMLEFT", i, "BOTTOMRIGHT", 0,0)
		d:SetText("1234m")
		if x==1 then
			c:SetPoint("TOPLEFT", RT.UI.gps_mode, "BOTTOMLEFT", 0,0)
		elseif x%16 ==1 then
			c:SetPoint("TOPLEFT", UI.tracker[x-16].c, "TOPRIGHT", 0,0)
		else
			c:SetPoint("TOPLEFT", UI.tracker[x-1].c, "BOTTOMLEFT", 0,0)
		end

		UI.tracker[x] = {c=c, i=i, n=n, d=d, ci=""}
	end
	
	UI.cfg = { f={}, b={} }
	
	UI.cfg.f.f = UI.CreateFrame("Frame", "UI.cfg.f.f", RT.UI.gps)
	UI.cfg.f.f:SetLayer(1)
	UI.cfg.f.f:SetBackgroundColor(0.25,0.25,0.25,0.5)
	UI.cfg.f.f:SetVisible(false)
	UI.cfg.f.f:SetPoint("TOPLEFT", RT.UI.gps, "TOPRIGHT", 5,0)
	
	UI.cfg.f.h = UI.CreateFrame("Text", "UI.cfg.f.h", UI.cfg.f.f)
	UI.cfg.f.h:SetLayer(2)
	UI.cfg.f.h:SetFontSize(16)
	UI.cfg.f.h:SetBackgroundColor(0,0.6,0)
	UI.cfg.f.h:SetText("RT Config")
	UI.cfg.f.h:SetPoint("TOPLEFT", UI.cfg.f.f, "TOPLEFT",2,2)

	UI.cfg.f.cb_hide = UI.CreateFrame("RiftCheckbox", "cb_hide", UI.cfg.f.f)
	UI.cfg.f.cb_hide:SetLayer(3)
	UI.cfg.f.cb_hide:SetWidth(24)
	UI.cfg.f.cb_hide:SetHeight(24)
	UI.cfg.f.cb_hide:SetPoint("TOPLEFT", UI.cfg.f.h, "BOTTOMLEFT", 0,0)

	UI.cfg.f.cb_hide:EventAttach(Event.UI.Checkbox.Change, function(self, h)
		RareTracker_Settings.autohide = UI.cfg.f.cb_hide:GetChecked()
		AUTOHIDETIME = false
	end, "Event.UI.Checkbox.Change")
	
	UI.cfg.f.t_hide = UI.CreateFrame("Text", "t_hide", UI.cfg.f.f)
	UI.cfg.f.t_hide:SetLayer(3)
	UI.cfg.f.t_hide:SetText("Autohide")	
	UI.cfg.f.t_hide:SetPoint("CENTERLEFT", UI.cfg.f.cb_hide, "CENTERRIGHT", 4,0)
	
	UI.cfg.f.l_time = UI.CreateFrame("Text", "l_time", UI.cfg.f.f)
	UI.cfg.f.l_time:SetLayer(3)
	UI.cfg.f.l_time:SetText("Time:")
	UI.cfg.f.l_time:SetPoint("TOPLEFT", UI.cfg.f.t_hide, "BOTTOMLEFT", 0,0)
	
	UI.cfg.f.s_time = UI.CreateFrame("RiftSlider", "s_time", UI.cfg.f.f)
	UI.cfg.f.s_time:SetLayer(3)
	UI.cfg.f.s_time:SetRange(1,10)
	UI.cfg.f.s_time:SetPoint("TOPLEFT", UI.cfg.f.l_time, "BOTTOMLEFT", 0, 0)
	
	UI.cfg.f.s_time:EventAttach(Event.UI.Slider.Change, function(self, h)
		RareTracker_Settings.hidetime = UI.cfg.f.s_time:GetPosition()
		UI.cfg.f.l_time:SetText("Time: "..RareTracker_Settings.hidetime)
	end, "Event.UI.Slider.Change")
	
	UI.cfg.f.s_time:EventAttach(Event.UI.Input.Mouse.Wheel.Forward, function(self, h)
		if RareTracker_Settings.hidetime < 10 then
			RareTracker_Settings.hidetime = RareTracker_Settings.hidetime+1
			UI.cfg.f.s_time:SetPosition(RareTracker_Settings.hidetime)
		end
	end, "Event.UI.Input.Mouse.Wheel.Forward")

	UI.cfg.f.s_time:EventAttach(Event.UI.Input.Mouse.Wheel.Back, function(self, h)
		if RareTracker_Settings.hidetime > 1 then
			RareTracker_Settings.hidetime = RareTracker_Settings.hidetime-1
			UI.cfg.f.s_time:SetPosition(RareTracker_Settings.hidetime)
		end
	end, "Event.UI.Input.Mouse.Wheel.Back")
	
	RT.OFFSET = 0
		
	for x=1,15 do
		local n = UI.CreateFrame("Text", "UI.cfg.b."..x, UI.cfg.f.f)
		n:SetLayer(5)
		n:SetText("LABEL: "..x)		
		if x==1 then
			n:SetPoint("TOPLEFT", UI.cfg.f.l_time, "BOTTOMLEFT",-24,10)
		else
			n:SetPoint("TOPLEFT", UI.cfg.b[x-1].n, "BOTTOMLEFT")
		end
		n:EventAttach(Event.UI.Input.Mouse.Left.Click, function(self, h)
			local sName = n:GetText()
			local zid = LIBZONECHANGE.currentZoneID
			if RareTracker_Settings.hidden[zid][sName] then
				RareTracker_Settings.hidden[zid][sName] = false
			else
				RareTracker_Settings.hidden[zid][sName] = true
			end
			RT.Event_libZoneChange_Player(0, LIBZONECHANGE.currentZoneName, LIBZONECHANGE.currentZoneID)
		end, "Event.UI.Input.Mouse.Left.Click")
		n:EventAttach(Event.UI.Input.Mouse.Wheel.Back, function(self, h)
			RT.OFFSET = RT.OFFSET+1
			RT.updateConfigList()
		end, "Event.UI.Input.Mouse.Wheel.Back")
		n:EventAttach(Event.UI.Input.Mouse.Wheel.Forward, function(self, h)
			if RT.OFFSET > 0 then
				RT.OFFSET = RT.OFFSET-1
				RT.updateConfigList()
			end
		end, "Event.UI.Input.Mouse.Wheel.Forward")
		UI.cfg.b[x] = {n=n}
	end	
	
	UI.cfg.f.sb_bg = UI.CreateFrame("Frame", "UI.cfg.f.sb_bg", UI.cfg.f.f)
	UI.cfg.f.sb_bg:SetWidth(4)
	UI.cfg.f.sb_bg:SetBackgroundColor(0,0,0)
	UI.cfg.f.sb_bg:SetPoint("TOPLEFT", UI.cfg.f.l_time, "BOTTOMLEFT",-28,10)
	UI.cfg.f.sb_bg:SetLayer(10)
	
	UI.cfg.f.sb = UI.CreateFrame("Frame", "UI.cfg.f.sb", UI.cfg.f.sb_bg)
	UI.cfg.f.sb:SetWidth(4)
	UI.cfg.f.sb:SetBackgroundColor(0.75,0.75,0.75)
	UI.cfg.f.sb:SetPoint("TOPLEFT", UI.cfg.f.l_time, "BOTTOMLEFT",-28,10)
	UI.cfg.f.sb:SetLayer(15)	
end

function RT.GPS_Scale()
	RT.UI.lblsize:SetFontSize(RareTracker_Settings.fonts.label)
	RT.UI.lblsize:SetText(longestname)
	local lbl_h = RT.UI.lblsize:GetHeight()
	local lbl_w = RT.UI.lblsize:GetWidth()
	RT.UI.lblsize:SetFontSize(RareTracker_Settings.fonts.dist)
	local dst_h = RT.UI.lblsize:GetHeight()
	curIconHt = lbl_h + dst_h

	for x=1, maxrare do
		UI.tracker[x].c:SetHeight(curIconHt)
		UI.tracker[x].c:SetWidth(curIconHt + lbl_w)
		UI.tracker[x].i:SetHeight(curIconHt)
		UI.tracker[x].i:SetWidth(curIconHt)
		UI.tracker[x].n:SetFontSize(RareTracker_Settings.fonts.label)
		UI.tracker[x].d:SetFontSize(RareTracker_Settings.fonts.dist)
	end
	
	for x=1, 15 do
		UI.cfg.b[x].n:SetFontSize(RareTracker_Settings.fonts.label)
		UI.cfg.b[x].n:SetWidth(lbl_w)
	end

	local cWidth = curIconHt + (math.ceil(numActive/16) * lbl_w)
		
	RT.UI.gps_header:SetWidth(cWidth)
	RT.UI.gps_mode:SetWidth(cWidth)
	RT.UI.gps_config:SetWidth(curIconHt + lbl_w)
	RT.UI.gps:SetWidth(cWidth + 4)
	RT.UI.gps:SetHeight(h16 + h14 + (math_min(16, numActive) * curIconHt) + 4)
	
	UI.cfg.f.f:SetWidth(lbl_w+8)
	UI.cfg.f.f:SetHeight(h16+ (15*lbl_h) + 4 + 52)
	UI.cfg.f.h:SetWidth(lbl_w + 4)
	
	UI.cfg.f.sb_bg:SetHeight(15 * lbl_h)
	
	UI.cfg.f.s_time:SetWidth(lbl_w - 28)
	
	RT.updateConfigList()
end

function RT.Event_Addon_SavedVariables_Load_End(h,a)
	if a == addon.identifier then
		if RareTracker_Settings == nil then RareTracker_Settings = {
			mmlocked=false, mclocked=false
		} end
		MergeTable(RareTracker_Settings, default_settings)
		for k,v in pairs(RT.moblocs) do
			if RareTracker_Settings.hidden[k] == nil then
				RareTracker_Settings.hidden[k] = {}
			end
		end
		if RareTracker_Settings.mmlocked == false then
			RT.UI.mm_button:SetTexture(addon.identifier, "img/diamond-bw-round.png")
		else
			if RareTracker_Settings.usegps then
				RT.UI.mm_button:SetTexture(addon.identifier, "img/diamond-green-round.png")
			else
				RT.UI.mm_button:SetTexture(addon.identifier, "img/diamond-red-round.png")
			end
		end
		RT.gpscontext:SetVisible(RareTracker_Settings.usegps)
		RT.UI.gps:SetPoint("TOPLEFT", UIParent, "TOPLEFT", RareTracker_Settings.gpsx, RareTracker_Settings.gpsy)
		RT.UI.button:SetPoint("TOPLEFT", UIParent, "TOPLEFT", RareTracker_Settings.mmx, RareTracker_Settings.mmy)
		if RareTracker_Settings.gpsmode == GPS_MODE_AVAIL then
			RT.UI.gps_mode:SetText("MODE: Available")
		else
			RT.UI.gps_mode:SetText("MODE: ALL")
		end
		RT.UI.button:SetHeight(RareTracker_Settings.iconsz)
		RT.UI.button:SetWidth(RareTracker_Settings.iconsz)
		if MINIMAPDOCKER then
			MINIMAPDOCKER.Register(addon.identifier, RT.UI.mm_button)
		else
			RT.UI.mm_button:SetPoint("TOPLEFT", UIParent, "TOPLEFT", RareTracker_Settings.dckx, RareTracker_Settings.dcky)
		end
		if RareTracker_Settings.background then
			RT.UI.gps:SetBackgroundColor(0.25, 0.25, 0.25, 0.5)
		else
			RT.UI.gps:SetBackgroundColor(0.25, 0.25, 0.25, 0)
		end
		for k,v in pairs(UI.tracker) do
			if RareTracker_Settings.glow then
				v.n:SetEffectGlow({strength=10, blurX=3, blurY=3})
				v.d:SetEffectGlow({strength=10, blurX=3, blurY=3})
			else
				v.n:SetEffectGlow({strength=0, blurX=0, blurY=0})
				v.d:SetEffectGlow({strength=0, blurX=0, blurY=0})
			end
		end
		
		local nn = RareTracker_Settings.hidetime
		UI.cfg.f.s_time:SetPosition(2)
		UI.cfg.f.s_time:SetPosition(nn)
		UI.cfg.f.l_time:SetText("Time: "..RareTracker_Settings.hidetime)
		UI.cfg.f.cb_hide:SetChecked(RareTracker_Settings.autohide)
		RT.GPS_Scale()
		
		GPSVISIBLE=not RareTracker_Settings.autohide
		RT.UI.gps:SetVisible(GPSVISIBLE)
		
		LibVersionCheck.register(addon.toc.Identifier, addon.toc.Version)
	end
end

function RT.updateConfigList()
	local ni = 0
	local zid = LIBZONECHANGE.currentZoneID
	if RT.moblocs[zid] and RT.moblocs[zid].mobs then
		ni = #RT.moblocs[zid].mobs
	end
	local sk, ek
	
	if ni <= 15 then
		sk=1
		ek=ni
		RT.OFFSET=0
		UI.cfg.f.sb:SetVisible(false)
	else
		if RT.OFFSET + 15 > ni then
			RT.OFFSET = ni-15
		end
		
		local bh = UI.cfg.f.sb_bg:GetHeight()
		local sh = (15/ni) * bh
		local soh = bh-sh
		local so = RT.OFFSET/(ni-15) * soh
		
		UI.cfg.f.sb:SetHeight(sh)
		UI.cfg.f.sb:SetPoint("TOPLEFT", UI.cfg.f.sb_bg, "TOPLEFT", 0, so)
		UI.cfg.f.sb:SetVisible(true)
		
		sk=RT.OFFSET+1
		ek=RT.OFFSET + 15
	end
	for x=sk, ek do
		local k = x - RT.OFFSET
		local sName = RT.moblocs[zid].mobs[x].n[MOB_LANG_KEY]
		if RareTracker_Settings.hidden[zid][sName] then
			UI.cfg.b[k].n:SetFontColor(1,0,0)
		else
			UI.cfg.b[k].n:SetFontColor(0,1,0)
		end
		UI.cfg.b[k].n:SetText(sName)
		UI.cfg.b[k].n:SetVisible(true)
	end
	for x=ek+1, 15 do
		UI.cfg.b[x].n:SetVisible(false)
	end
end

function RT.Event_libZoneChange_Player(h, zn, zid)
	GPSDATA = {}
	LMNDATA = {}
	if RT.moblocs[zid] and HIDEALWAYS == false then
		numActive = 0
		for k,v in ipairs(RT.moblocs[zid].mobs) do
			for lk, lv in ipairs(v.loc) do
				local hidden = RareTracker_Settings.hidden[zid][v.n[MOB_LANG_KEY]] or false
				if (not hidden and RareTracker_Settings.gpsmode == GPS_MODE_AVAIL) or (RareTracker_Settings.gpsmode == GPS_MODE_ALL) then
					numActive = numActive+1
					UI.tracker[numActive].c:SetVisible(true)
					local ix = ""
					if #v.loc > 1 then
						ix = "[#"..lk.."]"
					end
					table.insert(GPSDATA, {n=v.n[MOB_LANG_KEY], x=lv.x, z=lv.z, d=0, i=k, c="", h=hidden, t=ix})
					if hidden then
						table.insert(LMNDATA, {n=v.n[MOB_LANG_KEY]..ix, x=lv.x, z=lv.z, itex="img/LMNdotR.png", isrc=addon.identifier, isiz=24})
					else
						if visited[v.n[MOB_LANG_KEY]..ix] then
							table.insert(LMNDATA, {n=v.n[MOB_LANG_KEY]..ix, x=lv.x, z=lv.z, itex="img/LMNdotG.png", isrc=addon.identifier, isiz=24})
						else
							table.insert(LMNDATA, {n=v.n[MOB_LANG_KEY]..ix, x=lv.x, z=lv.z, itex="img/LMNdotB.png", isrc=addon.identifier, isiz=24})
						end
					end
				end
			end
		end
		numActive = #GPSDATA
		for x = numActive+1, maxrare do
			UI.tracker[x].c:SetVisible(false)
		end
		RT.numActive = numActive
		RT.UI.gps:SetHeight(h16 + h14 + (math_min(16, numActive) * curIconHt) + 4)
		if GPSVISIBLE == false and RareTracker_Settings.usegps and not RareTracker_Settings.autohide then
			GPSVISIBLE = true
			RT.UI.gps:SetVisible(GPSVISIBLE)
		end

		if Library.LibMapNotes then
			if numActive > 0 then
				Library.LibMapNotes.AddNodes(addon.identifier,LMNDATA)
			else
				Library.LibMapNotes.AddNodes(addon.identifier,{})
			end
		end
		MACROUPDT = {
			r=true,
			n=numActive,
			m="",
			c=0,
		}
	else
		if GPSVISIBLE == true then
			GPSVISIBLE = false
			RT.UI.gps:SetVisible(GPSVISIBLE)
			MACROUPDT = {
				r=true,
				n=0,
				m="",
				c=0,
			}
		end
	end
	RT.GPS_Scale()
	RT.updateConfigList()
	lastupdate = 0
end

function RT.direction(dt)
	if dt > 180 then dt = dt-360 end
	if dt < -180 then dt = dt+360 end

	if dt >= 169		then	d = "img/compass-S.png"
	elseif dt >= 146	then	d = "img/compass-SSW.png"
	elseif dt >= 124	then	d = "img/compass-SW.png"
	elseif dt >= 101	then	d = "img/compass-WSW.png"
	elseif dt >= 79		then	d = "img/compass-W.png"
	elseif dt >= 56		then	d = "img/compass-WNW.png"
	elseif dt >= 34		then	d = "img/compass-NW.png"
	elseif dt >= 11		then	d = "img/compass-NNW.png"
	elseif dt >= -11	then	d = "img/compass-N.png"
	elseif dt >= -34	then	d = "img/compass-NNE.png"
	elseif dt >= -56	then	d = "img/compass-NE.png"
	elseif dt >= -79	then	d = "img/compass-ENE.png"
	elseif dt >= -101	then	d = "img/compass-E.png"
	elseif dt >= -124	then	d = "img/compass-ESE.png"
	elseif dt >= -146	then	d = "img/compass-SE.png"
	elseif dt >= -169	then	d = "img/compass-SSE.png"
	else						d = "img/compass-S.png"
	end

	return {i="", l=d}
end

local prev_macro = nil

function RT.SetMacro()
	if prev_macro ~= MACROUPDT.m then
		if Inspect.System.Secure() == false then
			MACROUPDT.r = false
			prev_macro = MACROUPDT.m
			if MACROUPDT.n == 0 then
				RT.UI.button:SetVisible(false)
				RT.UI.btnlab:SetVisible(false)
			else
				RT.UI.button:SetVisible(true)
				RT.UI.btnlab:SetVisible(true)
			end

		end
	else
		MACROUPDT.r = false
	end
	if Inspect.System.Secure() == false then
		if RareTracker_Settings.mclocked == false then
			RT.UI.button:SetTexture(addon.identifier, "img/diamond-bw.png")
		else
			if MACROUPDT.c > 0 then
				RT.UI.button:EventMacroSet(Event.UI.Input.Mouse.Left.Click, MACROUPDT.m)
				RT.UI.button:SetTexture(addon.identifier, "img/diamond-green.png")
			else
				RT.UI.button:EventMacroSet(Event.UI.Input.Mouse.Left.Click, nil)
				RT.UI.button:SetTexture(addon.identifier, "img/diamond-red.png")
			end
		end
		RT.UI.btnlab:SetText(string_format("%d",MACROUPDT.c))
	end
end

function RT.Event_System_Update_Begin(h)
	if AUTOHIDETIME and Inspect.Time.Real() > AUTOHIDETIME and not UI.cfg.f.f:GetVisible() then
		GPSVISIBLE = false
		RT.UI.gps:SetVisible(GPSVISIBLE)		
		AUTOHIDETIME = false
	end
	if #GPSDATA > 0 then
		local ctx = Inspect.Time.Real()
		local newmacro = ""
		local macrocnt = 0
		if ctx - lastupdate > 1 then
			local pd = Inspect.Unit.Detail("player")
			if pd ~= nil and pd.coordX then
				for k,v in pairs(GPSDATA) do
					local dx = pd.coordX - v.x
					local dz = pd.coordZ - v.z
					local d = math_sqrt((dx^2)+(dz^2))
					local dr= math_atan(dx,dz)*180/math_pi
					local c = RT.direction(dr).l
					GPSDATA[k].d = d
					GPSDATA[k].c = c
				end
				table.sort(GPSDATA, function(a,b) return a.d < b.d end)
				local macrodetails = {}
				newmacro = "suppressmacrofailures"
				for k,v in ipairs(GPSDATA) do
					if v.d <= 300 then
						if macrodetails[v.n] == nil then
							newmacro = string_format("%s\ntargetexact %s", newmacro, v.n)
							macrocnt = macrocnt+1
							macrodetails[v.n] = true
						end
					end
					if UI.tracker[k].ci ~= v.c then
						UI.tracker[k].i:SetTexture(addon.identifier, v.c)
						UI.tracker[k].ci = v.c
					end
					UI.tracker[k].n:SetText(string_format("%s %s",v.n,v.t))
					UI.tracker[k].d:SetText(string_format("%dm",v.d))
					if v.h then
						UI.tracker[k].n:SetFontColor(1,0,0)
					elseif visited[v.n..v.t] then
						UI.tracker[k].n:SetFontColor(0,1,0)
					else
						UI.tracker[k].n:SetFontColor(1,1,1)
					end
				end
				lastupdate = ctx
				MACROUPDT.m=newmacro
				MACROUPDT.c=macrocnt
				MACROUPDT.r=true
			end
		end
	end
	if MACROUPDT.r then
		RT.SetMacro()
	end
end

function RT.Event_System_Secure_Enter(h)
	RT.UI.button.MouseDown = false
end

function RT.Event_System_Secure_Leave(h)
	if MACROUPDT.r then
		MACROUPDT.r = false
		RT.SetMacro()
	end
end

function RT.AchvtCompare()
	local UH = "c5C766AF68015CB70"	-- Ultimate Hunter
	local UC = "c128FB25EE807902B"	-- Ultimate Camper
	local KILLED = {}
	
	for ak, ad in pairs({[UH] = true, [UC] = true}) do
		local d = Inspect.Achievement.Detail(ak)
		for k,v in pairs(d.requirement) do
			if v.complete then
				KILLED[v.name] = true
			end
		end
	end

	for zk,zv in pairs(RT.moblocs) do
		for mk, mv in pairs(zv.mobs) do
			if KILLED[mv.n.EN] or KILLED[mv.n[MOB_LANG_KEY]] then
				if RareTracker_Settings.hidden[zk][mv.n.EN] or RareTracker_Settings.hidden[zk][mv.n[MOB_LANG_KEY]] then
					-- already hiding
				else
					print(mv.n.EN.." : killed, but not hidden")
					RareTracker_Settings.hidden[zk][mv.n[MOB_LANG_KEY]] = true
				end
			end
		end
	end

	RT.Event_libZoneChange_Player(0, LIBZONECHANGE.currentZoneName, LIBZONECHANGE.currentZoneID)
end


function RT.Command_Slash_Register(h, args)
	local r = {}
	local numargs = 0
	for token in string.gmatch(args, "[^%s]+") do
		numargs=numargs+1
		r[numargs] = token
	end

	if r[1] == "background" then
		RareTracker_Settings.background = not RareTracker_Settings.background
		if RareTracker_Settings.background then
			RT.UI.gps:SetBackgroundColor(0.25, 0.25, 0.25, 0.5)
		else
			RT.UI.gps:SetBackgroundColor(0.25, 0.25, 0.25, 0)
		end
	elseif r[1] == "text" then
		RareTracker_Settings.glow = not RareTracker_Settings.glow
		for k,v in pairs(UI.tracker) do
			if RareTracker_Settings.glow then
				v.n:SetEffectGlow({strength=10, blurX=3, blurY=3})
				v.d:SetEffectGlow({strength=10, blurX=3, blurY=3})
			else
				v.n:SetEffectGlow({strength=0, blurX=0, blurY=0})
				v.d:SetEffectGlow({strength=0, blurX=0, blurY=0})
			end
		end
	elseif r[1] == "reset" then
		if MINIMAPDOCKER then
			print("Not relocating minimap button - Docker installed. Look for it there!")
		else
			RareTracker_Settings.dckx = 200
			RareTracker_Settings.dcky = 200
			RT.UI.mm_button:SetPoint("TOPLEFT", UIParent, "TOPLEFT", RareTracker_Settings.dckx, RareTracker_Settings.dcky)
			print("Reset location of minimap button to 200,200")
		end
		RareTracker_Settings.mmx = 250
		RareTracker_Settings.mmy = 200
		RT.UI.button:SetPoint("TOPLEFT", UIParent, "TOPLEFT", RareTracker_Settings.mmx, RareTracker_Settings.mmy)
		print("Reset location of macro button to 250,200")
		RareTracker_Settings.gpsx = 300
		RareTracker_Settings.gpsy = 200
		RT.UI.gps:SetPoint("TOPLEFT", UIParent, "TOPLEFT", RareTracker_Settings.gpsx, RareTracker_Settings.gpsy)
		print("Reset location of tracker window to 300,200")
	elseif r[1] == "achv" then
		RT.AchvtCompare()
	else
		print("/raretracker background - toggles display of background")
		print("/raretracker text - toggles display of text effect")
		print("/raretracker reset - Repositions the various buttons")
	end
end

-- on raredardata.lua : s/ "/"/g   s/" /"/g
-- /script RT.raredar()
function RT.raredar()
	local md = {}

	for _,m in pairs(RT.raredar) do
		 for k,v in pairs(m.mobs) do
			md[v.targ.English] = { n={["FR"] = v.targ.French, ["DE"] = v.targ.German, ["RU"] = v.targ.russian }, l=v.pos}
		end
	end

	RT_MOBS = {}
	local seen = {}

	for zid,z in pairs(RT.moblocs) do
		RT_MOBS[zid] = { name=z.name, mobs={} }
		local idx = 0
		for k,m in ipairs(z.mobs) do
			local en = m.n["EN"]
			local mloc = {}
			MergeTable(mloc, m.loc)
			if md[m.n["EN"]].n["RU"] then
				table.insert(RT_MOBS[zid].mobs, {n={EN=m.n["EN"], DE=m.n["DE"], FR=m.n["FR"], RU=md[m.n["EN"]].n["RU"]}, loc=mloc })
			else
				table.insert(RT_MOBS[zid].mobs, {n={EN=m.n["EN"], DE=m.n["DE"], FR=m.n["FR"], RU="XLATE:"..m.n["EN"]}, loc=mloc })
			end
		end

		for mk,mv in pairs(RT_MOBS[zid].mobs) do
			local en = mv.n["EN"]
			for _,ld in pairs(md[en].l) do
				local fnd = false
				for lk, lv in pairs(mv.loc) do
					if math.abs(lv.x - ld[1]) < 10 and math.abs(lv.z - ld[2]) < 10 then
						fnd = true
					end
				end
				if fnd == false then
					print("New coord for "..en)
					table.insert(RT_MOBS[zid].mobs[mk].loc, {x=ld[1], z=ld[2]})
				end
			end
		end
	end
end

function RT.Event_Unit_Availability_Full(h,t)
	for k,v in pairs(t) do
		if v == "player" then
			RT.GPS_Scale()
			Command.Event.Detach(Event.Unit.Availability.Full, nil, nil, nil, addon.identifier)
--[[
			RareTracker_Settings.txn = RareTracker_Settings.txn or {}
			RareTracker_Settings.txn.z0000012D6EEBB377 = RareTracker_Settings.txn.z0000012D6EEBB377 or {}
			RareTracker_Settings.txn.z0000012E087E78E1 = RareTracker_Settings.txn.z0000012E087E78E1 or {}
			RareTracker_Settings.txn.z0000012F14279B5A = RareTracker_Settings.txn.z0000012F14279B5A or {}
			
			local lk = Inspect.System.Language()
			local rq = Inspect.Achievement.Detail("c1B92F5B5A3362FC7").requirement
			
			for k,v in pairs(rq) do
				RareTracker_Settings.txn.z0000012D6EEBB377[k] = RareTracker_Settings.txn.z0000012D6EEBB377[k] or {}
				RareTracker_Settings.txn.z0000012D6EEBB377[k][lk] = v.name
			end

			rq = Inspect.Achievement.Detail("c332FA98C9A040364").requirement
			for k,v in pairs(rq) do
				RareTracker_Settings.txn.z0000012E087E78E1[k] = RareTracker_Settings.txn.z0000012E087E78E1[k] or {}
				RareTracker_Settings.txn.z0000012E087E78E1[k][lk] = v.name
			end

			rq = Inspect.Achievement.Detail("c368E1E6A3FA44C96").requirement
			for k,v in pairs(rq) do
				RareTracker_Settings.txn.z0000012F14279B5A[k] = RareTracker_Settings.txn.z0000012F14279B5A[k] or {}
				RareTracker_Settings.txn.z0000012F14279B5A[k][lk] = v.name
			end
]]--		
		end
	end
end

RT.BuildUI()

Command.Event.Attach(Event.System.Update.Begin, RT.Event_System_Update_Begin, "Event.System.Update.Begin")
Command.Event.Attach(Event.Addon.SavedVariables.Load.End, RT.Event_Addon_SavedVariables_Load_End, "Event.Addon.SavedVariables.Load.End")
Command.Event.Attach(Event.System.Secure.Leave, RT.Event_System_Secure_Leave, "Event.System.Secure.Leave")
Command.Event.Attach(Event.System.Secure.Enter, RT.Event_System_Secure_Enter, "Event.System.Secure.Enter")
Command.Event.Attach(Library.libZoneChange.Player, RT.Event_libZoneChange_Player, "Library.LibZoneChange.Player")
Command.Event.Attach(Command.Slash.Register("raretracker"), RT.Command_Slash_Register, "Command.Slash.Register")
Command.Event.Attach(Event.Unit.Availability.Full, RT.Event_Unit_Availability_Full, "Event.Unit.Availability.Full")
print(string.format("v%s loaded.", addon.toc.Version))
