local _addoninfo, _mmData = ...
local _addon = _addoninfo.identifier

_mmData = _mmData or {}
_mmData.MountMeConfig = _mmData.MountMeConfig or {}
	
local DefaultSettings = function ()
	if _mmData.MountMeConfig.LockUI == nil then _mmData.MountMeConfig.LockUI = true end
	if _mmData.MountMeConfig.UI_x == nil then _mmData.MountMeConfig.UI_x = 200 end
	if _mmData.MountMeConfig.UI_y == nil then _mmData.MountMeConfig.UI_y = 200 end
	if _mmData.MountMeConfig.Config_x == nil then _mmData.MountMeConfig.Config_x = 200 end
	if _mmData.MountMeConfig.Config_y == nil then _mmData.MountMeConfig.Config_y = 200 end
	if _mmData.MountMeConfig.MountFirst == nil then _mmData.MountMeConfig.MountFirst = true end
	if _mmData.MountMeConfig.VerticleUI == nil then _mmData.MountMeConfig.VerticleUI = false end
	if _mmData.MountMeConfig.ScaleUI == nil then _mmData.MountMeConfig.ScaleUI = 100 end
	
	if _mmData.MountMeConfig.Mounts == nil then _mmData.MountMeConfig.Mounts = {} end	
	if _mmData.MountMeConfig.Mounts.ShowUI == nil then _mmData.MountMeConfig.Mounts.ShowUI = true end	
	if _mmData.MountMeConfig.Mounts.List == nil then _mmData.MountMeConfig.Mounts.List = {} end
	if _mmData.MountMeConfig.Mounts.AllowDuplicates == nil then _mmData.MountMeConfig.Mounts.AllowDuplicates = false end
	if _mmData.MountMeConfig.Mounts.UniqueSummon == nil then _mmData.MountMeConfig.Mounts.UniqueSummon = false end
	if _mmData.MountMeConfig.Mounts.ShowText == nil then _mmData.MountMeConfig.Mounts.ShowText = false end
	if _mmData.MountMeConfig.Mounts.DisplayIcon == nil then _mmData.MountMeConfig.Mounts.DisplayIcon = true end

	if _mmData.MountMeConfig.Pets == nil then _mmData.MountMeConfig.Pets = {} end	
	if _mmData.MountMeConfig.Pets.ShowUI == nil then _mmData.MountMeConfig.Pets.ShowUI = true end	
	if _mmData.MountMeConfig.Pets.List == nil then _mmData.MountMeConfig.Pets.List = {} end
	if _mmData.MountMeConfig.Pets.AllowDuplicates == nil then _mmData.MountMeConfig.Pets.AllowDuplicates = false end
	if _mmData.MountMeConfig.Pets.UniqueSummon == nil then _mmData.MountMeConfig.Pets.UniqueSummon = false end
	if _mmData.MountMeConfig.Pets.ShowText == nil then _mmData.MountMeConfig.Pets.ShowText = false end
	if _mmData.MountMeConfig.Pets.DisplayIcon == nil then _mmData.MountMeConfig.Pets.DisplayIcon = true end
end

local function LoadSettings(self, _add)
	if _add ~= _addon then return end
	
	_mmData.MountMeConfig = _G["MountMeConfig"] or {}
	DefaultSettings()
end

local function SaveSettings(self, _add)
	if _add ~= _addon then return end
	_G["MountMeConfig"] = _mmData.MountMeConfig
end

local function LoadComplete(self, _add)
	if _add ~= _addon then return end
	_mmData.MountMeConfig.Loaded = true
	print(string.format("%s v.%s loaded.", _addon, _addoninfo.toc.Version))
	MM_InitUI()
end

Command.Event.Attach(Event.Addon.SavedVariables.Load.End, LoadSettings, _addon.."LoadSettings")
Command.Event.Attach(Event.Addon.SavedVariables.Save.Begin, SaveSettings, _addon.."SaveSettings")
Command.Event.Attach(Event.Addon.Load.End, LoadComplete, _addon.."LoadComplete")