local _addoninfo, _mmData = ...
local _addon = _addoninfo.identifier

local MM = nil
local mmUI = nil
local mmConfigUI = nil
local icon_width = 40
local icon_height = 40
local ignoreRightClick = false

local function Dismount()
	if not mmUI then return end
	mmUI.Mounted = false
end

local RightDown = function()
	if MM.LockUI then return end
	ignoreRightClick = false
	local cMouse = Inspect.Mouse()
	mmUI.UI_x = cMouse.x - mmUI.Main:GetLeft()
	mmUI.UI_y = cMouse.y - mmUI.Main:GetTop()
	mmUI.Main.MouseDown = true
end

local RightUp = function()
	if mmUI.Main:GetLeft() ~= MM.UI_x or mmUI.Main:GetTop() ~= MM.UI_y then ignoreRightClick = true end
	mmUI.Main.MouseDown = false
	MM.UI_x = mmUI.Main:GetLeft()
	MM.UI_y = mmUI.Main:GetTop()
end

local MouseMove = function(xPos, yPos)
	if MM.LockUI or mmUI.SystemLocked then return end
	if mmUI.Main.MouseDown then
		if not mmUI.SystemLocked then mmUI.Main.Frame:SetPoint("TOPLEFT", UIParent, "TOPLEFT", xPos - mmUI.UI_x, yPos - mmUI.UI_y) end
	end
end

local function CopyTableColumn(_orig, _col)
	local _ret = {}
	for k, j in pairs(_orig) do	table.insert(_ret, j[_col])	end
	return _ret
end

local function GetIcon(_name)
	local _icon = nil
	
	for i, j in pairs(MM.Mounts.List) do
		if j[2] == _name then _icon = j[5] end
	end
	
	if not _icon then
		for i, j in pairs(MM.Pets.List) do
			if j[2] == _name then _icon = j[5] end
		end
	end

	return _icon
end

local function SetButtonMacro(btn, tbl, override)
	if (mmUI.SystemLocked or not btn.LeftDown) and not override then return nil end
	if #tbl == 0 then return nil end

	btn:SetSecureMode("restricted")
	math.randomseed(Inspect.Time.Frame())
	math.random(); math.random(); math.random()
	local _number = math.random(#tbl)
	local _name = tbl[_number]

	btn.Macro = string.format ('use %s', _name)
	btn.SummonName = _name
	
	btn:EventMacroSet(Event.UI.Input.Mouse.Left.Click, btn.Macro)
	btn:EventMacroSet(Event.UI.Input.Mouse.Middle.Click, btn.Macro)
	
	return _number, _name
end

local function GetRandomMount(override)
	if mmUI.Mounted then
		Dismount()
		return
	end
	
	if #MM.Mounts.List == 0 then
		print("Your stables are empty.  Please fill them before attempting again.")
		return
	elseif #mmUI.Main.ActiveMounts == 0 then
		mmUI.Main.ActiveMounts = CopyTableColumn(MM.Mounts.List, 2)
	end
	
	local iMount, sMount = SetButtonMacro(mmUI.Main.MountButton, mmUI.Main.ActiveMounts, override)
	currentMount = sMount
	if MM.Mounts.ShowText and sMount then print(string.format("Getting %s from the stables.", sMount)) end

	if MM.Mounts.DisplayIcon then
		local _icon = mmUI.Main.MountButton:GetParent()
		if not mmUI.SystemLocked then _icon:SetTexture("Rift",GetIcon(sMount)) end
	end
		
	if MM.Mounts.UniqueSummon then
		table.remove(mmUI.Main.ActiveMounts, iMount)
		if #mmUI.Main.ActiveMounts == 0 then mmUI.Main.ActiveMounts = CopyTableColumn(MM.Mounts.List, 2) end
	elseif #MM.Mounts.List ~= #mmUI.Main.ActiveMounts then
		mmUI.Main.ActiveMounts = CopyTableColumn(MM.Mounts.List, 2)
	end
	
	mmUI.Mounted = true
end

local function GetRandomPet(override)
	if #MM.Pets.List == 0 then
		print("Your cages are empty.  Please fill them before attempting again.")
		return
	elseif #mmUI.Main.ActivePets == 0 then
		mmUI.Main.ActivePets = CopyTableColumn(MM.Pets.List, 2)		
	end

	local iPet, sPet = SetButtonMacro(mmUI.Main.PetButton, mmUI.Main.ActivePets, override)
	currentPet = sPet
	
	if MM.Pets.ShowText and sPet then print(string.format("Getting %s from their cage.", sPet)) end

	if MM.Pets.DisplayIcon then
		local _icon = mmUI.Main.PetButton:GetParent()
		if not mmUI.SystemLocked then _icon:SetTexture("Rift", GetIcon(sPet)) end
	end
	
	if MM.Pets.UniqueSummon then
		table.remove(mmUI.Main.ActivePets, iPet)
		if #mmUI.Main.ActivePets == 0 then mmUI.Main.ActivePets = CopyTableColumn(MM.Pets.List, 2) end
	elseif #MM.Pets.List ~= #mmUI.Main.ActivePets then
		mmUI.Main.ActivePets = CopyTableColumn(MM.Pets.List, 2)
	end
	
	Dismount()
end

local MouseDownEvent = function(_btn)
	_btn.LeftDown = true
end

local SummonToolTip = function(_btn)
	return _btn.SummonName
end


local BuildUI = function(_context, _data)
	_ret = {}
	
	_ret.ToggleButton = function(_self, _btn, _bool)
		if _btn == "mount" then
			_self.MountIcon:SetVisible(_bool)
			_self.MountButton:SetVisible(_bool)
		elseif _btn == "pet" then
			_self.PetIcon:SetVisible(_bool)
			_self.PetButton:SetVisible(_bool)
		end
	end
	
	_ret.DrawButtons = function(_self)
		if mmUI.SystemLocked then return end
		_self.Frame:SetVisible(false)
		
		local scale_x = icon_width * (MM.ScaleUI/100) 
		local scale_y = icon_height * (MM.ScaleUI/100)

		_self.PetButton:ClearAll()
		_self.PetIcon:ClearAll()		
		_self.MountIcon:SetLayer(0)
		_self.MountButton:SetLayer(1)
		_self.PetIcon:SetLayer(0)
		_self.PetButton:SetLayer(1)
		
		if _data.VerticleUI then
			_self.Frame:SetWidth(scale_x)
			_self.Frame:SetHeight((2 * scale_y) + 5)
			if _data.MountFirst then
				_self.MountIcon:SetPoint("TOPLEFT", _self.Frame, "TOPLEFT", 0, 0)
				_self.MountIcon:SetPoint("BOTTOMRIGHT", _self.Frame, "TOPRIGHT", 0, scale_y)

				_self.PetIcon:SetPoint("TOPLEFT", _self.Frame, "BOTTOMLEFT", 0, (-1 * scale_y))
				_self.PetIcon:SetPoint("BOTTOMRIGHT", _self.Frame, "BOTTOMRIGHT", 0, 0)	
			else
				_self.PetIcon:SetPoint("TOPLEFT", _self.Frame, "TOPLEFT", 0, 0)
				_self.PetIcon:SetPoint("BOTTOMRIGHT", _self.Frame, "TOPRIGHT", 0, scale_y)
				
				_self.MountIcon:SetPoint("TOPLEFT", _self.Frame, "BOTTOMLEFT", 0, (-1 * scale_y))
				_self.MountIcon:SetPoint("BOTTOMRIGHT", _self.Frame, "BOTTOMRIGHT", 0, 0)				
			end	
		else
			_self.Frame:SetWidth((2 * scale_x) + 5)
			_self.Frame:SetHeight(scale_y)
			if _data.MountFirst then
				_self.MountIcon:SetPoint("TOPLEFT", _self.Frame, "TOPLEFT", 0, 0)
				_self.MountIcon:SetPoint("BOTTOMRIGHT", _self.Frame, "BOTTOMLEFT", scale_x, 0)

				_self.PetIcon:SetPoint("TOPRIGHT", _self.Frame, "TOPRIGHT", 0, 0)
				_self.PetIcon:SetPoint("BOTTOMLEFT", _self.Frame, "BOTTOMRIGHT", (-1 * scale_x), 0)	
			else
				_self.PetIcon:SetPoint("TOPLEFT", _self.Frame, "TOPLEFT", 0, 0)
				_self.PetIcon:SetPoint("BOTTOMRIGHT", _self.Frame, "BOTTOMLEFT", scale_x, 0)

				_self.MountIcon:SetPoint("TOPRIGHT", _self.Frame, "TOPRIGHT", 0, 0)
				_self.MountIcon:SetPoint("BOTTOMLEFT", _self.Frame, "BOTTOMRIGHT", (-1 * scale_x), 0)					
			end		
		end
		_self.MountButton:SetPoint("TOPLEFT", _self.MountIcon, "TOPLEFT", 0, 0)
		_self.MountButton:SetPoint("BOTTOMRIGHT", _self.MountIcon, "BOTTOMRIGHT", 0, 0)		
		_self.PetButton:SetPoint("TOPLEFT", _self.PetIcon, "TOPLEFT", 0, 0)
		_self.PetButton:SetPoint("BOTTOMRIGHT", _self.PetIcon, "BOTTOMRIGHT", 0, 0)		
		
		mmUI.Main.dirty = false
		_self.Frame:SetVisible(true)
	end
	
	_ret.Frame = UI.CreateFrame("Frame", "Main.Frame", _context)
	_ret.Frame:SetPoint("TOPLEFT", UIParent, "TOPLEFT", _data.UI_x, _data.UI_y)
	
	_ret.Frame:SetVisible(false)
	_ret.Frame:SetLayer(0)
	_ret.Frame:SetSecureMode("restricted")
	_ret.Frame.Tip = UI.CreateFrame("SimpleTooltip", "MountTip", _ret.Frame)
	
	_ret.MountIcon = UI.CreateFrame("Texture", "Main.MoutIcon", _ret.Frame)
	_ret.MountIcon:SetTexture("MountMe", "images/MountMeIcon.png")
	Library.LibSimpleWidgets.SetBorder(_ret.MountIcon, 2, .6, .6, .6, 1)


	_ret.MountIcon:SetVisible(MM.Mounts.ShowUI)
	_ret.MountIcon:SetSecureMode("restricted")
	
	_ret.MountButton = UI.CreateFrame("Frame", "Main.MountButton", _ret.MountIcon)
	_ret.MountButton:SetVisible(MM.Mounts.ShowUI)
	_ret.MountButton.LeftDown = false
	_ret.MountButton.SummonName = "Random Mount"
	_ret.MountButton:EventAttach(Event.UI.Input.Mouse.Middle.Up, function() Dismount() end, "MountButton.MiddleUp")
	_ret.MountButton:EventAttach(Event.UI.Input.Mouse.Left.Down, function() MouseDownEvent(mmUI.Main.MountButton) end, "MountButton.LeftDown")
	_ret.MountButton:EventAttach(Event.UI.Input.Mouse.Left.Up, function() GetRandomMount() end, "MountButton.LeftUp")
	_ret.MountButton:EventAttach(Event.UI.Input.Mouse.Right.Down, function() RightDown() end, "MountButton.RightDown")
	_ret.MountButton:EventAttach(Event.UI.Input.Mouse.Right.Up, function() RightUp() end, "MountButton.RightUp")	
	_ret.MountButton:EventAttach(Event.UI.Input.Mouse.Right.Click, function(_self, h) 
				if mmUI.SystemLocked then return end
				if not ignoreRightClick then mmUI.ConfigUI:SetVisible(not  mmUI.ConfigUI:GetVisible(), 2) end 
				ignoreRightClick = false end, "MountButton.RightClick")				
	_ret.MountButton:EventAttach(Event.UI.Input.Mouse.Cursor.Move, function(_self, h, _x, _y) MouseMove(_x, _y) end, "MountButton.MouseMove")
    _ret.Frame.Tip:InjectEvents(_ret.MountButton, function() return SummonToolTip(mmUI.Main.MountButton) end)
    
	_ret.PetIcon = UI.CreateFrame("Texture", "Main.PetIcon", _ret.Frame)
	_ret.PetIcon:SetTexture("MountMe", "images/PetMeIcon.png")
	Library.LibSimpleWidgets.SetBorder(_ret.PetIcon, 2, .6, .6, .6, 1)

	_ret.PetIcon:SetVisible(MM.Pets.ShowUI)
	_ret.PetIcon:SetSecureMode("restricted")
	
	_ret.PetButton = UI.CreateFrame("Frame", "Main.PetButton", _ret.PetIcon)	
	_ret.PetButton:SetVisible(MM.Pets.ShowUI)
	_ret.PetButton.LeftDown = false
	_ret.PetButton.SummonName = "Random Pet"
	_ret.PetButton:EventAttach(Event.UI.Input.Mouse.Left.Down, function() MouseDownEvent(mmUI.Main.PetButton) end, "PetButton.LeftDown")
	_ret.PetButton:EventAttach(Event.UI.Input.Mouse.Left.Up, function() GetRandomPet() end, "PetButton.LeftUp")
	_ret.PetButton:EventAttach(Event.UI.Input.Mouse.Right.Down, function() RightDown() end, "PetButton.RightDown")
	_ret.PetButton:EventAttach(Event.UI.Input.Mouse.Right.Up, function() RightUp() end, "PetButton.RightUp")
	_ret.PetButton:EventAttach(Event.UI.Input.Mouse.Right.Click, function(_self, h) 
			if mmUI.SystemLocked then return end
			if not ignoreRightClick then mmUI.ConfigUI:SetVisible(not  mmUI.ConfigUI:GetVisible(), 3) end 
			ignoreRightClick = false end, "PetButton.RightClick")	
	
	_ret.PetButton:EventAttach(Event.UI.Input.Mouse.Cursor.Move, function(_self, h, _x, _y) MouseMove(_x, _y) end, "PetButton.MouseMove")
	_ret.Frame.Tip:InjectEvents(_ret.PetButton, function() return SummonToolTip(mmUI.Main.PetButton) end)
	
	_ret.MouseDown = false
	_ret.SetVisible = function(_self, _vis) _self.Frame:SetVisible(_vis) end
	_ret.GetVisible = function(_self) return _self.Frame:GetVisible() end
	_ret.GetLeft = function (_self) return _self.Frame:GetLeft() end
	_ret.GetTop = function (_self) return _self.Frame:GetTop() end

	return _ret
end

local function LockSystem()
	if not mmUI then return end
	mmUI.SystemLocked = true
end

local function UnLockSystem()
	if not mmUI then return end
	mmUI.SystemLocked = false
	if mmUI.Main.dirty then mmUI.Main:DrawButtons() end
end

local function mmSlash(_args)
	mmUI.ConfigUI:SetVisible(true)
end

function MM_InitUI()
	MM = MM or _mmData.MountMeConfig
	mmUI = {}
	mmUI.Context = UI.CreateContext("MountMe")
	mmUI.Context:SetSecureMode("restricted")
	mmUI.Main = BuildUI(mmUI.Context, MM)
	mmUI.Main:DrawButtons()
	mmUI.SystemLocked = false
	mmUI.Mounted = false
	mmUI.Main.Dirty = false
	mmUI.Main.ActiveMounts = CopyTableColumn(MM.Mounts.List, 2)
	mmUI.Main.ActivePets = CopyTableColumn(MM.Pets.List, 2)
	--SetButtonMacro(mmUI.Main.MountButton, mmUI.Main.ActiveMounts, true)
	--SetButtonMacro(mmUI.Main.PetButton, mmUI.Main.ActivePets, true)
	GetRandomMount(true)
	GetRandomPet(true)
	mmUI.ConfigUI = BuildConfigUI(MM, mmUI)
end

--Command.System.Strict()
Command.Event.Attach(Command.Slash.Register("MountMe"), mmSlash, _addon.."SlashHandler")
Command.Event.Attach(Event.System.Secure.Enter, LockSystem, _addon.."SystemLocked")
Command.Event.Attach(Event.System.Secure.Leave, UnLockSystem, _addon.."SystemUnLocked")
Command.Event.Attach(Event.Ability.New.Cooldown.Begin, Dismount, _addon.."DismountCooldown")
Command.Event.Attach(Event.Combat.Death, Dismount, _addon.."DismountDeath")

