-- ****************************************************************************

function Dump()

	-- Create a local table with numeric id's for sortability
	local t = {}
	local index = 1
	for id,v in pairs(zcontext.deathlist) do
		t[index] = id
		index = index + 1
	end
	
	-- Sort the table based on criteria
	SortBook(t)
	
	-- Dump the table to the GUI
	local start = (zcontext.book_currentpage * 10) + 1

	for i = 1, 10 do

		if (t[i+start-1] ~= nil) then

			local id = t[i+start-1]
			record = zcontext.deathlist[id]

			zcontext.label_book[i].name:SetText(record.name)
			zcontext.label_book[i].calling:SetText(record.calling)
			zcontext.label_book[i].kills:SetText(tostring(record.kills))
			zcontext.label_book[i].deaths:SetText(tostring(record.deaths))
			zcontext.label_book[i].score:SetText(tostring(record.score))
			
		else
			zcontext.label_book[i].name:SetText("")
			zcontext.label_book[i].calling:SetText("")
			zcontext.label_book[i].kills:SetText("")
			zcontext.label_book[i].deaths:SetText("")
			zcontext.label_book[i].score:SetText("")
		end
		
	end

	local tablesize = 0
	for id,v in pairs(zcontext.deathlist) do
		tablesize = tablesize + 1
	end
	local maxpage = math.ceil(tablesize / 10) - 1
	SetCurrentPageNum(zcontext.book_currentpage+1, maxpage+1)
	
	
end

-- ****************************************************************************

function CreateUI()

	-- UI elements are global in this case
	zcontext.guicontext = UI.CreateContext("DeathBookContext")
	
	-- Create the window
	zcontext.window = UI.CreateFrame("RiftWindow", "SampleWindow", zcontext.guicontext)
	zcontext.window:SetPoint("TOPCENTER", UIParent, "TOPCENTER", 0, 32)
	zcontext.window:SetTitle("Book of Death - by Rothiel")
	zcontext.window:SetWidth(640)
	zcontext.window:SetHeight(680)
	zcontext.window:SetVisible(false);
	
	
	-- Create the Primary Text on top
	zcontext.textframe = UI.CreateFrame("Text", "OutputFrame", zcontext.guicontext)
	zcontext.textframe:SetFontSize(24)
	zcontext.textframe:SetFontColor(1,1,1, 1)
	SetText("Book of Death - by Rothiel")
	
	function zcontext.textframe.Event:LeftClick()
		zcontext.window:SetVisible(not zcontext.window:GetVisible())
		zcontext.bookvisible = zcontext.window:GetVisible()
		if (zcontext.window:GetVisible()) then
			UpdateSummary()
			Dump()
		end
	end
	
	-- Create the Close Button
	local button_close = UI.CreateFrame("RiftButton", "button_close", zcontext.window)
	button_close:SetSkin("close")
	button_close:SetPoint("TOPRIGHT", zcontext.window, "TOPRIGHT", -8, 15)

	function button_close.Event:LeftPress ()
		zcontext.window:SetVisible(false)
	end	

	-- Create the Book button
	local button_book = UI.CreateFrame("RiftButton", "button_book", zcontext.window)
	button_book:SetText("Book")
	button_book:SetPoint("BOTTOMCENTER", zcontext.window, "BOTTOMCENTER", 0, -24)

	function button_book.Event:LeftPress ()
		zcontext.summaryframe:SetVisible(false)
		zcontext.bookframe:SetVisible(true)
		zcontext.configframe:SetVisible(false)
	end	

	-- Create the Summary button
	local button_summary = UI.CreateFrame("RiftButton", "button_summary", zcontext.window)
	button_summary:SetText("Summary")
	button_summary:SetPoint("BOTTOMRIGHT", button_book, "BOTTOMLEFT", 0, 0)

	function button_summary.Event:LeftPress ()
		UpdateSummary()
		zcontext.summaryframe:SetVisible(true)
		zcontext.bookframe:SetVisible(false)
		zcontext.configframe:SetVisible(false)
	end	

	-- Create the Configuration button
	local button_config = UI.CreateFrame("RiftButton", "button_config", zcontext.window)
	button_config:SetText("Config")
	button_config:SetPoint("BOTTOMLEFT", button_book, "BOTTOMRIGHT", 0, 0)

	function button_config.Event:LeftPress ()
		zcontext.summaryframe:SetVisible(false)
		zcontext.bookframe:SetVisible(false)
		zcontext.configframe:SetVisible(true)
	end	

	CreateSummaryFrame()
	CreateBookFrame()
	CreateConfigFrame()	
	
	UpdateSummary()
		
	-- Make the summary frame visible
	zcontext.summaryframe:SetVisible(true)
	
end

-- ****************************************************************************

function CreateSummaryFrame()

	-- Create the Summary Frame
	zcontext.summaryframe = UI.CreateFrame("Frame", "summaryframe", zcontext.window)
	zcontext.summaryframe:SetPoint("TOPLEFT", zcontext.window, "TOPLEFT", 40, 70)
	zcontext.summaryframe:SetWidth(zcontext.window:GetWidth() - (40 + 40))
	zcontext.summaryframe:SetHeight(zcontext.window:GetHeight() - (70 + 70))
	zcontext.summaryframe:SetVisible(false)

	-- Title
	local label_title = UI.CreateFrame("Text", "label_title", zcontext.summaryframe)
	label_title:SetFontSize(26)
	label_title:SetText("Summary")
	label_title:SetHeight(label_title:GetFullHeight())
	label_title:SetWidth(label_title:GetFullWidth())
	label_title:SetPoint("CENTERTOP", zcontext.summaryframe, "CENTERTOP", 0, 0)
	
	-- Score
	local label_scoretext = UI.CreateFrame("Text", "label_scoretext", zcontext.summaryframe)
	label_scoretext:SetFontSize(20)
	label_scoretext:SetText("Score:")
	label_scoretext:SetHeight(label_scoretext:GetFullHeight())
	label_scoretext:SetWidth(label_scoretext:GetFullWidth())
	label_scoretext:SetPoint("TOPRIGHT", zcontext.summaryframe, "TOPLEFT", 125, 70)

	local label_score = UI.CreateFrame("Text", "label_score", zcontext.summaryframe)
	label_score:SetFontSize(20)
	label_score:SetText("0")
	label_score:SetHeight(label_score:GetFullHeight())
	label_score:SetWidth(128)
	label_score:SetPoint("TOPLEFT", label_scoretext, "TOPRIGHT", 6, 0)
	zcontext.label_score = label_score

	-- Total Kills
	local label_totalkillstext = UI.CreateFrame("Text", "label_totalkillstext", zcontext.summaryframe)
	label_totalkillstext:SetFontSize(20)
	label_totalkillstext:SetText("Total Kills:")
	label_totalkillstext:SetHeight(label_totalkillstext:GetFullHeight())
	label_totalkillstext:SetWidth(label_totalkillstext:GetFullWidth())
	label_totalkillstext:SetPoint("TOPRIGHT", label_scoretext, "BOTTOMRIGHT", 0, 4)

	local label_totalkills = UI.CreateFrame("Text", "label_totalkills", zcontext.summaryframe)
	label_totalkills:SetFontSize(20)
	label_totalkills:SetText("0")
	label_totalkills:SetHeight(label_totalkills:GetFullHeight())
	label_totalkills:SetWidth(128)
	label_totalkills:SetPoint("TOPLEFT", label_totalkillstext, "TOPRIGHT", 6, 0)
	zcontext.label_totalkills = label_totalkills

	-- Unique Kills
	local label_uniquekillstext = UI.CreateFrame("Text", "label_uniquekillstext", zcontext.summaryframe)
	label_uniquekillstext:SetFontSize(20)
	label_uniquekillstext:SetText("Unique Kills:")
	label_uniquekillstext:SetHeight(label_uniquekillstext:GetFullHeight())
	label_uniquekillstext:SetWidth(label_uniquekillstext:GetFullWidth())
	label_uniquekillstext:SetPoint("TOPRIGHT", label_totalkillstext, "BOTTOMRIGHT", 0, 4)

	local label_uniquekills = UI.CreateFrame("Text", "label_uniquekills", zcontext.summaryframe)
	label_uniquekills:SetFontSize(20)
	label_uniquekills:SetText("0")
	label_uniquekills:SetHeight(label_uniquekills:GetFullHeight())
	label_uniquekills:SetWidth(128)
	label_uniquekills:SetPoint("TOPLEFT", label_uniquekillstext, "TOPRIGHT", 6, 0)
	zcontext.label_uniquekills = label_uniquekills

	-- Deaths
	local label_totaldeathstext = UI.CreateFrame("Text", "label_totalkillstext", zcontext.summaryframe)
	label_totaldeathstext:SetFontSize(20)
	label_totaldeathstext:SetText("Total Deaths:")
	label_totaldeathstext:SetHeight(label_totaldeathstext:GetFullHeight())
	label_totaldeathstext:SetWidth(label_totaldeathstext:GetFullWidth())
	label_totaldeathstext:SetPoint("TOPRIGHT", label_uniquekillstext, "BOTTOMRIGHT", 0, 4)

	local label_totaldeaths = UI.CreateFrame("Text", "label_totaldeaths", zcontext.summaryframe)
	label_totaldeaths:SetFontSize(20)
	label_totaldeaths:SetText("0")
	label_totaldeaths:SetHeight(label_totaldeaths:GetFullHeight())
	label_totaldeaths:SetWidth(128)
	label_totaldeaths:SetPoint("TOPLEFT", label_totaldeathstext, "TOPRIGHT", 6, 0)
	zcontext.label_totaldeaths = label_totaldeaths

	
	-- Most Killed
	local label_mostkilledtext = UI.CreateFrame("Text", "label_mostkilledtext", zcontext.summaryframe)
	label_mostkilledtext:SetFontSize(20)
	label_mostkilledtext:SetText("Most Killed:")
	label_mostkilledtext:SetHeight(label_mostkilledtext:GetFullHeight())
	label_mostkilledtext:SetWidth(label_mostkilledtext:GetFullWidth())
	label_mostkilledtext:SetPoint("TOPRIGHT", zcontext.summaryframe, "TOPCENTER", 110, 70)

	local label_mostkilled = UI.CreateFrame("Text", "label_mostkilledtext", zcontext.summaryframe)
	label_mostkilled:SetFontSize(20)
	label_mostkilled:SetText("")
	label_mostkilled:SetHeight(label_score:GetFullHeight())
	label_mostkilled:SetWidth(300)
	label_mostkilled:SetPoint("TOPLEFT", label_mostkilledtext, "TOPRIGHT", 6, 0)
	zcontext.label_mostkilled = label_mostkilled
	
	-- Most Deaths
	local label_mostdeathstext = UI.CreateFrame("Text", "label_mostdeathstext", zcontext.summaryframe)
	label_mostdeathstext:SetFontSize(20)
	label_mostdeathstext:SetText("Most Deaths by:")
	label_mostdeathstext:SetHeight(label_mostdeathstext:GetFullHeight())
	label_mostdeathstext:SetWidth(label_mostdeathstext:GetFullWidth())
	label_mostdeathstext:SetPoint("TOPRIGHT", label_mostkilledtext, "BOTTOMRIGHT", 0, 4)

	local label_mostdeaths = UI.CreateFrame("Text", "label_mostdeaths", zcontext.summaryframe)
	label_mostdeaths:SetFontSize(20)
	label_mostdeaths:SetText("")
	label_mostdeaths:SetHeight(label_mostdeaths:GetFullHeight())
	label_mostdeaths:SetWidth(300)
	label_mostdeaths:SetPoint("TOPLEFT", label_mostdeathstext, "TOPRIGHT", 6, 0)
	zcontext.label_mostdeaths = label_mostdeaths
	
	-- Last Kill
	local label_lastkilltext = UI.CreateFrame("Text", "label_lastkilltext", zcontext.summaryframe)
	label_lastkilltext:SetFontSize(20)
	label_lastkilltext:SetText("Last Kill:")
	label_lastkilltext:SetHeight(label_lastkilltext:GetFullHeight())
	label_lastkilltext:SetWidth(label_lastkilltext:GetFullWidth())
	label_lastkilltext:SetPoint("TOPRIGHT", label_mostdeathstext, "BOTTOMRIGHT", 0, 4)

	local label_lastkill = UI.CreateFrame("Text", "label_lastkill", zcontext.summaryframe)
	label_lastkill:SetFontSize(20)
	label_lastkill:SetText("")
	label_lastkill:SetHeight(label_lastkill:GetFullHeight())
	label_lastkill:SetWidth(300)
	label_lastkill:SetPoint("TOPLEFT", label_lastkilltext, "TOPRIGHT", 6, 0)
	zcontext.label_lastkill = label_lastkill
	
	-- Last Death
	local label_lastdeathtext = UI.CreateFrame("Text", "label_lastdeathtext", zcontext.summaryframe)
	label_lastdeathtext:SetFontSize(20)
	label_lastdeathtext:SetText("Last Death by:")
	label_lastdeathtext:SetHeight(label_lastdeathtext:GetFullHeight())
	label_lastdeathtext:SetWidth(label_lastdeathtext:GetFullWidth())
	label_lastdeathtext:SetPoint("TOPRIGHT", label_lastkilltext, "BOTTOMRIGHT", 0, 4)

	local label_lastdeath = UI.CreateFrame("Text", "label_lastdeath", zcontext.summaryframe)
	label_lastdeath:SetFontSize(20)
	label_lastdeath:SetText("")
	label_lastdeath:SetHeight(label_lastdeath:GetFullHeight())
	label_lastdeath:SetWidth(300)
	label_lastdeath:SetPoint("TOPLEFT", label_lastdeathtext, "TOPRIGHT", 6, 0)
	zcontext.label_lastdeath = label_lastdeath
	
	-- Kill to Death ratio
	local label_ktdtext = UI.CreateFrame("Text", "label_ktdtext", zcontext.summaryframe)
	label_ktdtext:SetFontSize(20)
	label_ktdtext:SetText("Kills vs Death:")
	label_ktdtext:SetHeight(label_ktdtext:GetFullHeight())
	label_ktdtext:SetWidth(label_ktdtext:GetFullWidth())
	label_ktdtext:SetPoint("TOPRIGHT", label_totaldeathstext, "BOTTOMRIGHT", 0, 4)

	local label_ktd = UI.CreateFrame("Text", "label_ktd", zcontext.summaryframe)
	label_ktd:SetFontSize(20)
	label_ktd:SetText("0:0")
	label_ktd:SetHeight(label_lastdeath:GetFullHeight())
	label_ktd:SetWidth(300)
	label_ktd:SetPoint("TOPLEFT", label_ktdtext, "TOPRIGHT", 6, 0)
	zcontext.label_ktd = label_ktd
	
	
	-- Start Date of Book
	
	
end

-- ****************************************************************************

function CreateConfigFrame()

	-- Create the Config Frame
	zcontext.configframe = UI.CreateFrame("Frame", "bookframe", zcontext.window)
	zcontext.configframe:SetPoint("TOPLEFT", zcontext.window, "TOPLEFT", 40, 70)
	zcontext.configframe:SetWidth(zcontext.window:GetWidth() - (40 + 40))
	zcontext.configframe:SetHeight(zcontext.window:GetHeight() - (70 + 70))
	zcontext.configframe:SetVisible(false)

	-- Title
	local label_title = UI.CreateFrame("Text", "label_title", zcontext.configframe)
	label_title:SetFontSize(26)
	label_title:SetText("Configuration")
	label_title:SetHeight(label_title:GetFullHeight())
	label_title:SetWidth(label_title:GetFullWidth())
	label_title:SetPoint("CENTERTOP", zcontext.configframe, "CENTERTOP", 0, 0)
	
	-- Checkbox for Record NPCs
	local check = UI.CreateFrame("RiftCheckbox", "Checkbox_recordmobs", zcontext.configframe)
	check:SetWidth(26)
	check:SetHeight(26)
	check:SetPoint("TOPLEFT", zcontext.configframe, "TOPLEFT", 0,70)
	check:SetChecked(zcontext.recordmobs)

	local label = UI.CreateFrame("Text", "label_recordmobs", zcontext.configframe)
	label:SetFontSize(20)
	label:SetText("Record NPCs")
	label:SetHeight(label:GetFullHeight())
	label:SetWidth(128)
	label:SetPoint("CENTERLEFT", check, "CENTERRIGHT", 0, 0)
	
	function check.Event:CheckboxChange()
		zcontext.recordmobs = check:GetChecked()
	end
	
end

-- ****************************************************************************

function CreateBookFrame()

	-- Create the Book Frame
	zcontext.bookframe = UI.CreateFrame("Frame", "bookframe", zcontext.window)
	zcontext.bookframe:SetPoint("TOPLEFT", zcontext.window, "TOPLEFT", 40, 70)
	zcontext.bookframe:SetWidth(zcontext.window:GetWidth() - (40 + 40))
	zcontext.bookframe:SetHeight(zcontext.window:GetHeight() - (70 + 70))
	zcontext.bookframe:SetVisible(false)

	-- Title
	local label_title = UI.CreateFrame("Text", "label_title", zcontext.bookframe)
	label_title:SetFontSize(28)
	label_title:SetText("The Book of Death")
	label_title:SetHeight(label_title:GetFullHeight())
	label_title:SetWidth(label_title:GetFullWidth())
	label_title:SetPoint("CENTERTOP", zcontext.bookframe, "CENTERTOP", 0, 0)

	-- Headers - Name
	local label_holder, first, last
	label = UI.CreateFrame("Text", "label_book_header:name", zcontext.bookframe)
	label:SetFontSize(24)
	label:SetText("Name")
	label:SetHeight(label:GetFullHeight())
	label:SetWidth(200)
	label:SetPoint("TOPLEFT", zcontext.bookframe, "TOPLEFT", 25, 55)
	-- label:SetBackgroundColor(0,0,1, 1)
	label_holder = label
	first = label
	
	function label.Event:LeftClick()
		zcontext.sortby = "name"
		if (zcontext.sortdirection == "ascending") then
			zcontext.sortdirection = "descending"
		else
			zcontext.sortdirection = "ascending"
		end
		Dump()
	end	
	
	
	-- Headers - Calling
	label = UI.CreateFrame("Text", "label_book_header:calling", zcontext.bookframe)
	label:SetFontSize(24)
	label:SetText("Calling")
	label:SetHeight(label:GetFullHeight())
	label:SetWidth(100)
	label:SetPoint("TOPLEFT", label_holder, "TOPRIGHT", 4, 0)
	-- label:SetBackgroundColor(0,0,1, 1)
	label_holder = label

	function label.Event:LeftClick()
		zcontext.sortby = "calling"
		if (zcontext.sortdirection == "ascending") then
			zcontext.sortdirection = "descending"
		else
			zcontext.sortdirection = "ascending"
		end
		Dump()
	end	

	
	-- Headers - Kills
	label = UI.CreateFrame("Text", "label_book_header:kills", zcontext.bookframe)
	label:SetFontSize(24)
	label:SetText("Kills")
	label:SetHeight(label:GetFullHeight())
	label:SetWidth(70)
	label:SetPoint("TOPLEFT", label_holder, "TOPRIGHT", 4, 0)
	-- label:SetBackgroundColor(0,0,1, 1)
	label_holder = label
	
	function label.Event:LeftClick()
		zcontext.sortby = "kills"
		if (zcontext.sortdirection == "ascending") then
			zcontext.sortdirection = "descending"
		else
			zcontext.sortdirection = "ascending"
		end
		Dump()
	end	
	
	
	-- Headers - Deaths
	label = UI.CreateFrame("Text", "label_book_header:deaths", zcontext.bookframe)
	label:SetFontSize(24)
	label:SetText("Death")
	label:SetHeight(label:GetFullHeight())
	label:SetWidth(70)
	label:SetPoint("TOPLEFT", label_holder, "TOPRIGHT", 4, 0)
	-- label:SetBackgroundColor(0,0,1, 1)
	label_holder = label

	function label.Event:LeftClick()
		zcontext.sortby = "deaths"
		if (zcontext.sortdirection == "ascending") then
			zcontext.sortdirection = "descending"
		else
			zcontext.sortdirection = "ascending"
		end
		Dump()
	end	
	
	
	-- Headers - Score
	label = UI.CreateFrame("Text", "label_book_header:score", zcontext.bookframe)
	label:SetFontSize(24)
	label:SetText("Score")
	label:SetHeight(label:GetFullHeight())
	label:SetWidth(70)
	label:SetPoint("TOPLEFT", label_holder, "TOPRIGHT", 4, 0)
	-- label:SetBackgroundColor(0,0,1, 1)
	label_holder = label
	last = label
	
	function label.Event:LeftClick()
		zcontext.sortby = "score"
		if (zcontext.sortdirection == "ascending") then
			zcontext.sortdirection = "descending"
		else
			zcontext.sortdirection = "ascending"
		end
		Dump()
	end	
	
	
	-- Spacer
	local spacer = UI.CreateFrame("Frame", "label_book_header:name", zcontext.bookframe)
	spacer:SetHeight(2)
	spacer:SetPoint("TOPLEFT", first, "BOTTOMLEFT", 0, 4)
	spacer:SetPoint("TOPRIGHT", last, "BOTTOMRIGHT", 0, 4)
	spacer:SetBackgroundColor(1,1,1, 1)
	
	
	-- List of label entries for the book
	local label
	local fontsize = 20
	local rowspacing = 32
	for i = 1, 10, 1 do

		zcontext.label_book[i] = {}

		-- Name
		label = UI.CreateFrame("Text", "label_book:name", zcontext.bookframe)
		label:SetFontSize(fontsize)
		label:SetText(" ")
		label:SetHeight(label:GetFullHeight())
		label:SetWidth(200)
		label:SetPoint("TOPLEFT", zcontext.summaryframe, "TOPLEFT", 25, 69 + i*rowspacing)
		-- label:SetBackgroundColor(0,0,1, 1)
		zcontext.label_book[i].name = label

		-- Calling
		label = UI.CreateFrame("Text", "label_book:calling", zcontext.bookframe)
		label:SetFontSize(fontsize)
		label:SetText(" ")
		label:SetHeight(label:GetFullHeight())
		label:SetWidth(100)
		label:SetPoint("TOPLEFT", zcontext.label_book[i].name, "TOPRIGHT", 4, 0)
		-- label:SetBackgroundColor(0,0,1, 1)
		zcontext.label_book[i].calling = label
		
		-- Kills
		label = UI.CreateFrame("Text", "label_book:kills", zcontext.bookframe)
		label:SetFontSize(fontsize)
		label:SetText(" ")
		label:SetHeight(label:GetFullHeight())
		label:SetWidth(70)
		label:SetPoint("TOPLEFT", zcontext.label_book[i].calling, "TOPRIGHT", 4, 0)
		-- label:SetBackgroundColor(0,0,1, 1)
		zcontext.label_book[i].kills = label
		
		-- Deaths
		label = UI.CreateFrame("Text", "label_book:deaths", zcontext.bookframe)
		label:SetFontSize(fontsize)
		label:SetText(" ")
		label:SetHeight(label:GetFullHeight())
		label:SetWidth(70)
		label:SetPoint("TOPLEFT", zcontext.label_book[i].kills, "TOPRIGHT", 4, 0)
		-- label:SetBackgroundColor(0,0,1, 1)
		zcontext.label_book[i].deaths = label
		
		-- Score
		label = UI.CreateFrame("Text", "label_book:score", zcontext.bookframe)
		label:SetFontSize(fontsize)
		label:SetText(" ")
		label:SetHeight(label:GetFullHeight())
		label:SetWidth(70)
		label:SetPoint("TOPLEFT", zcontext.label_book[i].deaths, "TOPRIGHT", 4, 0)
		-- label:SetBackgroundColor(0,0,1, 1)
		zcontext.label_book[i].score = label
		
	end
	

	-- Last Page button
	local button_lastpage = UI.CreateFrame("RiftButton", "lastpage", zcontext.bookframe)
	button_lastpage:SetWidth(50)
	button_lastpage:SetText(">>")
	button_lastpage:SetPoint("TOPRIGHT", zcontext.label_book[10].score, "BOTTOMRIGHT", 0, 12)

	function button_lastpage.Event:LeftPress()
		local tablesize = 0
		for id,v in pairs(zcontext.deathlist) do
			tablesize = tablesize + 1
		end

		local lastpage = math.ceil(tablesize / 10) - 1
		zcontext.book_currentpage = lastpage
		Dump()
	end	

	-- Next Page button
	local button_nextpage = UI.CreateFrame("RiftButton", "nextpage", zcontext.bookframe)
	button_nextpage:SetWidth(50)
	button_nextpage:SetText(">")
	button_nextpage:SetPoint("TOPRIGHT", button_lastpage, "TOPLEFT", -4, 0)

	function button_nextpage.Event:LeftPress()
		local tablesize = 0
		for id,v in pairs(zcontext.deathlist) do
			tablesize = tablesize + 1
		end
		
		if ( ((zcontext.book_currentpage+1)*10) < tablesize ) then
			zcontext.book_currentpage = zcontext.book_currentpage + 1
		end
		Dump()
	end	
	
	-- First Page button
	local button_firstpage = UI.CreateFrame("RiftButton", "firstpage", zcontext.bookframe)
	button_firstpage:SetWidth(50)
	button_firstpage:SetText("<<")
	button_firstpage:SetPoint("TOPLEFT", zcontext.label_book[10].name, "BOTTOMLEFT", 0, 12)

	function button_firstpage.Event:LeftPress()
		zcontext.book_currentpage = 0
		Dump()
	end	
	
	-- Previous Page button
	local button_previouspage = UI.CreateFrame("RiftButton", "previouspage", zcontext.bookframe)
	button_previouspage:SetWidth(50)
	button_previouspage:SetText("<")
	button_previouspage:SetPoint("TOPLEFT", button_firstpage, "TOPRIGHT", 4, 0)

	function button_previouspage.Event:LeftPress()
		if (zcontext.book_currentpage > 0) then
			zcontext.book_currentpage = zcontext.book_currentpage - 1;
		end
		Dump()
	end	
	
	-- Page # / # display
	local label_page = UI.CreateFrame("Text", "label_pages:name", zcontext.bookframe)
	label_page:SetFontSize(18)
	label_page:SetText("( #/# )")
	label_page:SetHeight(label_page:GetFullHeight())
	label_page:SetWidth(label_page:GetFullWidth())
	label_page:SetPoint("XCENTER", zcontext.bookframe, "XCENTER")
	label_page:SetPoint("YCENTER", button_previouspage, "YCENTER")
	zcontext.label_pages = label_page
	
end

-- ****************************************************************************

function SetCurrentPageNum(number, maxpage)
	
	if (zcontext.label_pages ~= nil) then
	zcontext.label_pages:SetText("( " .. number .. "/" .. maxpage .. " )")
		zcontext.label_pages:SetWidth(zcontext.label_pages:GetFullWidth())
	end
	
end

-- ****************************************************************************

function SetTextWithColor(text, r,g,b,a)

	zcontext.textframe:SetText(text)
	zcontext.textframe:SetHeight(zcontext.textframe:GetFullHeight())
	zcontext.textframe:SetWidth(zcontext.textframe:GetFullWidth())
	zcontext.textframe:SetPoint("TOPCENTER", UIParent, "TOPCENTER")
	zcontext.textframe:SetFontColor(r,g,b, a)
	
	zcontext.textframe_timestamp = Inspect.Time.Frame()

end

-- ****************************************************************************

function SetText(text)

	SetTextWithColor(text, 1,1,1, 1)

end

-- ****************************************************************************

function CalculateTotalScore()

	local score = 0
	for id,v in pairs(zcontext.deathlist) do
		score = score + v.score
	end

	return(score)
end

-- ****************************************************************************

function UpdateTotalScore()

	local score = "" .. CalculateTotalScore()
	zcontext.label_score:SetText(score)

end

-- ****************************************************************************

function CalculateTotalKills()

	local kills = 0
	for id,v in pairs(zcontext.deathlist) do
		kills = kills + v.kills
	end

	return(kills)
end

-- ****************************************************************************

function UpdateTotalKills()

	local kills = "" .. CalculateTotalKills()
	zcontext.label_totalkills:SetText(kills)

end

-- ****************************************************************************

function CalculateUniqueKills()

	local kills = 0
	for id,v in pairs(zcontext.deathlist) do
		if (v.kills > 0) then
			kills = kills + 1
		end
	end

	return(kills)
end

-- ****************************************************************************

function UpdateUniqueKills()

	local kills = "" .. CalculateUniqueKills()
	zcontext.label_uniquekills:SetText(kills)

end

-- ****************************************************************************

function CalculateTotalDeaths()

	local deaths = 0
	for id,v in pairs(zcontext.deathlist) do
		deaths = deaths + v.deaths
	end

	return(deaths)
end

-- ****************************************************************************

function UpdateTotalDeaths()

	local deaths = "" .. CalculateTotalDeaths()
	zcontext.label_totaldeaths:SetText(deaths)

end

-- ****************************************************************************

function CalculateMostKilled()

	local mostkilled = ""
	local kills = -1

	for id,v in pairs(zcontext.deathlist) do
		if (v.kills > kills) then
			kills = v.kills
			mostkilled = v.name
		end
	end

	return(mostkilled)
end

-- ****************************************************************************

function UpdateMostKilled()

	local mostkilled = CalculateMostKilled()
	zcontext.label_mostkilled:SetText(mostkilled)

end

-- ****************************************************************************

function CalculateMostDeaths()

	local mostdeaths = ""
	local deaths = -1

	for id,v in pairs(zcontext.deathlist) do
		if (v.deaths > deaths) then
			deaths = v.deaths
			mostdeaths = v.name
		end
	end

	return(mostdeaths)
end

-- ****************************************************************************

function UpdateMostDeaths()

	local mostdeaths = CalculateMostDeaths()
	zcontext.label_mostdeaths:SetText(mostdeaths)

end

-- ****************************************************************************

function UpdateLastKill()

	if (zcontext.lastkill) then
		zcontext.label_lastkill:SetText(zcontext.lastkill)
	end

end

-- ****************************************************************************

function UpdateLastDeath()

	if (zcontext.lastdeath) then
		zcontext.label_lastdeath:SetText(zcontext.lastdeath)
	end

end

-- ****************************************************************************

function UpdateKTD()

	local kills = CalculateTotalKills()
	local deaths = CalculateTotalDeaths()
	local ktdratio = ""
	
	-- Special case: Kills == 0 and Deaths == 0
	if ((kills == 0) and (deaths == 0)) then
		ktd = "---"
	-- Special case: Kills == 0 and Deaths > 0
	elseif ((kills == 0) and (deaths > 0)) then
		ktd = "-Infinity"
	-- Special case: Kills > 0 and Deaths == 0
	elseif ((kills > 0) and (deaths == 0)) then
		ktd = "+Infinity"
	-- Special case: Kills == Deaths
	elseif (kills == deaths) then
		ktd = "1:1"
	-- Special case: Kills > Deaths
	elseif (kills > deaths) then
		local myratio = math.floor(kills / deaths)
		ktd = tostring(myratio) .. ":1"
	-- Special case: Kills < Deaths
	elseif (kills < deaths) then
		local myratio = math.floor(deaths / kills)
		ktd = "1:" .. tostring(myratio)
	end
	
	zcontext.label_ktd:SetText(ktd)

end

-- ****************************************************************************

function UpdateSummary()

	UpdateTotalScore()
	UpdateTotalKills()
	UpdateUniqueKills()
	UpdateTotalDeaths()
	
	UpdateMostKilled()
	UpdateMostDeaths()
	
	UpdateLastKill()
	UpdateLastDeath()

	UpdateKTD()

end

-- ****************************************************************************
