-- ****************************************************************************

function SortBook(t)

	-- Based on score
	if (zcontext.sortby == "score") then
		if (zcontext.sortdirection == "descending") then
			SortByHighestScore(t)
		else		
			SortByLowestScore(t)
		end
	-- Based on Deaths
	elseif (zcontext.sortby == "deaths") then
		if (zcontext.sortdirection == "descending") then
			SortByHighestDeaths(t)
		else		
			SortByLowestDeaths(t)
		end
	-- Based on Kills
	elseif (zcontext.sortby == "kills") then
		if (zcontext.sortdirection == "descending") then
			SortByHighestKills(t)
		else		
			SortByLowestKills(t)
		end
	-- Based on Calling
	elseif (zcontext.sortby == "calling") then
		if (zcontext.sortdirection == "descending") then
			SortByHighestCalling(t)
		else		
			SortByLowestCalling(t)
		end
	-- Based on Name
	elseif (zcontext.sortby == "name") then
		if (zcontext.sortdirection == "descending") then
			SortByHighestName(t)
		else		
			SortByLowestName(t)
		end
	end

end

-- ****************************************************************************

function SortByHighestScore(t)

	table.sort(t, 
	
		function(lhs,rhs) 
			local retval = false
			local lhs_value = zcontext.deathlist[lhs].score
			local rhs_value = zcontext.deathlist[rhs].score
			
			if (lhs_value > rhs_value) then 
				retval = true 
			elseif (lhs_value == rhs_value) then
				local lhs_name = zcontext.deathlist[lhs].name
				local rhs_name = zcontext.deathlist[rhs].name
				if (lhs_name < rhs_name) then 
					retval = true
				end
			end

			return(retval) 
		end
	)

end

-- ****************************************************************************

function SortByLowestScore(t)

	table.sort(t, 
	
		function(lhs,rhs) 
			local retval = false
			local lhs_value = zcontext.deathlist[lhs].score
			local rhs_value = zcontext.deathlist[rhs].score
			
			if (lhs_value < rhs_value) then 
				retval = true 
			elseif (lhs_value == rhs_value) then
				local lhs_name = zcontext.deathlist[lhs].name
				local rhs_name = zcontext.deathlist[rhs].name
				if (lhs_name < rhs_name) then 
					retval = true
				end
			end

			return(retval) 
		end
	)
	
end

-- ****************************************************************************

function SortByHighestDeaths(t)

	table.sort(t, 
	
		function(lhs,rhs) 
			local retval = false
			local lhs_value = zcontext.deathlist[lhs].deaths
			local rhs_value = zcontext.deathlist[rhs].deaths
			
			if (lhs_value > rhs_value) then 
				retval = true 
			elseif (lhs_value == rhs_value) then
				local lhs_name = zcontext.deathlist[lhs].name
				local rhs_name = zcontext.deathlist[rhs].name
				if (lhs_name < rhs_name) then 
					retval = true
				end
			end

			return(retval) 
		end
	)

end

-- ****************************************************************************

function SortByLowestDeaths(t)

	table.sort(t, 
	
		function(lhs,rhs) 
			local retval = false
			local lhs_value = zcontext.deathlist[lhs].deaths
			local rhs_value = zcontext.deathlist[rhs].deaths
			
			if (lhs_value < rhs_value) then 
				retval = true 
			elseif (lhs_value == rhs_value) then
				local lhs_name = zcontext.deathlist[lhs].name
				local rhs_name = zcontext.deathlist[rhs].name
				if (lhs_name < rhs_name) then 
					retval = true
				end
			end

			return(retval) 
		end
	)
	
end

-- ****************************************************************************

function SortByHighestKills(t)

	table.sort(t, 
	
		function(lhs,rhs) 
			local retval = false
			local lhs_value = zcontext.deathlist[lhs].kills
			local rhs_value = zcontext.deathlist[rhs].kills
			
			if (lhs_value > rhs_value) then 
				retval = true 
			elseif (lhs_value == rhs_value) then
				local lhs_name = zcontext.deathlist[lhs].name
				local rhs_name = zcontext.deathlist[rhs].name
				if (lhs_name < rhs_name) then 
					retval = true
				end
			end

			return(retval) 
		end
	)

end

-- ****************************************************************************

function SortByLowestKills(t)

	table.sort(t, 
	
		function(lhs,rhs) 
			local retval = false
			local lhs_value = zcontext.deathlist[lhs].kills
			local rhs_value = zcontext.deathlist[rhs].kills
			
			if (lhs_value < rhs_value) then 
				retval = true 
			elseif (lhs_value == rhs_value) then
				local lhs_name = zcontext.deathlist[lhs].name
				local rhs_name = zcontext.deathlist[rhs].name
				if (lhs_name < rhs_name) then 
					retval = true
				end
			end

			return(retval) 
		end
	)
	
end

-- ****************************************************************************

function SortByHighestCalling(t)

	table.sort(t, 
	
		function(lhs,rhs) 
			local retval = false
			local lhs_value = zcontext.deathlist[lhs].calling
			local rhs_value = zcontext.deathlist[rhs].calling
			
			if (lhs_value > rhs_value) then 
				retval = true 
			elseif (lhs_value == rhs_value) then
				local lhs_name = zcontext.deathlist[lhs].name
				local rhs_name = zcontext.deathlist[rhs].name
				if (lhs_name < rhs_name) then 
					retval = true
				end
			end

			return(retval) 
		end
	)

end

-- ****************************************************************************

function SortByLowestCalling(t)

	table.sort(t, 
	
		function(lhs,rhs) 
			local retval = false
			local lhs_value = zcontext.deathlist[lhs].calling
			local rhs_value = zcontext.deathlist[rhs].calling
			
			if (lhs_value < rhs_value) then 
				retval = true 
			elseif (lhs_value == rhs_value) then
				local lhs_name = zcontext.deathlist[lhs].name
				local rhs_name = zcontext.deathlist[rhs].name
				if (lhs_name < rhs_name) then 
					retval = true
				end
			end

			return(retval) 
		end
	)
	
end

-- ****************************************************************************

function SortByHighestName(t)

	table.sort(t, 
	
		function(lhs,rhs) 
			local retval = false
			local lhs_value = zcontext.deathlist[lhs].name
			local rhs_value = zcontext.deathlist[rhs].name
			
			if (lhs_value > rhs_value) then 
				retval = true 
			end

			return(retval) 
		end
	)

end

-- ****************************************************************************

function SortByLowestName(t)

	table.sort(t, 
	
		function(lhs,rhs) 
			local retval = false
			local lhs_value = zcontext.deathlist[lhs].name
			local rhs_value = zcontext.deathlist[rhs].name
			
			if (lhs_value < rhs_value) then 
				retval = true 
			end

			return(retval) 
		end
	)
	
end

-- ****************************************************************************
