local WhereAmIAddonData, PrivateTable = ...

if WhereAmI then
	print ("WhereAmI already loaded")
	return
end

WhereAmI = {
	version=WhereAmIAddonData.toc.Version
}

local shardName=nil
local lastQueried=0

local function systemUpdate(handle)
	local now=Inspect.Time.Server()
	if shardName==nil or now > lastQueried+5 then
		lastQueried=now
		local player=Inspect.Unit.Detail("player")
		if not player.zone then return end
		local zone=Inspect.Zone.Detail(player.zone)
		if not zone.name then return end

		local newShardName
		local consoles=Inspect.Console.List()
		for cid, flag in pairs(consoles) do
			-- print ("cid=="..cid)
			local console=Inspect.Console.Detail(cid)
			-- dump(console)
			if console.channel then
				for cname, flag in pairs(console.channel) do
					if cname == zone.name then
						-- we are in the zone channel of our home server
						local shard=Inspect.Shard()
						newShardName=shard and shard.name
					elseif (cname:sub(1, zone.name:len()+1) == zone.name.."@") then
						-- we are in a "zone@server" channel
						newShardName=cname:sub(zone.name:len()+2)
					end
				end
			end
		end
		if newShardName and newShardName ~= shardName then
			WhereAmI.setShard(newShardName)
			shardName=newShardName
		end
		return
	end
end

function WhereAmI.printVersion()
	LibVersionCheck.register("WhereAmI", WhereAmI.version)
	print("WhereAmI Version " .. (WhereAmI.version) .. " installed!")
end

local function slashHandler(h, args)
	local r = {}
	local numargs = 1
	local inquote = false
	local token, tmptoken
	for token in string.gmatch(args, "[^%s]+") do
		if token:sub(1, 1) == "\"" then
			tmptoken=""
			token=token:sub(2) -- handle "abc" case
			inquote=true
		end
		if inquote then
			if token:sub(-1) == "\"" then
				inquote=false
				token=token:sub(1, -2)
				token=tmptoken .. token
			else
				tmptoken=tmptoken .. token .. " "
			end
		end
		if not inquote then
			r[numargs] = token
			numargs=numargs+1
		end
	end
	if numargs>1 then
		if r[1] == "version" then
			WhereAmI.printVersion()
		elseif r[1] == "hide" then
			WhereAmI.hide()
		elseif r[1] == "show" then
			WhereAmI.show()
		elseif r[1] == "left" then
			WhereAmIConfig.position="left"
			WhereAmI.attachLeft()
		elseif r[1] == "right" then
			WhereAmIConfig.position="right"
			WhereAmI.attachRight()
		else
			print("Usage: /wai version | hide | show | left | right")
		end
	else
		print("Usage: /wai version | hide | show | left | right")
	end
end

local function varsLoaded(handle, addon) 
	if (addon == "WhereAmI") then
		if not WhereAmIConfig then WhereAmIConfig={ position = left } end
	end
end

local function addonLoaded(handle, addon) 
	if (addon == "WhereAmI") then
		WhereAmI.printVersion()
		WhereAmI.createUI()
		if WhereAmIConfig and WhereAmIConfig.position=="right" then
			WhereAmI.attachRight()
		end
	end
end

Command.Event.Attach(Command.Slash.Register("wai"),     	slashHandler, "Command.Slash.Register")
Command.Event.Attach(Event.System.Update.Begin, 		systemUpdate, "systemUpdate")
Command.Event.Attach(Event.Addon.Load.End, 			addonLoaded,  "AddonLoaded" )
Command.Event.Attach(Event.Addon.SavedVariables.Load.End,	varsLoaded,  "VarsLoaded" )
