-- User Interface

local context

function WhereAmI.BuildMiniWindow()
	context=UI.CreateContext("WhereAmI")
	WhereAmI.miniWindow=UI.CreateFrame("Text", "WhereAmI", context)
	WhereAmI.miniWindow:SetPoint("TOPLEFT", UI.Native.MapMini, "TOPLEFT", 0, 0)
	WhereAmI.miniWindow:SetBackgroundColor(0, 0, 0, 0)
	WhereAmI.miniWindow:SetFontColor(1, 1, 1, 1)
	WhereAmI.miniWindow:SetFontSize(18)
	WhereAmI.miniWindow:SetText("");
end

function WhereAmI.setShard(text)
	if WhereAmI.miniWindow then WhereAmI.miniWindow:SetText(text) end
end

function WhereAmI.hide() 
	if WhereAmI.miniWindow then WhereAmI.miniWindow:SetVisible(false) end
end

function WhereAmI.show() 
	if WhereAmI.miniWindow then WhereAmI.miniWindow:SetVisible(true) end
end

function WhereAmI.attachLeft() 
	if WhereAmI.miniWindow then 
		WhereAmI.miniWindow:ClearAll()
		WhereAmI.miniWindow:SetPoint("TOPLEFT", UI.Native.MapMini, "TOPLEFT", 0, 0)
	end
end

function WhereAmI.attachRight() 
	if WhereAmI.miniWindow then 
		WhereAmI.miniWindow:ClearAll()
		WhereAmI.miniWindow:SetPoint("TOPRIGHT", UI.Native.MapMini, "TOPRIGHT", 0, 0)
	end
end

function WhereAmI.createUI()
	WhereAmI.BuildMiniWindow()
end
