local addon, data = ...

if not Library then Library = {} end
if not Library.LibInventory then Library.LibInventory = {} end

if not data._libInventory then data._libInventory = {} end
if not data._libInventoryAPI then data._libInventoryAPI = {} end

local LI = data._libInventory
local LA = data._libInventoryAPI

LA.CDCATEGORIES = {
	["consumable consumable"] = true,
	["consumable potion"] = true,
	["consumable enchantment"] = true,
	["misc"] = true,
	["misc other"] = true,
	["misc fishing"] = true,
}	

LA.items = {}
LA.slots = {}
LA.cooldowns = {}
LA.cditemtypes = {}
LA.activeCD = {}

LA.b_activeCD = false

local LIUPDATES = false
local LIUPDATE_DATA
local LIUPDATE_SLOTS

function Library.LibInventory.Cooldowns(cb)
	assert(type(cb) == "function")
	LA.cooldowns[cb] = true
end

function Library.LibInventory.GetItemInfo(it)
	local results = {}
	local pkey = nil
	for sn,_ in pairs(LIBINVENTORY_DATA) do
		for pn,_ in pairs(LIBINVENTORY_DATA[sn]) do
			if LIBINVENTORY_DATA[sn][pn][it] then
				if sn == data.sn and pn == data.pn then
					pkey = "PLAYER"
				else
					pkey = pn.."@"..sn
				end
				results[pkey] = {}
				for s,c in pairs(LIBINVENTORY_DATA[sn][pn][it]) do
					results[pkey][s] = c
				end
			end
		end
	end
	if pkey then
		return results
	else
		return nil
	end
end

function LA.QueueItemtypeUpdate(it)
	LIUPDATE_DATA[it] = true
	LIUPDATES = true
end

function LA.QueueSlotUpdate(s)
	LIUPDATE_SLOTS[s] = true
	LIUPDATES = true
end

function LA.SetupDone()
	LIUPDATE_DATA = {}
	LIUPDATE_SLOTS = {}
	for k,v in pairs(LA.items) do
		LA.QueueItemtypeUpdate(k)
	end
	for k,v in pairs(LA.slots) do
		LA.QueueSlotUpdate(k)
	end
	Command.Event.Attach(Event.System.Update.Begin, LA.Event_System_Update_Begin, "Event.System.Update.Begin")
end

-- Takes an item type
function Library.LibInventory.RegisterItem(it, cb)
	assert(type(cb) == "function")
	if LA.items[it] then
		table.insert(LA.items[it], cb)
	else
		LA.items[it] = { cb }
	end
end

function LA.handleSlotRegister(sl, cb)
	if LA.slots[sl] then
		table.insert(LA.slots[sl], cb)
	else
		LA.slots[sl] = { cb }
	end
end

-- Takes either a slot name, or a table where the key is a slot identifier
function Library.LibInventory.RegisterSlot(sl, cb)
	assert(type(cb) == "function")
	if type(sl) == "string" then
		LA.handleSlotRegister(sl, cb)
	elseif type(sl) == "table" then
		for s,_ in pairs(sl) do
			LA.handleSlotRegister(s, cb)
		end
	end
end

local lastCDcheck = 0

function LA.Event_System_Update_Begin(h)
	local cbdata
	if LIUPDATES then
		cbdata = {}
		-- itemtype updates
		for it,_ in pairs(LIUPDATE_DATA) do
			local r = Library.LibInventory.GetItemInfo(it)
			if r then
				for _,fn in pairs(LA.items[it]) do
					if cbdata[fn] == nil then
						cbdata[fn] = {}
					end
					cbdata[fn][it] = r
				end
			end
			LIUPDATE_DATA[it] = nil
		end
		for k,v in pairs(cbdata) do
			--print(string.format("DISPATCH> %s", Utility.Serialize.Inline(v)))
			k(v)
		end
		
		-- slot updates
		cbdata = {}
		for sl,_ in pairs(LIUPDATE_SLOTS) do
			if LA.slots[sl] then
				for ix,fn in pairs(LA.slots[sl]) do
					if cbdata[fn] == nil then
						cbdata[fn] = {}
					end
					cbdata[fn][sl] = LI.invslots_dtl[sl] or "nil"
				end
			end
			LIUPDATE_SLOTS[sl] = nil
		end
		for k,v in pairs(cbdata) do
			k(v)
		end
		
		LIUPDATES = false
	end
	
	if LA.b_activeCD then
		local cddata = {}
		for k,v in pairs(LA.activeCD) do
			cddata[k] = { endtime = v, slots = Library.LibInventory.GetItemInfo(k)["PLAYER"] }
		end
		for k,v in pairs(LA.cooldowns) do
			k(cddata)
		end
		LA.b_activeCD = nil
	end
	
	local tx = Inspect.Time.Real()
	local cdChange = false
	
	if Inspect.System.Watchdog() > 0.05 and (tx-lastCDcheck > 0.2) then
		local d = Inspect.Item.Detail(LA.cditemtypes)
		for k,v in pairs(d) do
			if v.cooldownBegin and LA.activeCD[k] == nil then
				if v.cooldownRemaining >= 2 then
					LA.activeCD[k] = v.cooldownBegin + v.cooldownDuration
					LA.b_activeCD = true
					--print(string.format("%s [%s] gone onto cooldown.", v.name, k))
				end
			elseif LA.activeCD[k] and v.cooldownBegin == nil then
				LA.activeCD[k] = nil
				--print(string.format("%s [%s] no longer on cooldown.", v.name, k))
			end
		end
		for k,v in pairs(LA.activeCD) do
			if d[k] == nil then
				LA.activeCD[k] = nil
				--print(string.format("[%s] no longer have this item.", k))				
			end
		end
		lastCDcheck = tx
	end
end

--/script local a,b = Inspect.Tooltip() dump(Library.LibInventory.GetItemInfo(Inspect.Item.Detail(b).type))
