local addon, data = ...

if not Library then Library = {} end
if not Library.LibInventory then Library.LibInventory = {} end

Library.LibInventory.ITEMTYPE_NAME={}
Library.LibInventory.REFSLOTS = {
	["bank"] = {},
	["bankbag"] = {},
	["inventory"] = {},
	["inventorybag"] = {},
	["quest"] = {},
	["bankmain"] = {},
}

for b=1,10 do
	Library.LibInventory.REFSLOTS["bankbag"][Utility.Item.Slot.Bank("bag", b)] = true
	Library.LibInventory.REFSLOTS["inventorybag"][Utility.Item.Slot.Inventory("bag", b)] = true
	for s=1,40 do
		Library.LibInventory.REFSLOTS["bank"][Utility.Item.Slot.Bank(b,s)] = true
		Library.LibInventory.REFSLOTS["inventory"][Utility.Item.Slot.Inventory(b,s)] = true
		if b==1 then
			Library.LibInventory.REFSLOTS["quest"][Utility.Item.Slot.Quest(s)] = true
			Library.LibInventory.REFSLOTS["bankmain"][Utility.Item.Slot.Bank("main", s)] = true
		end
	end
end

if not data._libInventory then data._libInventory = {} end
if not data._libInventoryAPI then data._libInventoryAPI = {} end

local LI = data._libInventory
local LA = data._libInventoryAPI

local INVSCAN = false
local SLTUPDT = {}
local TYPUPDT = {}

local scanned = false
local coroDead = false

LI.invslots_use = {}		-- ["si01.001"] = false; ["si01.001"] = i05508000032bba6c
LI.invslots_dtl = {}		-- ["si01.001"] = Inspect.Item.Detail(i05508000032bba6c)
LI.itemtype = {}

local function WATCHDOGWAIT(x)
	local rmx = Inspect.System.Watchdog()
	while rmx < 0.03 do
		--print("Watchdog yielding...")
		coroutine.yield()
		rmx = Inspect.System.Watchdog()
	end
end

function LI.Addon_SavedVariables_Load_End(h, a)
	if a == addon.identifier then
		data.sn = Inspect.Shard().name
		data.pn = Inspect.Unit.Detail("player").name
		if LIBINVENTORY_DATA == nil then LIBINVENTORY_DATA = {} end
		if LIBINVENTORY_DATA[data.sn] == nil then LIBINVENTORY_DATA[data.sn] = {} end
		LIBINVENTORY_DATA[data.sn][data.pn] = {}
	end
end

function LI.Event_Unit_Availability_Full(h,t)
	for k,v in pairs(t) do
		if v == "player" then
			Command.Event.Detach(Event.Unit.Availability.Full, nil, nil, nil, addon.identifier)
			INVSCAN = true
			Command.Event.Attach(Event.Item.Slot, LI.Event_Item_Slot, "Event.Item.Slot")
			Command.Event.Attach(Event.Item.Update, LI.Event_Item_Update, "Event.Item.Update")
--			LibVersionCheck.register(addon.toc.Identifier, addon.toc.Version)
		end
	end
end

function LI.Event_Item_Update(h, t)
	for k,v in pairs(t) do
		if Library.LibInventory.REFSLOTS["bankmain"][k] == nil then
			table.insert(SLTUPDT, 1, {e="EIU", s=k, a=v })
		end
	end
end

function LI.Event_Item_Slot(h, t)
	for k,v in pairs(t) do
		if Library.LibInventory.REFSLOTS["bankmain"][k] == nil then
			if LI.invslots_use[k] ~= v then
				table.insert(SLTUPDT, 1, {e="EIS", s=k, a=v })
			end
		end
	end
end

function LI.doInventoryScan()
	LIBINVENTORY_DATA[data.sn][data.pn] = {}
	for k,v in pairs(Inspect.Item.List()) do
		WATCHDOGWAIT("LI.doInventoryScan():slot:"..k)
		LI.invslots_use[k] = v
		if v then
			local d = Inspect.Item.Detail(k)
			LI.invslots_dtl[k] = d
			if LI.itemtype[d.type] == nil then
				LI.itemtype[d.type] = { count=0, slots={} }
			end
			if LIBINVENTORY_DATA[data.sn][data.pn][d.type] == nil then
				LIBINVENTORY_DATA[data.sn][data.pn][d.type] = {}
			end
			Library.LibInventory.ITEMTYPE_NAME[d.type] = d.name
			LIBINVENTORY_DATA[data.sn][data.pn][d.type][k] = d.stack or 1
			LI.itemtype[d.type].count = LI.itemtype[d.type].count + (d.stack or 1)
			LI.itemtype[d.type].slots[k] = true
			if LA.CDCATEGORIES[d.category] or d.cooldown or d.cooldownBegin then
				LA.cditemtypes[d.type] = d.name
				if d.cooldownBegin then
					LA.activeCD[d.type] = d.cooldownBegin + d.cooldownDuration
					LA.b_activeCD = true
				end
			end
		end
	end
end

function LI.handleSlotUpdates()
	for x=#SLTUPDT, 1, -1 do
		WATCHDOGWAIT("LI.handleSlotUpdates():"..x)
		local e = SLTUPDT[x].e
		local k = SLTUPDT[x].s
		local v = SLTUPDT[x].a

		if e == "EIS" then
			if v then
				if v == "nil" then
				else
					LI.invslots_use[k] = v
					local d = Inspect.Item.Detail(k)
					LI.invslots_dtl[k] = d
					if LI.itemtype[d.type] == nil then
						LI.itemtype[d.type] = { count=0, slots={} }
					end
					if LIBINVENTORY_DATA[data.sn][data.pn][d.type] == nil then
						LIBINVENTORY_DATA[data.sn][data.pn][d.type] = {}
					end
					Library.LibInventory.ITEMTYPE_NAME[d.type] = d.name
					LIBINVENTORY_DATA[data.sn][data.pn][d.type][k] = d.stack or 1
					LI.itemtype[d.type].slots[k] = true
					LA.activeCD[d.type] = nil
					table.insert(TYPUPDT, d.type)
				end
			else
				if LI.invslots_dtl[k] then
					LA.activeCD[LI.invslots_dtl[k].type] = nil
					if LI.invslots_use[k] then
						table.insert(TYPUPDT, LI.invslots_dtl[k].type)
					end
				end
				LI.invslots_dtl[k] = nil
				LI.invslots_use[k] = v
			end
		elseif e == "EIU" then
			local pit = LI.invslots_dtl[k].type
			local d = Inspect.Item.Detail(k)
			LI.invslots_dtl[k] = d
			if d then
				if d.type then
					table.insert(TYPUPDT, pit)
				end
				table.insert(TYPUPDT, d.type)
			end
		end
		if LA.slots[k] then
			LA.QueueSlotUpdate(k)
		end
		table.remove(SLTUPDT, x)
	end
	
	local chklist = {}
	
	for x=#TYPUPDT, 1, -1 do
		local it = TYPUPDT[x]
		if chklist[it] == nil then
			chklist[it] = true
			if LI.itemtype[it] then
				local count = 0
				for k,v in pairs(LI.itemtype[it].slots) do
					if LI.invslots_use[k] then
						if LI.invslots_dtl[k].type == it then
							count = count + (LI.invslots_dtl[k].stack or 1)
						else
							LI.itemtype[it].slots[k] = nil
							LIBINVENTORY_DATA[data.sn][data.pn][it][k] = nil
						end
					else
						LI.itemtype[it].slots[k] = nil
						LIBINVENTORY_DATA[data.sn][data.pn][it][k] = nil
					end
				end
				if LI.itemtype[it].count ~= count then
					LI.itemtype[it].count = count
				end
			else
				LI.itemtype[it] = {count=0, slots={}}
				LIBINVENTORY_DATA[data.sn][data.pn][it] = {}
			end
			if LA.items[it] then
				LA.QueueItemtypeUpdate(it)
			end
		end
		table.remove(TYPUPDT, x)
	end
end

function LI.coroEvent_System_Update_Begin()
	while true do
		if INVSCAN then
			LI.doInventoryScan()
			INVSCAN = false
			LA.SetupDone()
		elseif #SLTUPDT > 0 then
			LI.handleSlotUpdates()
		end
		coroutine.yield()
	end
end

LI.coUpdateHandler = coroutine.create(LI.coroEvent_System_Update_Begin)

function LI.Event_System_Update_Begin(h)
	if coroDead then return end
	local ok, errormsg = coroutine.resume(LI.coUpdateHandler)
	if not ok then
		coroDead = true
		error("Error in coroutine: "..errormsg)
	end
end

Command.Event.Attach(Event.System.Update.Begin, LI.Event_System_Update_Begin, "Event.System.Update.Begin")
Command.Event.Attach(Event.Unit.Availability.Full, LI.Event_Unit_Availability_Full, "Event.Unit.Availability.Full")
Command.Event.Attach(Event.Addon.SavedVariables.Load.End, LI.Addon_SavedVariables_Load_End, "Event.Addon.SavedVariables.Load.End")

print(string.format("v%s loaded.", addon.toc.Version))
