local _addoninfo, _mmData = ...
local _addon = _addoninfo.identifier

local ConfigUI = nil
local MM = nil
local mmUI = nil

local function CreateTable(_ds)
	_ret = {}
	
	for i, j in pairs(_ds) do
		table.insert(_ret, j[2])
	end
	
	return _ret
end

local function SetBorder(_frame, _rarity)
	if _rarity == "epic" then 
		_frame:SetBackgroundColor(.5, 0, 1, 1)
	elseif _rarity == "rare" then 
		_frame:SetBackgroundColor(0, 0, 1, 1) 
	elseif _rarity == "uncommon" then 
		_frame:SetBackgroundColor(0, 1, 0, 1) 
	elseif _rarity == "relic" then 
		_frame:SetBackgroundColor(1, .65, .13, 1) 
	else
		_frame:SetBackgroundColor(.6,.6,.6, .3) 
	end
end

local function LoadTexture(_frame, _type, _texture)
	local _lib = "Rift"
	if not _texture then 
		_texture = "images/".._type.."MeIcon.png" 
		_lib = "MountMe"
	end
	_frame:SetTexture(_lib, _texture)
end

local function LoadItems(_data, _frame, _dropped, _type)
	local _tbl = CreateTable(_data)
	_frame.List:SetItems(_tbl)
	if _dropped then return end
	
	_frame.Text1:SetText("Name")
	_frame.Text2:SetText("Description")
	LoadTexture(_frame.DragDrop, _type, "blank")
	SetBorder(_frame.DragDropBorder, "")
end

local function LoadGeneral()
	ConfigUI.Frame.General.LockUICB:SetChecked(MM.LockUI == true)
	ConfigUI.Frame.General.MountFirstCB:SetChecked(MM.MountFirst == true)
	ConfigUI.Frame.General.VerticleUICB:SetChecked(MM.VerticleUI == true)
	ConfigUI.Frame.General.ScaleUISlider:SetPosition(MM.ScaleUI)
	
	ConfigUI.Frame.General.ShowMountButtonCB:SetChecked(MM.Mounts.ShowUI == true)
	ConfigUI.Frame.General.AllowDuplicateMountCB:SetChecked(MM.Mounts.AllowDuplicates == true)
	ConfigUI.Frame.General.ForceUniqueMountSummonCB:SetChecked(MM.Mounts.UniqueSummon == true)
	ConfigUI.Frame.General.ShowMountTextCB:SetChecked(MM.Mounts.ShowText == true)
	ConfigUI.Frame.General.DisplayMountIconCB:SetChecked(MM.Mounts.DisplayIcon == true)
	
	ConfigUI.Frame.General.ShowPetButtonCB:SetChecked(MM.Pets.ShowUI == true)
	ConfigUI.Frame.General.AllowDuplicatePetCB:SetChecked(MM.Pets.AllowDuplicates == true)
	ConfigUI.Frame.General.ForceUniquePetSummonCB:SetChecked(MM.Pets.UniqueSummon == true)
	ConfigUI.Frame.General.ShowPetTextCB:SetChecked(MM.Pets.ShowText == true)
	ConfigUI.Frame.General.DisplayPetIconCB:SetChecked(MM.Pets.DisplayIcon == true)
	
	local x_Width = ConfigUI.Frame:GetWidth()
	local y_Height = ConfigUI.Frame:GetHeight()
	
	ConfigUI.Frame:ClearAll()
	ConfigUI.Frame:SetWidth(x_Width)
	ConfigUI.Frame:SetHeight(y_Height)
	ConfigUI.Frame:SetPoint("TOPLEFT", UIParent, "TOPLEFT", MM.Config_x, MM.Config_y)
end

local function DuplicateFound(_list, _val)
	local _ret = nil
	
	for i, j in pairs(_list) do
		if j[1] == _val then 
			_ret = j		
			break
		end
	end
	
	return _ret
end

local function MiscItem(_name)
	_ret = false
	
	if _name == "Shiny Lil' Trinket" then _ret = true end
	
	return _ret
end

local function DragDrop(_self, _type)
	local ty,hl = Inspect.Cursor()
	local id = nil
	local _frame = nil
	
	if _self.Override.Item and _self.Override.Value then 
		id = _self.Override.Item 
	elseif ty == "item" then 
		local _ok = nil
		_ok, id = pcall(Inspect.Item.Detail, hl)
		if not (_ok and id) then _ok, id = pcall(Inspect.Item.Detail, hl) end	
	end
	
	if 	id then
		--print("Type: ".._type.." - Cat: "..tostring(id.category).." - Override: "..tostring(_self.Override.Value))
		if id.category == "misc ".._type or _self.Override.Value then 
			local _frame = nil
			local _info = nil
			if _type == "mount" then _info = DuplicateFound(MM.Mounts.List, id.id) elseif _type == "pet" then _info = DuplicateFound(MM.Pets.List, id.id) end
			if _type == "mount" and ((MM.Mounts.AllowDuplicates) or (not MM.Mounts.AllowDuplicates and not _info)) then		
				table.insert(MM.Mounts.List, {id.id, id.name, id.description, id.rarity, id.icon})
				LoadItems(MM.Mounts.List, ConfigUI.Frame.Mounts, true, "mount")
				SetBorder(ConfigUI.Frame.Mounts.DragDropBorder, id.rarity)
			elseif _type == "pet" and ((MM.Pets.AllowDuplicates) or (not MM.Pets.AllowDuplicates and not _info)) then
				id.description = string.format("Summons a %s pet.", id.name)
				table.insert(MM.Pets.List, {id.id, id.name, id.description, id.rarity, id.icon})
				LoadItems(MM.Pets.List, ConfigUI.Frame.Pets, true, "pet")
				SetBorder(ConfigUI.Frame.Pets.DragDropBorder, id.rarity)
			elseif _type == "mount" then
				print("Mount is already in your stables.")
			elseif _type == "pet" then
				print("Pet is already safely in its cage.")
			end
			_frame = (_type == "mount" and ConfigUI.Frame.Mounts or ConfigUI.Frame.Pets)
			if not _info then
				_frame.Text1:SetText(string.format("Name - %s", id.name))
				_frame.Text2:SetText(string.format("Description - %s", id.description))
				LoadTexture(_frame.DragDrop, _type, id.icon)	
				SetBorder(_frame.DragDropBorder, id.rarity)
			else
				_frame.Text1:SetText("Name - "..tostring(_info[2]))
				_frame.Text2:SetText("Description - "..tostring(_info[3]))
				LoadTexture(_frame.DragDrop, _type, tostring(_info[5]))
				SetBorder(_frame.DragDropBorder, tostring(_info[4]))
			end
			_self.Override:SetVisible(false)
			_self.Override.Value = false
			_self.Override.Item = nil
		else
			_frame = (_type == "mount" and ConfigUI.Frame.Mounts or ConfigUI.Frame.Pets)		
			LoadTexture(_frame.DragDrop, _type, id.icon)
			_self.Override:SetVisible(true)
			_self.Override.Value = false
			_self.Override.Item = id
		end
	else
		print("Could not load Trion resource.  Please try again.")
	end
	Command.Cursor(nil)
end

local function DeleteItemFromList(_data, _frame)
	if not _frame.List:GetSelectedIndex() then return end
	table.remove(_data, _frame.List:GetSelectedIndex())
end

local function LoadItemFromList(_data, _frame, _type)
	if not _frame.List:GetSelectedIndex() then return end
	local _rec = _data[_frame.List:GetSelectedIndex()]
	_frame.Text1:SetText("Name - "..tostring(_rec[2]))
	_frame.Text2:SetText("Description - "..tostring(_rec[3]))
	LoadTexture(_frame.DragDrop, _type, tostring(_rec[5]))
	SetBorder(_frame.DragDropBorder, tostring(_rec[4]))
end

local function BuildConfigUIGeneral(_tab)
	local _retGeneral = {}

	local LockUICBChange = function()
		MM.LockUI = ConfigUI.Frame.General.LockUICB:GetChecked()
	end

	local MountFirstCBChange = function()
		if mmUI.SystemLocked then mmUI.Main.dirty = true end
		MM.MountFirst = ConfigUI.Frame.General.MountFirstCB:GetChecked()
		mmUI.Main:DrawButtons()
	end
	
	local VerticleUICBChange = function()
		if mmUI.SystemLocked then mmUI.Main.dirty = true end
		MM.VerticleUI = ConfigUI.Frame.General.VerticleUICB:GetChecked()
		mmUI.Main:DrawButtons()
	end
	
	local ScaleUISliderChange = function()
		if mmUI.SystemLocked then mmUI.Main.dirty = true end
		MM.ScaleUI = tonumber(ConfigUI.Frame.General.ScaleUISlider:GetPosition())
		ConfigUI.Frame.General.ScaleUISliderValue:SetText(tostring(MM.ScaleUI).."%")
		mmUI.Main:DrawButtons()
	end
	
	local ShowMountButtonCBChange = function()
		MM.Mounts.ShowUI = ConfigUI.Frame.General.ShowMountButtonCB:GetChecked()
		mmUI.Main:ToggleButton("mount", MM.Mounts.ShowUI)
	end
	
	local AllowDuplicateMountCBChange = function()
		MM.Mounts.AllowDuplicates = ConfigUI.Frame.General.AllowDuplicateMountCB:GetChecked()
	end
	
	local ForceUniqueMountSummonCBChange = function()
		MM.Mounts.UniqueSummon = ConfigUI.Frame.General.ForceUniqueMountSummonCB:GetChecked()
	end
	
	local ShowMountTextCBChange = function()
		MM.Mounts.ShowText = ConfigUI.Frame.General.ShowMountTextCB:GetChecked()
	end

	local DisplayMountIconCBChange = function()
		MM.Mounts.DisplayIcon = ConfigUI.Frame.General.DisplayMountIconCB:GetChecked()
		if not MM.Mounts.DisplayIcon then mmUI.Main.MountIcon:SetTexture("MountMe", "images/MountMeIcon.png") end
	end
	
	local ShowPetButtonCBChange = function()
		MM.Pets.ShowUI = ConfigUI.Frame.General.ShowPetButtonCB:GetChecked()
		mmUI.Main:ToggleButton("pet", MM.Pets.ShowUI)
	end

	local AllowDuplicatePetCBChange = function()
		MM.Pets.AllowDuplicates = ConfigUI.Frame.General.AllowDuplicatePetCB:GetChecked()
	end
	
	local ForceUniquePetSummonCBChange = function()
		MM.Pets.UniqueSummon = ConfigUI.Frame.General.ForceUniquePetSummonCB:GetChecked()
	end

	local ShowPetTextCBChange = function()
		MM.Pets.ShowText = ConfigUI.Frame.General.ShowPetTextCB:GetChecked()
	end
	
	local DisplayPetIconCBChange = function()
		MM.Pets.DisplayIcon = ConfigUI.Frame.General.DisplayPetIconCB:GetChecked()
		if not MM.Pets.DisplayIcon then mmUI.Main.PetIcon:SetTexture("MountMe", "images/PetMeIcon.png") end
	end
	
	_retGeneral.GeneralLabel = UI.CreateFrame("Text", "GeneralLabel", _tab)
	_retGeneral.GeneralLabel:SetText("General")
	_retGeneral.GeneralLabel:SetPoint("TOPLEFT", _tab, "TOPLEFT", 5, 10)
	
	_retGeneral.LockUICB = UI.CreateFrame("RiftCheckbox", "LockUICB", _tab)
	_retGeneral.LockUICB:EventAttach(Event.UI.Checkbox.Change, function() LockUICBChange() end , "Config.LockUICBChange")
	_retGeneral.LockUICB:SetPoint("TOPLEFT", _retGeneral.GeneralLabel, "BOTTOMLEFT", 20, 0)
	_retGeneral.LockUIText = UI.CreateFrame("Text", "LockUIText", _tab)
	_retGeneral.LockUIText:SetText("Lock Buttons")
	_retGeneral.LockUIText:SetPoint("TOPLEFT", _retGeneral.LockUICB, "TOPRIGHT", 0, -1)
	
	_retGeneral.MountFirstCB = UI.CreateFrame("RiftCheckbox", "MountFirstCB", _tab)
	_retGeneral.MountFirstCB:EventAttach(Event.UI.Checkbox.Change, function() MountFirstCBChange() end, "Config.ShowMountButtonCBChange")
	_retGeneral.MountFirstCB:SetPoint("TOPLEFT", _retGeneral.LockUICB, "BOTTOMLEFT", 0, 0)
	_retGeneral.MountFirstText = UI.CreateFrame("Text", "MountFirstText", _tab)
	_retGeneral.MountFirstText:SetText("Mount Button First")
	_retGeneral.MountFirstText:SetPoint("TOPLEFT", _retGeneral.MountFirstCB, "TOPRIGHT", 0, -1)
	
	_retGeneral.VerticleUICB = UI.CreateFrame("RiftCheckbox", "VerticleUICB", _tab)
	_retGeneral.VerticleUICB:EventAttach(Event.UI.Checkbox.Change, function() VerticleUICBChange() end, "Config.ShowMountButtonCBChange")
	_retGeneral.VerticleUICB:SetPoint("TOPLEFT", _retGeneral.MountFirstCB, "BOTTOMLEFT", 0, 0)
	_retGeneral.VerticleUIText = UI.CreateFrame("Text", "VerticleUIText", _tab)
	_retGeneral.VerticleUIText:SetText("Verticle UI")
	_retGeneral.VerticleUIText:SetPoint("TOPLEFT", _retGeneral.VerticleUICB, "TOPRIGHT", 0, -1)
	
	_retGeneral.ScaleUISliderLabel = UI.CreateFrame("Text", "ScaleUISliderLabel", _tab)
	_retGeneral.ScaleUISliderLabel:SetText("Sale UI")
	_retGeneral.ScaleUISliderLabel:SetPoint("TOPLEFT", _retGeneral.VerticleUICB, "BOTTOMLEFT", 0, 0)
	_retGeneral.ScaleUISlider = UI.CreateFrame("RiftSlider", "ScaleUISlider", _tab)
	_retGeneral.ScaleUISlider:SetWidth(100)
	_retGeneral.ScaleUISlider:SetRange(10, 200)
	_retGeneral.ScaleUISlider:SetPosition(MM.ScaleUI)
	_retGeneral.ScaleUISlider:SetPoint("TOPLEFT", _retGeneral.ScaleUISliderLabel, "TOPRIGHT", 5, 6)
	_retGeneral.ScaleUISlider:EventAttach(Event.UI.Slider.Change, function() ScaleUISliderChange() end, "Config.ScaleUISliderChange")
	_retGeneral.ScaleUISliderValue = UI.CreateFrame("Text", "ScaleUISliderValue", _tab)
	_retGeneral.ScaleUISliderValue:SetText(tostring(MM.ScaleUI))
	_retGeneral.ScaleUISliderValue:SetPoint("TOPLEFT", _retGeneral.ScaleUISlider, "TOPRIGHT", 5, -6)	
	
	_retGeneral.MountLabel = UI.CreateFrame("Text", "MountLabel", _tab)
	_retGeneral.MountLabel:SetText("Mounts")
	_retGeneral.MountLabel:SetPoint("TOPLEFT", _retGeneral.ScaleUISliderLabel, "BOTTOMLEFT", -20, 10)

	_retGeneral.ShowMountButtonCB = UI.CreateFrame("RiftCheckbox", "ShowMountButtonCB", _tab)
	_retGeneral.ShowMountButtonCB:EventAttach(Event.UI.Checkbox.Change, function() ShowMountButtonCBChange() end, "Config.ShowMountButtonCBChange")
	_retGeneral.ShowMountButtonCB:SetPoint("TOPLEFT", _retGeneral.MountLabel, "BOTTOMLEFT", 20, 0)
	_retGeneral.ShowMountButtonText = UI.CreateFrame("Text", "ShowMountButtonText", _tab)
	_retGeneral.ShowMountButtonText:SetText("Show Mount Button")
	_retGeneral.ShowMountButtonText:SetPoint("TOPLEFT", _retGeneral.ShowMountButtonCB, "TOPRIGHT", 0, -1)
	
	_retGeneral.ShowMountTextCB = UI.CreateFrame("RiftCheckbox", "ShowMountTextCB", _tab)
	_retGeneral.ShowMountTextCB:EventAttach(Event.UI.Checkbox.Change, function() ShowMountTextCBChange() end, "Config.ShowMountTextCB")
	_retGeneral.ShowMountTextCB:SetPoint("TOPLEFT", _retGeneral.ShowMountButtonCB, "BOTTOMLEFT", 0, 0)
	_retGeneral.ShowMountText = UI.CreateFrame("Text", "ShowMountText", _tab)
	_retGeneral.ShowMountText:SetText("Show Mount Text")
	_retGeneral.ShowMountText:SetPoint("TOPLEFT", _retGeneral.ShowMountTextCB, "TOPRIGHT", 0, -1)
	
	_retGeneral.ForceUniqueMountSummonCB = UI.CreateFrame("RiftCheckbox", "ForceUniqueMountSummonCB", _tab)
	_retGeneral.ForceUniqueMountSummonCB:EventAttach(Event.UI.Checkbox.Change, function() ForceUniqueMountSummonCBChange() end, "Config.ForceUniqueMountSummonCBChange")
	_retGeneral.ForceUniqueMountSummonCB:SetPoint("TOPLEFT", _retGeneral.ShowMountTextCB, "BOTTOMLEFT", 0, 0)
	_retGeneral.ForceUniqueMountSummonText = UI.CreateFrame("Text", "ForceUniqueMountSummonText", _tab)
	_retGeneral.ForceUniqueMountSummonText:SetText("Force Unique Mount Summons")
	_retGeneral.ForceUniqueMountSummonText:SetPoint("TOPLEFT", _retGeneral.ForceUniqueMountSummonCB, "TOPRIGHT", 0, -1)
	
	_retGeneral.AllowDuplicateMountCB = UI.CreateFrame("RiftCheckbox", "AllowDuplicateMountCB", _tab)
	_retGeneral.AllowDuplicateMountCB:EventAttach(Event.UI.Checkbox.Change, function() AllowDuplicateMountCBChange() end, "Config.AllowDuplicateMountCBChange")
	_retGeneral.AllowDuplicateMountCB:SetPoint("TOPLEFT", _retGeneral.ForceUniqueMountSummonCB, "BOTTOMLEFT", 0, 0)
	_retGeneral.AllowDuplicateMountText = UI.CreateFrame("Text", "AllowDuplicateMountText", _tab)
	_retGeneral.AllowDuplicateMountText:SetText("Allow Duplicate Mounts")
	_retGeneral.AllowDuplicateMountText:SetPoint("TOPLEFT", _retGeneral.AllowDuplicateMountCB, "TOPRIGHT", 0, -1)

	_retGeneral.DisplayMountIconCB = UI.CreateFrame("RiftCheckbox", "DisplayMountIconCB", _tab)
	_retGeneral.DisplayMountIconCB:EventAttach(Event.UI.Checkbox.Change, function() DisplayMountIconCBChange() end, "Config.DisplayMountIconCBChange")
	_retGeneral.DisplayMountIconCB:SetPoint("TOPLEFT", _retGeneral.AllowDuplicateMountCB, "BOTTOMLEFT", 0, 0)
	_retGeneral.DisplayMountIconText = UI.CreateFrame("Text", "DisplayMountIconText", _tab)
	_retGeneral.DisplayMountIconText:SetText("Show Current Mount Icon")
	_retGeneral.DisplayMountIconText:SetPoint("TOPLEFT", _retGeneral.DisplayMountIconCB, "TOPRIGHT", 0, -1)	
	
	_retGeneral.PetLabel = UI.CreateFrame("Text", "PetLabel", _tab)
	_retGeneral.PetLabel:SetText("Pets")
	_retGeneral.PetLabel:SetPoint("TOPLEFT", _retGeneral.DisplayMountIconCB, "BOTTOMLEFT", -20, 10)

	_retGeneral.ShowPetButtonCB = UI.CreateFrame("RiftCheckbox", "ShowPetButtonCB", _tab)
	_retGeneral.ShowPetButtonCB:EventAttach(Event.UI.Checkbox.Change, function() ShowPetButtonCBChange() end, "Config.ShowPetButtonCBChange")
	_retGeneral.ShowPetButtonCB:SetPoint("TOPLEFT", _retGeneral.PetLabel, "BOTTOMLEFT", 20, 0)
	_retGeneral.ShowPetButtonText = UI.CreateFrame("Text", "ShowPetButtonText", _tab)
	_retGeneral.ShowPetButtonText:SetText("Show Pet Button")
	_retGeneral.ShowPetButtonText:SetPoint("TOPLEFT", _retGeneral.ShowPetButtonCB, "TOPRIGHT", 0, -1)
	
	_retGeneral.ShowPetTextCB = UI.CreateFrame("RiftCheckbox", "ShowPetTextCB", _tab)
	_retGeneral.ShowPetTextCB:EventAttach(Event.UI.Checkbox.Change, function() ShowPetTextCBChange() end, "Config.ShowPetTextCBChange")
	_retGeneral.ShowPetTextCB:SetPoint("TOPLEFT", _retGeneral.ShowPetButtonCB, "BOTTOMLEFT", 0, 0)
	_retGeneral.ShowPetText = UI.CreateFrame("Text", "ShowPetText", _tab)
	_retGeneral.ShowPetText:SetText("Show Pet Text")
	_retGeneral.ShowPetText:SetPoint("TOPLEFT", _retGeneral.ShowPetTextCB, "TOPRIGHT", 0, -1)
	
	_retGeneral.ForceUniquePetSummonCB = UI.CreateFrame("RiftCheckbox", "ForceUniquePetSummonCB", _tab)
	_retGeneral.ForceUniquePetSummonCB:EventAttach(Event.UI.Checkbox.Change, function() ForceUniquePetSummonCBChange() end, "Config.ForceUniquePetSummonCBChange")
	_retGeneral.ForceUniquePetSummonCB:SetPoint("TOPLEFT", _retGeneral.ShowPetTextCB, "BOTTOMLEFT", 0, 0)
	_retGeneral.ForceUniquePetSummonText = UI.CreateFrame("Text", "ForceUniquePetSummonText", _tab)
	_retGeneral.ForceUniquePetSummonText:SetText("Force Unique Pet Summons")
	_retGeneral.ForceUniquePetSummonText:SetPoint("TOPLEFT", _retGeneral.ForceUniquePetSummonCB, "TOPRIGHT", 0, -1)
	
	_retGeneral.AllowDuplicatePetCB = UI.CreateFrame("RiftCheckbox", "AllowDuplicatePetCB", _tab)
	_retGeneral.AllowDuplicatePetCB:EventAttach(Event.UI.Checkbox.Change, function() AllowDuplicatePetCBChange() end, "Config.AllowDuplicatePetCBChange")
	_retGeneral.AllowDuplicatePetCB:SetPoint("TOPLEFT", _retGeneral.ForceUniquePetSummonCB, "BOTTOMLEFT", 0, 0)
	_retGeneral.AllowDuplicatePetText = UI.CreateFrame("Text", "AllowDuplicatePetText", _tab)
	_retGeneral.AllowDuplicatePetText:SetText("Allow Duplicate Pets")
	_retGeneral.AllowDuplicatePetText:SetPoint("TOPLEFT", _retGeneral.AllowDuplicatePetCB, "TOPRIGHT", 0, -1)
	
	_retGeneral.DisplayPetIconCB = UI.CreateFrame("RiftCheckbox", "DisplayPetIconCB", _tab)
	_retGeneral.DisplayPetIconCB:EventAttach(Event.UI.Checkbox.Change, function() DisplayPetIconCBChange() end, "Config.AllowDuplicatePetCBChange")
	_retGeneral.DisplayPetIconCB:SetPoint("TOPLEFT", _retGeneral.AllowDuplicatePetCB, "BOTTOMLEFT", 0, 0)
	_retGeneral.DisplayPetIconText = UI.CreateFrame("Text", "DisplayPetIconText", _tab)
	_retGeneral.DisplayPetIconText:SetText("Show Current Pet Icon")
	_retGeneral.DisplayPetIconText:SetPoint("TOPLEFT", _retGeneral.DisplayPetIconCB, "TOPRIGHT", 0, -1)
	
	return _retGeneral
end

local function BuildConfigUIMounts(_tab)
	local _retMount = {}

	_retMount.DragDropBorder = UI.CreateFrame("Frame", "Config.MountDropFrameBorder", _tab)
	_retMount.DragDropBorder:SetWidth(66)
	_retMount.DragDropBorder:SetHeight(66)
	_retMount.DragDropBorder:SetLayer(1)
	_retMount.DragDropBorder:SetPoint("TOPLEFT", _tab, "TOPLEFT", 5, 5)
	_retMount.DragDropBorder:SetBackgroundColor(.6,.6,.6, .3)
	
	_retMount.DragDrop = UI.CreateFrame("Texture", "Config.MountDropFrame", _retMount.DragDropBorder)
	_retMount.DragDrop:SetWidth(58)
	_retMount.DragDrop:SetHeight(58)
	_retMount.DragDrop:SetLayer(2)
	_retMount.DragDrop:SetPoint("TOPLEFT", _retMount.DragDropBorder, "TOPLEFT", 4, 4)
	_retMount.DragDrop:SetBackgroundColor(.6,.6,.6, .3)
	_retMount.DragDrop:EventAttach(Event.UI.Input.Mouse.Left.Up, function(_self, h) 
			_self.Override:SetVisible(false)
			_self.Override.Value = false
			_self.Override.Item = nil	
			DragDrop(_self, "mount") 
		end, "Config.MountDragDrop_Drop")
	
	_retMount.DragDrop.Override = UI.CreateFrame("Frame", "Config.MountDropFrame.Override", _retMount.DragDrop)
	_retMount.DragDrop.Override:SetWidth(293)
	_retMount.DragDrop.Override:SetHeight(66)
	_retMount.DragDrop.Override:SetLayer(10)
	_retMount.DragDrop.Override:SetPoint("TOPLEFT", _retMount.DragDropBorder, "TOPRIGHT", 3, 0)
	_retMount.DragDrop.Override:SetBackgroundColor(0, 0, 0, 1)
	_retMount.DragDrop.Override:SetVisible(false)
	
	_retMount.DragDrop.Override.Value = false
	_retMount.DragDrop.Override.Item = nil
	
	_retMount.DragDrop.Override.Message = UI.CreateFrame("Text", "Config.MountDropFrame.Override.Message", _retMount.DragDrop.Override)
	_retMount.DragDrop.Override.Message:SetWordwrap(true)
	_retMount.DragDrop.Override.Message:SetText("Trion has not categorized this item as a mount.  Do you wish to add anyway?")
	_retMount.DragDrop.Override.Message:SetPoint("TOPLEFT", _retMount.DragDrop.Override, "TOPLEFT")
	_retMount.DragDrop.Override.Message:SetPoint("BOTTOMRIGHT", _retMount.DragDrop.Override, "BOTTOMRIGHT", 0, -20)
	
	_retMount.DragDrop.Override.No = UI.CreateFrame("Text", "Config.MountDropFrame.Override.No", _retMount.DragDrop.Override)
	_retMount.DragDrop.Override.No:SetText("No")
	_retMount.DragDrop.Override.No:SetPoint("BOTTOMLEFT", _retMount.DragDrop.Override, "BOTTOMLEFT", 2, -2)
	_retMount.DragDrop.Override.No:EventAttach(Event.UI.Input.Mouse.Left.Click, function(_self) 
			local _par = _self:GetParent()
			_par:SetVisible(false)
			_par.Item = nil
			_par.Value = false
		end, "Config.MountDragDrop.Override.No")
	
	_retMount.DragDrop.Override.Yes = UI.CreateFrame("Text", "Config.MountDropFrame.Override.Yes", _retMount.DragDrop.Override)
	_retMount.DragDrop.Override.Yes:SetText("Yes")
	_retMount.DragDrop.Override.Yes:SetPoint("TOPLEFT", _retMount.DragDrop.Override.No, "TOPRIGHT", 15, 0)
	_retMount.DragDrop.Override.Yes:EventAttach(Event.UI.Input.Mouse.Left.Click, function(_self, h) 
			local _par = _self:GetParent()
			_par = _par:GetParent()
			_par.Override.Value = true
			DragDrop(_par, "mount") 
		end, "Config.MountDragDrop.Override.Yes")

	_retMount.DragDropText = UI.CreateFrame("Text", "Config.DragDropText", _retMount.DragDrop)
	_retMount.DragDropText:SetText("Drag\nDrop")
	_retMount.DragDropText:SetPoint("CENTER", _retMount.DragDrop, "CENTER", 0, 0)
		
	_retMount.Text1 = UI.CreateFrame("Text", "Config.MountText1", _tab)
	_retMount.Text1:SetText("Name")
	_retMount.Text1:SetPoint("TOPLEFT", _retMount.DragDrop, "TOPRIGHT", 5, -5)
	
	_retMount.Text2 = UI.CreateFrame("Text", "Config.MountText2", _tab)
	_retMount.Text2:SetText("Description")
	_retMount.Text2:SetWordwrap(true)
	_retMount.Text2:SetWidth(300)
	_retMount.Text2:SetHeight(60)
	_retMount.Text2:SetPoint("TOPLEFT", _retMount.Text1, "BOTTOMLEFT", 0, 0)
	
	_retMount.List = UI.CreateFrame("SimpleScrollList", "Config.MountList", _tab)
	_retMount.List:SetBackgroundColor(.6,.6,.6, .3)
	_retMount.List:SetPoint("TOPLEFT", _retMount.DragDrop, "BOTTOMLEFT", -3, 10)
	_retMount.List:SetPoint("BOTTOMRIGHT", _tab, "BOTTOMRIGHT", -5, -32)
	_retMount.List.Event.ItemSelect = function(_itm) LoadItemFromList(MM.Mounts.List, ConfigUI.Frame.Mounts, "mount") end
	
	_retMount.Delete = UI.CreateFrame("Text", "Config.MountDropFrame", _retMount.DragDrop)
	_retMount.Delete:SetText("[--DELETE--]")
	_retMount.Delete:SetBackgroundColor(1, 1, 1, .5)
	_retMount.Delete:SetFontColor(0, 0, 0, 1)
	_retMount.Delete:SetLayer(1)
	_retMount.Delete:SetPoint("TOPCENTER", _retMount.List, "BOTTOMCENTER", 0, 7)
	_retMount.Delete:EventAttach(Event.UI.Input.Mouse.Left.Click, function(_self, h) DeleteItemFromList(MM.Mounts.List, ConfigUI.Frame.Mounts) 
																LoadItems(MM.Mounts.List, ConfigUI.Frame.Mounts, "mount") end, "Config.DeleteMount")
	
	return _retMount
end

local function BuildConfigUIPets(_tab)
	local _retPet = {}

	_retPet.DragDropBorder = UI.CreateFrame("Frame", "Config.PetDropFrameBorder", _tab)
	_retPet.DragDropBorder:SetWidth(66)
	_retPet.DragDropBorder:SetHeight(66)
	_retPet.DragDropBorder:SetLayer(1)
	_retPet.DragDropBorder:SetPoint("TOPLEFT", _tab, "TOPLEFT", 5, 5)
	_retPet.DragDropBorder:SetBackgroundColor(.6,.6,.6, .3)

	_retPet.DragDrop = UI.CreateFrame("Texture", "Config.PetDropFrame", _retPet.DragDropBorder)
	_retPet.DragDrop:SetWidth(58)
	_retPet.DragDrop:SetHeight(58)
	_retPet.DragDrop:SetLayer(2)
	_retPet.DragDrop:SetPoint("TOPLEFT", _retPet.DragDropBorder, "TOPLEFT", 4, 4)
	_retPet.DragDrop:SetBackgroundColor(.6,.6,.6, .3)
	_retPet.DragDrop:EventAttach(Event.UI.Input.Mouse.Left.Up, function(_self, h) 
			_self.Override:SetVisible(false)
			_self.Override.Value = false
			_self.Override.Item = nil
			DragDrop(_self, "pet") 
	end, "Config.PetDragDrop_Drop")

	_retPet.DragDrop.Override = UI.CreateFrame("Frame", "Config.PetDropFrame.Override", _retPet.DragDrop)
	_retPet.DragDrop.Override:SetWidth(293)
	_retPet.DragDrop.Override:SetHeight(66)
	_retPet.DragDrop.Override:SetLayer(10)
	_retPet.DragDrop.Override:SetPoint("TOPLEFT", _retPet.DragDropBorder, "TOPRIGHT", 3, 0)
	_retPet.DragDrop.Override:SetBackgroundColor(0, 0, 0, 1)
	_retPet.DragDrop.Override:SetVisible(false)
	
	_retPet.DragDrop.Override.Value = false
	_retPet.DragDrop.Override.Item = nil
	
	_retPet.DragDrop.Override.Message = UI.CreateFrame("Text", "Config.PetDropFrame.Override.Message", _retPet.DragDrop.Override)
	_retPet.DragDrop.Override.Message:SetWordwrap(true)
	_retPet.DragDrop.Override.Message:SetText("Trion has not categorized this item as a companion.  Do you wish to add anyway?")
	_retPet.DragDrop.Override.Message:SetPoint("TOPLEFT", _retPet.DragDrop.Override, "TOPLEFT")
	_retPet.DragDrop.Override.Message:SetPoint("BOTTOMRIGHT", _retPet.DragDrop.Override, "BOTTOMRIGHT", 0, -20)
	
	_retPet.DragDrop.Override.No = UI.CreateFrame("Text", "Config.PetDropFrame.Override.No", _retPet.DragDrop.Override)
	_retPet.DragDrop.Override.No:SetText("No")
	_retPet.DragDrop.Override.No:SetPoint("BOTTOMLEFT", _retPet.DragDrop.Override, "BOTTOMLEFT", 2, -2)
	_retPet.DragDrop.Override.No:EventAttach(Event.UI.Input.Mouse.Left.Click, function(_self) 
			local _par = _self:GetParent()
			_par:SetVisible(false)
			_par.Item = nil
			_par.Value = false
		end, "Config.PetDragDrop.Override.No")
	
	_retPet.DragDrop.Override.Yes = UI.CreateFrame("Text", "Config.PetDropFrame.Override.Yes", _retPet.DragDrop.Override)
	_retPet.DragDrop.Override.Yes:SetText("Yes")
	_retPet.DragDrop.Override.Yes:SetPoint("TOPLEFT", _retPet.DragDrop.Override.No, "TOPRIGHT", 15, 0)
	_retPet.DragDrop.Override.Yes:EventAttach(Event.UI.Input.Mouse.Left.Click, function(_self, h) 
			local _par = _self:GetParent()
			_par = _par:GetParent()
			_par.Override.Value = true
			DragDrop(_par, "pet") 
		end, "Config.PetDragDrop.Override.Yes")	
	
	_retPet.DragDropText = UI.CreateFrame("Text", "Config.DragDropText", _retPet.DragDrop)
	_retPet.DragDropText:SetText("Drag\nDrop")
	_retPet.DragDropText:SetPoint("CENTER", _retPet.DragDrop, "CENTER", 0, 0)
		
	_retPet.Text1 = UI.CreateFrame("Text", "Config.PetText1", _tab)
	_retPet.Text1:SetText("Name")
	_retPet.Text1:SetPoint("TOPLEFT", _retPet.DragDrop, "TOPRIGHT", 5, -5)
	
	_retPet.Text2 = UI.CreateFrame("Text", "Config.PetText2", _tab)
	_retPet.Text2:SetText("Description")
	_retPet.Text2:SetWordwrap(true)
	_retPet.Text2:SetWidth(300)
	_retPet.Text2:SetHeight(40)
	_retPet.Text2:SetPoint("TOPLEFT", _retPet.Text1, "BOTTOMLEFT", 0, 0)
	
	_retPet.List = UI.CreateFrame("SimpleScrollList", "Config.PetList", _tab)
	_retPet.List:SetBackgroundColor(.6,.6,.6, .3)
	_retPet.List:SetPoint("TOPLEFT", _retPet.DragDrop, "BOTTOMLEFT", -3, 10)
	_retPet.List:SetPoint("BOTTOMRIGHT", _tab, "BOTTOMRIGHT", -5, -32)
	_retPet.List.Event.ItemSelect = function(_itm) LoadItemFromList(MM.Pets.List, ConfigUI.Frame.Pets, "pet") end
	
	_retPet.Delete = UI.CreateFrame("Text", "Config.PetDropFrame", _retPet.DragDrop)
	_retPet.Delete:SetText("[--DELETE--]")
	_retPet.Delete:SetBackgroundColor(1, 1, 1, .5)
	_retPet.Delete:SetFontColor(0, 0, 0, 1)
	_retPet.Delete:SetLayer(1)
	_retPet.Delete:SetPoint("TOPCENTER", _retPet.List, "BOTTOMCENTER", 0, 7)
	_retPet.Delete:EventAttach(Event.UI.Input.Mouse.Left.Click, function(_self, h) DeleteItemFromList(MM.Pets.List, ConfigUI.Frame.Pets) 
																LoadItems(MM.Pets.List, ConfigUI.Frame.Pets, "pet") end, "Config.DeletePet")
	
	return _retPet
end

local function BuildUI(_context, _data)
	local _ret = {}
	
	_ret.Frame = UI.CreateFrame("SimpleWindow", "ConfigMain", _context)
	_ret.Frame:SetVisible(false)
    _ret.Frame:SetCloseButtonVisible(true)
    _ret.Frame:SetTitle("Mount Me - Config")
	_ret.Frame:SetHeight(600)
    _ret.Frame:SetPoint("TOPLEFT", UIParent, "TOPLEFT", _data.Config_x, _data.Config_y)

	_ret.Frame.TabView = UI.CreateFrame("SimpleTabView", "TabView", _ret.Frame)
	_ret.Frame.TabView:SetTabPosition("top")
	_ret.Frame.TabView:SetPoint("TOPLEFT", _ret.Frame:GetContent(), "TOPLEFT", 0, 0)
	_ret.Frame.TabView:SetPoint("BOTTOMRIGHT", _ret.Frame:GetContent(), "BOTTOMRIGHT", 0, 0)

	_ret.Frame.Tab1 = UI.CreateFrame("Frame", "Tab1", _ret.Frame.TabView)
	_ret.Frame.Tab2 = UI.CreateFrame("Frame", "Tab2", _ret.Frame.TabView)
	_ret.Frame.Tab3 = UI.CreateFrame("Frame", "Tab3", _ret.Frame.TabView)

	_ret.Frame.TabView:AddTab("General", _ret.Frame.Tab1)
	_ret.Frame.TabView:AddTab("Mounts", _ret.Frame.Tab2)
	_ret.Frame.TabView:AddTab("Pets", _ret.Frame.Tab3)

	_ret.Frame.General = {}
	_ret.Frame.General = BuildConfigUIGeneral(_ret.Frame.Tab1)
	
	_ret.Frame.Mounts = {}
	_ret.Frame.Mounts = BuildConfigUIMounts(_ret.Frame.Tab2)
	
	_ret.Frame.Pets = {}
	_ret.Frame.Pets = BuildConfigUIPets(_ret.Frame.Tab3)
	
	_ret.SetVisible = function(_self, bShow, tab)
		if bShow then
			LoadItems(MM.Mounts.List, ConfigUI.Frame.Mounts, "mount")
			LoadItems(MM.Pets.List, ConfigUI.Frame.Pets, "pet")
			LoadGeneral()
			--_ret.BackGroundColor = LoadColorChooser(_self.Frame)
			--_ret.BackGroundColor:Show()
		else
			_data.Config_x = _self.Frame:GetLeft()
			_data.Config_y = _self.Frame:GetTop()
		end
		if tab then _self.Frame.TabView:SetActiveTab(tab) end
		_self.Frame:SetVisible(bShow)
	end	
	
	_ret.GetVisible = function(_self)
		return _self.Frame:GetVisible()
	end

	return _ret
end

function BuildConfigUI(_data, _mmUI)
	MM = _data
	mmUI = _mmUI
	ConfigUI = BuildUI(_mmUI.Context, _data)
	return ConfigUI
end