-- ****************************************************************************

function SlashCommandsRegister()

	table.insert(Command.Slash.Register("bookofdeath"), {commandline, "zDeathBook", "commandline"})
	table.insert(Command.Slash.Register("bod"), {commandline, "zDeathBook", "commandline"})
	table.insert(Command.Slash.Register("zdeathbook"), {commandline, "zDeathBook", "commandline"})

end
-- ****************************************************************************

function commandline(line)

	local params = string.lower(line)

	if (params == "") then
		print("")
		print("Book of Death  v1.1.4  - By Rothiel")
		print("   /bod show     = Show the Book")
		print("   /bod hide     = Hide the Book")
		print("   /bod toggle   = Toggle the Book")
		print("   /bod clear    = Clear the Book")
		print("")
	elseif (params == "show") then
		zcontext.textframe:SetVisible(true)
		zcontext.window:SetVisible(true)
	elseif (params == "hide") then
		zcontext.textframe:SetVisible(false)
		zcontext.window:SetVisible(false)
	elseif (params == "toggle") then
		local value = not zcontext.textframe:GetVisible()
		zcontext.textframe:SetVisible(value)
		if (value == false) then
			zcontext.window:SetVisible(value)
		else
			zcontext.window:SetVisible(zcontext.bookvisible)
		end
	elseif (params == "clear") then
		zcontext.deathlist = {}
		SetText("Book of Death - by Rothiel")
	elseif (params == "test") then
		SetTextWithColor("You killed Kenny", 1.0, 0.25, 0.25, 1)
	end

end

-- ****************************************************************************
