-- ****************************************************************************

function BuffAddHandler(unit, buffs)

	if ((unit ~= nil) and (buffs ~= nil)) then
		local unitspecifier = Inspect.Unit.Lookup(unit)
		
		-- Only worry abour buffs that are added to the player
		if (unitspecifier == "player") then
			local buffdetails = Inspect.Buff.Detail(unitspecifier, buffs)

			-- Step through the buff list table and print information on each one --
			for k, v in pairs(buffdetails) do

				local name = v.name
				local caster = v.caster
				local style = "buff"
				
				if (v.debuff) then 
					style = "debuff"
				end
				
				if ((name ~= nil) and (caster ~= nil)) then
					local casterdetail = Inspect.Unit.Detail(caster)
					
					if (casterdetail ~= nil) then
					
						local castername = casterdetail.name

						if (style == "debuff") then
							-- print ("DEBUFF: " .. name .. " by " .. castername)
						else
							-- print (name .. " by " .. castername)
						end
					
						-- There is also duration
					end
				end
			end
		end
	end
	
end

-- ****************************************************************************
