-- ****************************************************************************

zcontext = {
	guicontext = nil,
	textframe = nil,
	textframe_timestamp = 0,
	bookvisible = false,
	summaryframe = nil,
	configframe = nil,
	bookframe = nil,
	label_score = nil,
	label_totalkills = nil,
	label_uniquekills = nil,
	label_totaldeaths = nil,
	label_mostkilled = nil,
	label_mostdeaths = nil,
	label_lastkill = nil,
	label_lastdeath = nil,
	label_ktd = nil,
	label_pages = nil,
	label_book = {},
	book_currentpage = 0,
	window = nil,
	deathlist = {}, 
	sortby = "score",
	sortdirection = "descending",
	recordmobs = false,
	lastdeath = "",
	lastkill = "",
	}

-- ****************************************************************************

function killedEventHandler(param)

	if ((param ~= nil) and (param.target ~= nil) and (param.caster ~= nil)) then
		local corpse, corpsename, killer, killername

		corpse = Inspect.Unit.Detail(param.target)
		killer = Inspect.Unit.Detail(param.caster)

		self = Inspect.Unit.Lookup('player')

		-- only process for player kills or deaths
		if ((corpse ~= nil) and (killer ~= nil) and ((param.target == self) or (param.caster == self)) ) then
	
			corpsename = corpse.name
			killername = killer.name

			-- Do not allow yourself to kill yourself
			if (corpsename ~= killername) then

				-- Check if monster kills should be recorded
				local mob = (corpse.player ~= true) or (killer.player ~= true)
				if ((zcontext.recordmobs == true) or (mob == false)) then
					if ((corpsename ~= nil) and (killername ~= nil)) then
						
						-- Create the ID
						local recordid
						if (self == param.caster) then
							recordid = corpsename
						else
							recordid = killername
						end
										
						-- Check if there isn't already a record
						if (zcontext.deathlist[recordid] == nil) then
							record = {}
							record.name = recordid
							record.kills= 0
							record.deaths = 0
							record.score = 0
							record.calling = ""
							record.level = 0
							record.guild = ""
							zcontext.deathlist[recordid] = record
						end
						
						-- A player kill
						if (self == param.caster) then
							record = zcontext.deathlist[recordid]
							record.kills = record.kills + 1
							record.score = record.score + 1
							if (corpse.calling) then 
								record.calling = corpse.calling
							end
							if (corpse.level) then
								record.level = corpse.level
							end
							if (corpse.guild) then
								record.guild = corpse.guild
							end
						-- A player death
						elseif (self == param.target) then
							record = zcontext.deathlist[recordid]
							record.deaths = record.deaths + 1
							record.score = record.score - 1
							if (killer.calling) then
								record.calling = killer.calling
							end
							if (killer.level) then
								record.level = killer.level
							end
							if (killer.guild) then
								record.guild = killer.guild
							end
						end

						-- Display individual death
						if (self == param.caster) then
							local message = "You killed " .. corpsename
							SetTextWithColor(message, 0.25, 1.0, 0.25, 1)
							zcontext.lastkill = corpsename
						else
							local message = killername .. " killed you"
							SetTextWithColor(message, 1.0, 0.25, 0.25, 1)
							zcontext.lastdeath = killername
						end
					end
				end
			end
		end
	end

end

-- ****************************************************************************

function Save(addon)
	if (addon == "zDeathBook") then
		if (zcontext.deathlist) then
			zDeathBook_book = zcontext.deathlist
			zDeathBook_lastkill = zcontext.lastkill
			zDeathBook_lastdeath = zcontext.lastdeath
		end
	end
end

-- ****************************************************************************

function Load(addon)
	if (addon == "zDeathBook") then
		
		-- Death List data
		zcontext.deathlist = {}
		if (zDeathBook_book) then
			zcontext.deathlist = zDeathBook_book
		end
		
		-- Line Item Data
		if (zDeathBook_lastkill) then
			zcontext.lastkill = zDeathBook_lastkill
		end
		
		if (zDeathBook_lastdeath) then
			zcontext.lastdeath = zDeathBook_lastdeath
		end
		
	end
end

-- ****************************************************************************
